/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide;

import com.intellij.ide.ActivityTracker;
import com.intellij.ide.ApplicationActivationStateManager;
import com.intellij.ide.IdeKeyboardFocusManager;
import com.intellij.ide.IdePopupManager;
import com.intellij.ide.ToolkitBugsProcessor;
import com.intellij.ide.actions.MaximizeActiveDialogAction;
import com.intellij.ide.dnd.DnDManager;
import com.intellij.ide.dnd.DnDManagerImpl;
import com.intellij.ide.plugins.PluginManager;
import com.intellij.ide.ui.UISettings;
import com.intellij.idea.IdeaApplication;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.KeyboardShortcut;
import com.intellij.openapi.actionSystem.Shortcut;
import com.intellij.openapi.application.AccessToken;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.application.TransactionGuard;
import com.intellij.openapi.application.TransactionGuardImpl;
import com.intellij.openapi.application.impl.LaterInvocator;
import com.intellij.openapi.diagnostic.FrequentEventDetector;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.keymap.KeymapManager;
import com.intellij.openapi.keymap.impl.IdeKeyEventDispatcher;
import com.intellij.openapi.keymap.impl.IdeMouseEventDispatcher;
import com.intellij.openapi.keymap.impl.KeyState;
import com.intellij.openapi.ui.JBPopupMenu;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.EmptyRunnable;
import com.intellij.openapi.util.ExpirableRunnable;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.wm.IdeFocusManager;
import com.intellij.openapi.wm.IdeFrame;
import com.intellij.openapi.wm.WindowManager;
import com.intellij.openapi.wm.ex.WindowManagerEx;
import com.intellij.openapi.wm.impl.FocusManagerImpl;
import com.intellij.ui.mac.touchbar.TouchBarsManager;
import com.intellij.util.Alarm;
import com.intellij.util.ReflectionUtil;
import com.intellij.util.concurrency.AppExecutorUtil;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.io.storage.HeavyProcessLatch;
import com.intellij.util.ui.UIUtil;
import java.awt.AWTEvent;
import java.awt.AWTException;
import java.awt.Component;
import java.awt.EventQueue;
import java.awt.KeyboardFocusManager;
import java.awt.Robot;
import java.awt.Toolkit;
import java.awt.TrayIcon;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ComponentEvent;
import java.awt.event.FocusEvent;
import java.awt.event.InputEvent;
import java.awt.event.InputMethodEvent;
import java.awt.event.InvocationEvent;
import java.awt.event.ItemEvent;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.awt.event.MouseWheelEvent;
import java.awt.event.WindowEvent;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.EventListener;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.Set;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.Consumer;
import javax.swing.CellRendererPane;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JTable;
import javax.swing.JTree;
import javax.swing.KeyStroke;
import javax.swing.MenuElement;
import javax.swing.MenuSelectionManager;
import javax.swing.SwingUtilities;
import javax.swing.plaf.basic.ComboPopup;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import sun.awt.AppContext;
import sun.awt.SunToolkit;

public class IdeEventQueue
extends EventQueue {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.ide.IdeEventQueue");
    private static final Logger TYPEAHEAD_LOG = Logger.getInstance((String)"#com.intellij.ide.IdeEventQueue.typeahead");
    private static final Logger FOCUS_AWARE_RUNNABLES_LOG = Logger.getInstance((String)"#com.intellij.ide.IdeEventQueue.runnables");
    private static final boolean JAVA11_ON_MAC = SystemInfo.isMac && SystemInfo.isJavaVersionAtLeast((int)11, (int)0, (int)0);
    private static TransactionGuardImpl ourTransactionGuard;
    private final Object myLock = new Object();
    private final List<Runnable> myIdleListeners = ContainerUtil.createLockFreeCopyOnWriteList();
    private final List<Runnable> myActivityListeners = ContainerUtil.createLockFreeCopyOnWriteList();
    private final Alarm myIdleRequestsAlarm = new Alarm();
    private final Map<Runnable, MyFireIdleRequest> myListener2Request = new HashMap<Runnable, MyFireIdleRequest>();
    private final IdeKeyEventDispatcher myKeyEventDispatcher = new IdeKeyEventDispatcher(this);
    private final IdeMouseEventDispatcher myMouseEventDispatcher = new IdeMouseEventDispatcher();
    private final IdePopupManager myPopupManager = new IdePopupManager();
    private final ToolkitBugsProcessor myToolkitBugsProcessor = new ToolkitBugsProcessor();
    private int myEventCount;
    final AtomicInteger myKeyboardEventsPosted = new AtomicInteger();
    final AtomicInteger myKeyboardEventsDispatched = new AtomicInteger();
    private boolean myIsInInputEvent;
    @NotNull
    private AWTEvent myCurrentEvent = new InvocationEvent((Object)this, EmptyRunnable.getInstance());
    private volatile long myLastActiveTime = System.nanoTime();
    private long myLastEventTime = System.currentTimeMillis();
    private WindowManagerEx myWindowManager;
    private final List<EventDispatcher> myDispatchers = ContainerUtil.createLockFreeCopyOnWriteList();
    private final List<EventDispatcher> myPostProcessors = ContainerUtil.createLockFreeCopyOnWriteList();
    private final Set<Runnable> myReady = ContainerUtil.newHashSet();
    private boolean myKeyboardBusy;
    private boolean myWinMetaPressed;
    private int myInputMethodLock;
    private final com.intellij.util.EventDispatcher<PostEventHook> myPostEventListeners = com.intellij.util.EventDispatcher.create(PostEventHook.class);
    private final Map<AWTEvent, List<Runnable>> myRunnablesWaitingFocusChange = new LinkedHashMap<AWTEvent, List<Runnable>>();
    private MyLastShortcut myLastShortcut;
    private static boolean ourAppIsLoaded;
    private boolean skipTypedEvents;
    private final FrequentEventDetector myFrequentEventDetector = new FrequentEventDetector(1009, 100);
    private final Queue<AWTEvent> focusEventsList = new ConcurrentLinkedQueue<AWTEvent>();
    private final AtomicLong ourLastTimePressed = new AtomicLong(0L);
    private SearchEverywhereTypeaheadState mySearchEverywhereTypeaheadState = SearchEverywhereTypeaheadState.DEACTIVATED;
    private final Set<Shortcut> shortcutsShowingPopups = new HashSet<Shortcut>();
    private final List<String> actionsShowingPopupsList = new ArrayList<String>();
    private long lastTypeaheadTimestamp = -1L;
    private final Queue<KeyEvent> myDelayedKeyEvents = new ConcurrentLinkedQueue<KeyEvent>();
    private final AtomicBoolean delayKeyEvents = new AtomicBoolean();
    private Boolean myTestMode;

    public void executeWhenAllFocusEventsLeftTheQueue(@NotNull Runnable runnable2) {
        this.ifFocusEventsInTheQueue(e -> {
            List<Runnable> runnables = this.myRunnablesWaitingFocusChange.get(e);
            if (runnables != null) {
                if (FOCUS_AWARE_RUNNABLES_LOG.isDebugEnabled()) {
                    FOCUS_AWARE_RUNNABLES_LOG.debug("We have already had a runnable for the event: " + e);
                }
                runnables.add(runnable2);
            } else {
                runnables = new ArrayList<Runnable>();
                runnables.add(runnable2);
                this.myRunnablesWaitingFocusChange.put((AWTEvent)e, runnables);
            }
        }, runnable2);
    }

    @NotNull
    public String runnablesWaitingForFocusChangeState() {
        return StringUtil.join(this.focusEventsList, event -> "[" + event.getID() + "; " + event.getSource().getClass().getName() + "]", (String)", ");
    }

    private void ifFocusEventsInTheQueue(@NotNull Consumer<? super AWTEvent> yes, @NotNull Runnable no) {
        if (!this.focusEventsList.isEmpty()) {
            AWTEvent first;
            if (FOCUS_AWARE_RUNNABLES_LOG.isDebugEnabled()) {
                FOCUS_AWARE_RUNNABLES_LOG.debug("Focus event list (trying to execute runnable): " + this.runnablesWaitingForFocusChangeState());
            }
            if ((first = (AWTEvent)ContainerUtil.find(this.focusEventsList, e -> e.getID() == 1004)) != null) {
                if (FOCUS_AWARE_RUNNABLES_LOG.isDebugEnabled()) {
                    FOCUS_AWARE_RUNNABLES_LOG.debug("    runnable saved for : [" + first.getID() + "; " + first.getSource() + "] -> " + no.getClass().getName());
                }
                yes.accept(first);
            } else {
                if (FOCUS_AWARE_RUNNABLES_LOG.isDebugEnabled()) {
                    FOCUS_AWARE_RUNNABLES_LOG.debug("    runnable is run on EDT if needed : " + no.getClass().getName());
                }
                UIUtil.invokeLaterIfNeeded((Runnable)no);
            }
        } else {
            if (FOCUS_AWARE_RUNNABLES_LOG.isDebugEnabled()) {
                FOCUS_AWARE_RUNNABLES_LOG.debug("Focus event list is empty: runnable is run right away : " + no.getClass().getName());
            }
            UIUtil.invokeLaterIfNeeded((Runnable)no);
        }
    }

    public static IdeEventQueue getInstance() {
        return IdeEventQueueHolder.INSTANCE;
    }

    private IdeEventQueue() {
        EventQueue systemEventQueue = Toolkit.getDefaultToolkit().getSystemEventQueue();
        assert (!(systemEventQueue instanceof IdeEventQueue)) : systemEventQueue;
        systemEventQueue.push(this);
        IdeKeyboardFocusManager keyboardFocusManager = IdeKeyboardFocusManager.replaceDefault();
        keyboardFocusManager.addPropertyChangeListener("permanentFocusOwner", e -> {
            Application application = ApplicationManager.getApplication();
            if (application == null) {
                return;
            }
            application.assertIsDispatchThread();
        });
        this.addDispatcher(new WindowsAltSuppressor(), null);
        if (Registry.is((String)"keymap.windows.up.to.maximize.dialogs") && SystemInfo.isWin7OrNewer) {
            this.addDispatcher(new WindowsUpMaximizer(), null);
        }
        this.addDispatcher(new EditingCanceller(), null);
        this.abracadabraDaberBoreh();
        IdeKeyEventDispatcher.addDumbModeWarningListener(() -> this.flushDelayedKeyEvents());
        if (Registry.is((String)"skip.move.resize.events")) {
            this.myPostEventListeners.addListener(IdeEventQueue::skipMoveResizeEvents);
        }
    }

    private static boolean skipMoveResizeEvents(AWTEvent event) {
        switch (event.getID()) {
            case 100: 
            case 101: 
            case 1401: 
            case 1402: {
                Object source = event.getSource();
                if (!(source instanceof Component) || null == UIUtil.getParentOfType(CellRendererPane.class, (Component)((Component)source))) break;
                return true;
            }
        }
        return false;
    }

    private void abracadabraDaberBoreh() {
        try {
            Class<?> aClass = Class.forName("sun.awt.PostEventQueue");
            Constructor<?> constructor = aClass.getDeclaredConstructor(EventQueue.class);
            constructor.setAccessible(true);
            Object postEventQueue = constructor.newInstance(this);
            AppContext.getAppContext().put("PostEventQueue", postEventQueue);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public void setWindowManager(@NotNull WindowManagerEx windowManager) {
        this.myWindowManager = windowManager;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addIdleListener(@NotNull Runnable runnable2, int timeoutMillis) {
        if (timeoutMillis <= 0 || TimeUnit.MILLISECONDS.toHours(timeoutMillis) >= 24L) {
            throw new IllegalArgumentException("This timeout value is unsupported: " + timeoutMillis);
        }
        Object object = this.myLock;
        synchronized (object) {
            this.myIdleListeners.add(runnable2);
            MyFireIdleRequest request = new MyFireIdleRequest(runnable2, timeoutMillis);
            this.myListener2Request.put(runnable2, request);
            UIUtil.invokeLaterIfNeeded(() -> this.myIdleRequestsAlarm.addRequest((Runnable)request, timeoutMillis));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeIdleListener(@NotNull Runnable runnable2) {
        Object object = this.myLock;
        synchronized (object) {
            MyFireIdleRequest request;
            boolean wasRemoved = this.myIdleListeners.remove(runnable2);
            if (!wasRemoved) {
                LOG.error("unknown runnable: " + runnable2);
            }
            LOG.assertTrue((request = this.myListener2Request.remove(runnable2)) != null);
            this.myIdleRequestsAlarm.cancelRequest((Runnable)request);
        }
    }

    public void addActivityListener(@NotNull Runnable runnable2, @NotNull Disposable parentDisposable) {
        ContainerUtil.add((Object)runnable2, this.myActivityListeners, (Disposable)parentDisposable);
    }

    public void addDispatcher(@NotNull EventDispatcher dispatcher, Disposable parent) {
        IdeEventQueue._addProcessor(dispatcher, parent, this.myDispatchers);
    }

    public void removeDispatcher(@NotNull EventDispatcher dispatcher) {
        this.myDispatchers.remove(dispatcher);
    }

    public boolean containsDispatcher(@NotNull EventDispatcher dispatcher) {
        return this.myDispatchers.contains(dispatcher);
    }

    public void addPostprocessor(@NotNull EventDispatcher dispatcher, @Nullable Disposable parent) {
        IdeEventQueue._addProcessor(dispatcher, parent, this.myPostProcessors);
    }

    public void removePostprocessor(@NotNull EventDispatcher dispatcher) {
        this.myPostProcessors.remove(dispatcher);
    }

    private static void _addProcessor(@NotNull EventDispatcher dispatcher, Disposable parent, @NotNull Collection<? super EventDispatcher> set2) {
        set2.add(dispatcher);
        if (parent != null) {
            Disposer.register((Disposable)parent, () -> set2.remove(dispatcher));
        }
    }

    public int getEventCount() {
        return this.myEventCount;
    }

    public void setEventCount(int evCount) {
        this.myEventCount = evCount;
    }

    @NotNull
    public AWTEvent getTrueCurrentEvent() {
        return this.myCurrentEvent;
    }

    private static boolean appIsLoaded() {
        if (ourAppIsLoaded) {
            return true;
        }
        boolean loaded = IdeaApplication.isLoaded();
        if (loaded) {
            ourAppIsLoaded = true;
        }
        return loaded;
    }

    public static void applicationClose() {
        ourAppIsLoaded = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void dispatchEvent(@NotNull AWTEvent e) {
        if (Registry.is((String)"skip.typed.event") && this.skipTypedKeyEventsIfFocusReturnsToOwner(e)) {
            return;
        }
        if (IdeEventQueue.isMetaKeyPressedOnLinux(e)) {
            return;
        }
        if (this.isSpecialSymbolMatchingShortcut(e)) {
            return;
        }
        if (e.getSource() instanceof TrayIcon) {
            return;
        }
        this.checkForTimeJump();
        if (!IdeEventQueue.appIsLoaded()) {
            try {
                super.dispatchEvent(e);
            }
            catch (Throwable t) {
                this.processException(t);
            }
            return;
        }
        e = IdeEventQueue.mapEvent(e);
        AWTEvent metaEvent = this.mapMetaState(e);
        if (Registry.is((String)"keymap.windows.as.meta") && metaEvent != null) {
            e = metaEvent;
        }
        if (JAVA11_ON_MAC && e instanceof InputEvent) {
            if (e instanceof KeyEvent && ((KeyEvent)e).getKeyCode() == 65406) {
                ((KeyEvent)e).setKeyCode(18);
            }
            IdeKeyEventDispatcher.removeAltGraph((InputEvent)e);
        }
        boolean wasInputEvent = this.myIsInInputEvent;
        this.myIsInInputEvent = IdeEventQueue.isInputEvent(e);
        AWTEvent oldEvent = this.myCurrentEvent;
        this.myCurrentEvent = e;
        HeavyProcessLatch.INSTANCE.prioritizeUiActivity();
        try (AccessToken ignored = IdeEventQueue.startActivity(e);){
            this._dispatchEvent(e);
        }
        catch (Throwable t) {
            try {
                this.processException(t);
            }
            catch (Throwable throwable) {
                throw throwable;
            }
            finally {
                HeavyProcessLatch.INSTANCE.stopThreadPrioritizing();
                this.myIsInInputEvent = wasInputEvent;
                this.myCurrentEvent = oldEvent;
                for (EventDispatcher each : this.myPostProcessors) {
                    each.dispatch(e);
                }
                if (e instanceof KeyEvent) {
                    this.maybeReady();
                }
            }
        }
        HeavyProcessLatch.INSTANCE.stopThreadPrioritizing();
        this.myIsInInputEvent = wasInputEvent;
        this.myCurrentEvent = oldEvent;
        for (EventDispatcher each : this.myPostProcessors) {
            each.dispatch(e);
        }
        if (e instanceof KeyEvent) {
            this.maybeReady();
        }
        if (IdeEventQueue.isFocusEvent(e)) {
            TouchBarsManager.onFocusEvent(e);
            if (FOCUS_AWARE_RUNNABLES_LOG.isDebugEnabled()) {
                FOCUS_AWARE_RUNNABLES_LOG.debug("Focus event list (execute on focus event): " + this.runnablesWaitingForFocusChangeState());
            }
            ArrayList<AWTEvent> events = new ArrayList<AWTEvent>();
            while (!this.focusEventsList.isEmpty()) {
                AWTEvent f = this.focusEventsList.poll();
                events.add(f);
                if (!f.equals(e)) continue;
                break;
            }
            events.stream().map(entry -> this.myRunnablesWaitingFocusChange.remove(entry)).filter(lor -> lor != null).flatMap(listOfRunnables -> listOfRunnables.stream()).filter(r -> r != null).filter(r -> !(r instanceof ExpirableRunnable) || !((ExpirableRunnable)r).isExpired()).forEach(runnable2 -> {
                try {
                    runnable2.run();
                }
                catch (Exception ex) {
                    LOG.error((Throwable)ex);
                }
            });
        }
    }

    private boolean isSpecialSymbolMatchingShortcut(AWTEvent e) {
        MyLastShortcut shortcut = this.myLastShortcut;
        if (shortcut != null && e instanceof KeyEvent && e.getID() == 400) {
            KeyEvent symbol = (KeyEvent)e;
            long time = symbol.getWhen() - shortcut.when;
            return time < 17L && shortcut.keyChar == symbol.getKeyChar();
        }
        return false;
    }

    public void onActionInvoked(@NotNull KeyEvent e) {
        this.myLastShortcut = new MyLastShortcut(e.getWhen(), e.getKeyChar());
    }

    private static boolean isMetaKeyPressedOnLinux(@NotNull AWTEvent e) {
        if (!Registry.is((String)"keymap.skip.meta.press.on.linux")) {
            return false;
        }
        boolean metaIsPressed = e instanceof InputEvent && (((InputEvent)e).getModifiersEx() & 0x100) != 0;
        boolean typedKeyEvent = e.getID() == 400;
        return SystemInfo.isLinux && typedKeyEvent && metaIsPressed;
    }

    private boolean skipTypedKeyEventsIfFocusReturnsToOwner(@NotNull AWTEvent e) {
        WindowEvent wfe;
        if (e.getID() == 208 && (wfe = (WindowEvent)e).getWindow().getParent() != null && wfe.getWindow().getParent() == wfe.getOppositeWindow()) {
            this.skipTypedEvents = true;
        }
        if (this.skipTypedEvents && e instanceof KeyEvent) {
            if (e.getID() == 400) {
                ((KeyEvent)e).consume();
                return true;
            }
            this.skipTypedEvents = false;
        }
        return false;
    }

    private void checkForTimeJump() {
        long now = System.currentTimeMillis();
        if (this.myLastEventTime > now + 1000L) {
            LOG.warn("System clock's jumped back by ~" + (this.myLastEventTime - now) / 1000L + " sec");
        }
        this.myLastEventTime = now;
    }

    private static boolean isInputEvent(@NotNull AWTEvent e) {
        return e instanceof InputEvent || e instanceof InputMethodEvent || e instanceof WindowEvent || e instanceof ActionEvent;
    }

    @Override
    @NotNull
    public AWTEvent getNextEvent() throws InterruptedException {
        AWTEvent event = super.getNextEvent();
        if (IdeEventQueue.isKeyboardEvent(event) && this.myKeyboardEventsDispatched.incrementAndGet() > this.myKeyboardEventsPosted.get()) {
            throw new RuntimeException(event + "; posted: " + this.myKeyboardEventsPosted + "; dispatched: " + this.myKeyboardEventsDispatched);
        }
        return event;
    }

    @Nullable
    static AccessToken startActivity(@NotNull AWTEvent e) {
        if (ourTransactionGuard == null && IdeEventQueue.appIsLoaded() && ApplicationManager.getApplication() != null && !ApplicationManager.getApplication().isDisposed()) {
            ourTransactionGuard = (TransactionGuardImpl)TransactionGuard.getInstance();
        }
        return ourTransactionGuard == null ? null : ourTransactionGuard.startActivity(IdeEventQueue.isInputEvent(e) || e instanceof ItemEvent || e instanceof FocusEvent);
    }

    private void processException(@NotNull Throwable t) {
        if (!this.myToolkitBugsProcessor.process(t)) {
            PluginManager.processException(t);
        }
    }

    @NotNull
    private static AWTEvent mapEvent(@NotNull AWTEvent e) {
        if (SystemInfo.isXWindow && e instanceof MouseEvent && ((MouseEvent)e).getButton() > 3) {
            MouseEvent src = (MouseEvent)e;
            e = src.getButton() < 6 ? new MouseWheelEvent(src.getComponent(), 507, src.getWhen(), src.getModifiers() | 0x40, src.getX(), src.getY(), 0, false, 0, src.getClickCount(), src.getButton() == 4 ? -1 : 1) : new MouseEvent(src.getComponent(), src.getID(), src.getWhen(), src.getModifiers() | 1 << 8 + src.getButton(), src.getX(), src.getY(), 1, src.isPopupTrigger(), src.getButton() - 2);
        }
        return e;
    }

    @Nullable
    private AWTEvent mapMetaState(@NotNull AWTEvent e) {
        if (this.myWinMetaPressed) {
            Application app = ApplicationManager.getApplication();
            boolean weAreNotActive = app == null || !app.isActive();
            if (weAreNotActive |= e instanceof FocusEvent && ((FocusEvent)e).getOppositeComponent() == null) {
                this.myWinMetaPressed = false;
                return null;
            }
        }
        if (e instanceof KeyEvent) {
            KeyEvent ke = (KeyEvent)e;
            if (ke.getKeyCode() == 524) {
                if (ke.getID() == 401) {
                    this.myWinMetaPressed = true;
                }
                if (ke.getID() == 402) {
                    this.myWinMetaPressed = false;
                }
                return null;
            }
            if (this.myWinMetaPressed) {
                return new KeyEvent(ke.getComponent(), ke.getID(), ke.getWhen(), ke.getModifiers() | ke.getModifiersEx() | 4, ke.getKeyCode(), ke.getKeyChar(), ke.getKeyLocation());
            }
        }
        if (this.myWinMetaPressed && e instanceof MouseEvent && ((MouseEvent)e).getButton() != 0) {
            MouseEvent me = (MouseEvent)e;
            return new MouseEvent(me.getComponent(), me.getID(), me.getWhen(), me.getModifiers() | me.getModifiersEx() | 4, me.getX(), me.getY(), me.getClickCount(), me.isPopupTrigger(), me.getButton());
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void _dispatchEvent(@NotNull AWTEvent e) {
        Object selectedPath;
        DnDManagerImpl dndManager;
        if (e.getID() == 506 && (dndManager = (DnDManagerImpl)DnDManager.getInstance()) != null) {
            dndManager.setLastDropHandler(null);
        }
        ++this.myEventCount;
        if (IdeEventQueue.processAppActivationEvents(e)) {
            return;
        }
        boolean bl = this.myKeyboardBusy = e instanceof KeyEvent || this.myKeyboardEventsPosted.get() > this.myKeyboardEventsDispatched.get();
        if (e instanceof KeyEvent && e.getID() == 402 && ((KeyEvent)e).getKeyCode() == 16) {
            this.myMouseEventDispatcher.resetHorScrollingTracker();
        }
        if (e instanceof WindowEvent || e instanceof FocusEvent) {
            ActivityTracker.getInstance().inc();
        }
        if (e instanceof MouseWheelEvent && ((MenuElement[])(selectedPath = MenuSelectionManager.defaultManager().getSelectedPath())).length > 0 && !(selectedPath[0] instanceof ComboPopup)) {
            ((MouseWheelEvent)e).consume();
            Component component = selectedPath[0].getComponent();
            if (component instanceof JBPopupMenu) {
                ((JBPopupMenu)component).processMouseWheelEvent((MouseWheelEvent)e);
            }
            return;
        }
        if (e instanceof KeyEvent || e instanceof MouseEvent) {
            ActivityTracker.getInstance().inc();
            selectedPath = this.myLock;
            synchronized (selectedPath) {
                this.myIdleRequestsAlarm.cancelAllRequests();
                for (Runnable idleListener2 : this.myIdleListeners) {
                    MyFireIdleRequest request = this.myListener2Request.get(idleListener2);
                    if (request == null) {
                        LOG.error("There is no request for " + idleListener2);
                        continue;
                    }
                    this.myIdleRequestsAlarm.addRequest((Runnable)request, request.getTimeout(), ModalityState.NON_MODAL);
                }
                if (401 == e.getID() || 400 == e.getID() || 501 == e.getID() || 502 == e.getID() || 500 == e.getID()) {
                    this.myLastActiveTime = System.nanoTime();
                    for (Runnable activityListener : this.myActivityListeners) {
                        activityListener.run();
                    }
                }
            }
        }
        if (e.getID() == 400 && this.myKeyEventDispatcher.isPressedWasProcessed()) {
            ((KeyEvent)e).consume();
        }
        if (this.myPopupManager.isPopupActive() && this.myPopupManager.dispatch(e)) {
            if (this.myKeyEventDispatcher.isWaitingForSecondKeyStroke()) {
                this.myKeyEventDispatcher.setState(KeyState.STATE_INIT);
            }
            return;
        }
        if (e instanceof InputEvent) {
            TouchBarsManager.onInputEvent((InputEvent)e);
        }
        if (this.dispatchByCustomDispatchers(e)) {
            return;
        }
        if (e instanceof InputMethodEvent && SystemInfo.isMac && this.myKeyEventDispatcher.isWaitingForSecondKeyStroke()) {
            return;
        }
        if (e instanceof ComponentEvent && this.myWindowManager != null) {
            this.myWindowManager.dispatchComponentEvent((ComponentEvent)e);
        }
        if (e instanceof KeyEvent) {
            if (this.myKeyEventDispatcher.dispatchKeyEvent((KeyEvent)e)) {
                ((KeyEvent)e).consume();
            }
            this.defaultDispatchEvent(e);
        } else if (e instanceof MouseEvent) {
            MouseEvent me = (MouseEvent)e;
            if (me.getID() == 501 && me.getModifiers() > 0 && me.getModifiersEx() == 0) {
                super.dispatchEvent(new MouseEvent(me.getComponent(), 503, me.getWhen(), 0, me.getX(), me.getY(), 0, false, 0));
            }
            if (IdeMouseEventDispatcher.patchClickCount(me) && me.getID() == 500) {
                MouseEvent toDispatch = new MouseEvent(me.getComponent(), me.getID(), System.currentTimeMillis(), me.getModifiers(), me.getX(), me.getY(), 1, me.isPopupTrigger(), me.getButton());
                SwingUtilities.invokeLater(() -> this.dispatchEvent(toDispatch));
            }
            if (!this.myMouseEventDispatcher.dispatchMouseEvent(me)) {
                this.defaultDispatchEvent(e);
            }
        } else {
            this.defaultDispatchEvent(e);
        }
    }

    private boolean dispatchByCustomDispatchers(@NotNull AWTEvent e) {
        for (EventDispatcher eachDispatcher : this.myDispatchers) {
            if (!eachDispatcher.dispatch(e)) continue;
            return true;
        }
        return false;
    }

    private static boolean processAppActivationEvents(@NotNull AWTEvent e) {
        if (e instanceof WindowEvent) {
            WindowEvent we = (WindowEvent)e;
            ApplicationActivationStateManager.updateState(we);
            IdeEventQueue.storeLastFocusedComponent(we);
        }
        return false;
    }

    private static void storeLastFocusedComponent(@NotNull WindowEvent we) {
        Window eventWindow = we.getWindow();
        if (we.getID() == 206 || we.getID() == 208) {
            Component frame = UIUtil.findUltimateParent((Component)eventWindow);
            Component focusOwnerInDeactivatedWindow = eventWindow.getMostRecentFocusOwner();
            IdeFrame[] allProjectFrames = WindowManager.getInstance().getAllProjectFrames();
            if (focusOwnerInDeactivatedWindow != null) {
                for (IdeFrame ideFrame : allProjectFrames) {
                    IdeFocusManager focusManager;
                    JFrame aFrame = WindowManager.getInstance().getFrame(ideFrame.getProject());
                    if (!aFrame.equals(frame) || !((focusManager = IdeFocusManager.getGlobalInstance()) instanceof FocusManagerImpl)) continue;
                    ((FocusManagerImpl)focusManager).setLastFocusedAtDeactivation(ideFrame, focusOwnerInDeactivatedWindow);
                }
            }
        }
    }

    private void defaultDispatchEvent(@NotNull AWTEvent e) {
        try {
            this.maybeReady();
            IdeEventQueue.fixStickyAlt(e);
            super.dispatchEvent(e);
        }
        catch (Throwable t) {
            this.processException(t);
        }
    }

    private static void fixStickyAlt(@NotNull AWTEvent e) {
        if (!Registry.is((String)"actionSystem.win.suppressAlt.new") && SystemInfo.isWinXpOrNewer && !SystemInfo.isWinVistaOrNewer && e instanceof KeyEvent && ((KeyEvent)e).getKeyCode() == 18) {
            ((KeyEvent)e).consume();
        }
    }

    public void flushQueue() {
        AWTEvent event;
        while ((event = this.peekEvent()) != null) {
            try {
                AWTEvent event1 = this.getNextEvent();
                this.dispatchEvent(event1);
                continue;
            }
            catch (Exception e) {
                LOG.error((Throwable)e);
                continue;
            }
            break;
        }
        return;
    }

    public void pumpEventsForHierarchy(@NotNull Component modalComponent, @NotNull Condition<? super AWTEvent> exitCondition) {
        AWTEvent event;
        if (LOG.isDebugEnabled()) {
            LOG.debug("pumpEventsForHierarchy(" + modalComponent + ", " + exitCondition + ")");
        }
        do {
            try {
                Object s;
                event = this.getNextEvent();
                boolean eventOk = true;
                if (event instanceof InputEvent && (s = event.getSource()) instanceof Component) {
                    Component c;
                    Window modalWindow = SwingUtilities.windowForComponent(modalComponent);
                    for (c = (Component)s; c != null && c != modalWindow; c = c.getParent()) {
                    }
                    if (c == null) {
                        eventOk = false;
                        if (LOG.isDebugEnabled()) {
                            LOG.debug("pumpEventsForHierarchy.consumed: " + event);
                        }
                        ((InputEvent)event).consume();
                    }
                }
                if (!eventOk) continue;
                this.dispatchEvent(event);
            }
            catch (Throwable e) {
                LOG.error(e);
                event = null;
            }
        } while (!exitCondition.value((Object)event));
        if (LOG.isDebugEnabled()) {
            LOG.debug("pumpEventsForHierarchy.exit(" + modalComponent + ", " + exitCondition + ")");
        }
    }

    public long getIdleTime() {
        return TimeUnit.NANOSECONDS.toMillis(System.nanoTime() - this.myLastActiveTime);
    }

    @NotNull
    public IdePopupManager getPopupManager() {
        return this.myPopupManager;
    }

    @NotNull
    public IdeKeyEventDispatcher getKeyEventDispatcher() {
        return this.myKeyEventDispatcher;
    }

    public void blockNextEvents(@NotNull MouseEvent e) {
        this.blockNextEvents(e, BlockMode.COMPLETE);
    }

    public void blockNextEvents(@NotNull MouseEvent e, @NotNull BlockMode blockMode) {
        this.myMouseEventDispatcher.blockNextEvents(e, blockMode);
    }

    private boolean isReady() {
        return !this.myKeyboardBusy && this.myKeyEventDispatcher.isReady();
    }

    public void maybeReady() {
        if (this.myReady.isEmpty() || !this.isReady()) {
            return;
        }
        Runnable[] ready = this.myReady.toArray(new Runnable[0]);
        this.myReady.clear();
        for (Runnable each : ready) {
            each.run();
        }
    }

    public void doWhenReady(@NotNull Runnable runnable2) {
        if (EventQueue.isDispatchThread()) {
            this.myReady.add(runnable2);
            this.maybeReady();
        } else {
            SwingUtilities.invokeLater(() -> {
                this.myReady.add(runnable2);
                this.maybeReady();
            });
        }
    }

    public boolean isPopupActive() {
        return this.myPopupManager.isPopupActive();
    }

    public boolean isInputMethodEnabled() {
        return !SystemInfo.isMac || this.myInputMethodLock == 0;
    }

    public void disableInputMethods(@NotNull Disposable parentDisposable) {
        ++this.myInputMethodLock;
        Disposer.register((Disposable)parentDisposable, () -> --this.myInputMethodLock);
    }

    @Override
    public void postEvent(@NotNull AWTEvent event) {
        this.doPostEvent(event);
    }

    private static boolean doesFocusGoIntoPopup(@NotNull AWTEvent e) {
        AWTEvent unwrappedEvent = IdeEventQueue.unwrapWindowEvent(e);
        if (TYPEAHEAD_LOG.isDebugEnabled() && (e instanceof WindowEvent || e.getClass().getName().contains("SequencedEvent"))) {
            TYPEAHEAD_LOG.debug("Window event: " + e.paramString());
        }
        return IdeEventQueue.doesFocusGoIntoPopupFromWindowEvent(unwrappedEvent);
    }

    @NotNull
    private static AWTEvent unwrapWindowEvent(@NotNull AWTEvent e) {
        AWTEvent unwrappedEvent = e;
        if (e.getClass() == SequencedEventNestedFieldHolder.SEQUENCED_EVENT_CLASS) {
            try {
                unwrappedEvent = (AWTEvent)SequencedEventNestedFieldHolder.NESTED_FIELD.get(e);
            }
            catch (IllegalAccessException illegalAccessException) {
                TYPEAHEAD_LOG.error((Throwable)illegalAccessException);
            }
        }
        TYPEAHEAD_LOG.assertTrue(unwrappedEvent != null);
        return unwrappedEvent;
    }

    private boolean isTypeaheadTimeoutExceeded() {
        if (!this.delayKeyEvents.get()) {
            return false;
        }
        long currentTypeaheadDelay = System.currentTimeMillis() - this.lastTypeaheadTimestamp;
        if ((double)currentTypeaheadDelay > Registry.get((String)"action.aware.typeaheadTimout").asDouble()) {
            super.postEvent(new InvocationEvent((Object)this, () -> TYPEAHEAD_LOG.error((Throwable)new RuntimeException("Typeahead timeout is exceeded: " + currentTypeaheadDelay))));
            return true;
        }
        return false;
    }

    private static boolean doesFocusGoIntoPopupFromWindowEvent(@NotNull AWTEvent e) {
        if ((e.getID() == 207 || SystemInfo.isLinux && e.getID() == 200) && UIUtil.isTypeAheadAware((Window)((WindowEvent)e).getWindow())) {
            TYPEAHEAD_LOG.debug("Focus goes into TypeAhead aware window");
            return true;
        }
        return false;
    }

    private static boolean isFocusEvent(@NotNull AWTEvent e) {
        return e.getID() == 1004 || e.getID() == 1005 || e.getID() == 205 || e.getID() == 206 || e.getID() == 208 || e.getID() == 207;
    }

    boolean doPostEvent(@NotNull AWTEvent event) {
        long timeDelta;
        for (PostEventHook listener2 : this.myPostEventListeners.getListeners()) {
            if (!listener2.consumePostedEvent(event)) continue;
            return false;
        }
        String message = this.myFrequentEventDetector.getMessageOnEvent((Object)event);
        if (message != null) {
            AppExecutorUtil.getAppExecutorService().execute(() -> this.myFrequentEventDetector.logMessage(message));
        }
        boolean typeAheadEnabled = Registry.is((String)"action.aware.typeAhead");
        if (IdeEventQueue.isKeyboardEvent(event)) {
            this.myKeyboardEventsPosted.incrementAndGet();
            if (typeAheadEnabled && this.delayKeyEvents.get()) {
                this.myDelayedKeyEvents.offer((KeyEvent)event);
                if (TYPEAHEAD_LOG.isDebugEnabled()) {
                    TYPEAHEAD_LOG.debug("Waiting for typeahead : " + event);
                }
                return true;
            }
        }
        if (IdeEventQueue.isFocusEvent(event)) {
            this.focusEventsList.add(event);
        }
        boolean typeAheadSearchEverywhereEnabled = Registry.is((String)"action.aware.typeAhead.searchEverywhere");
        if (typeAheadEnabled) {
            KeyEvent keyEvent;
            if (event.getID() == 401) {
                keyEvent = (KeyEvent)event;
                KeyStroke keyStrokeToFind = KeyStroke.getKeyStroke(keyEvent.getKeyCode(), keyEvent.getModifiers());
                boolean thisShortcutMayShowPopup = ContainerUtil.exists(this.getShortcutsShowingPopups(), s -> s instanceof KeyboardShortcut && ((KeyboardShortcut)s).getSecondKeyStroke() == null && ((KeyboardShortcut)s).getFirstKeyStroke().equals(keyStrokeToFind));
                if (thisShortcutMayShowPopup && KeyboardFocusManager.getCurrentKeyboardFocusManager().getFocusedWindow() instanceof IdeFrame) {
                    if (TYPEAHEAD_LOG.isDebugEnabled()) {
                        TYPEAHEAD_LOG.debug("Delay following events; Focused window is " + KeyboardFocusManager.getCurrentKeyboardFocusManager().getFocusedWindow().getClass().getName());
                    }
                    this.delayKeyEvents.set(true);
                    this.lastTypeaheadTimestamp = System.currentTimeMillis();
                }
            } else if (event.getID() == 402 && typeAheadSearchEverywhereEnabled && KeyboardFocusManager.getCurrentKeyboardFocusManager().getFocusedWindow() instanceof IdeFrame && (keyEvent = (KeyEvent)event).getKeyCode() == 16) {
                switch (this.mySearchEverywhereTypeaheadState) {
                    case DEACTIVATED: {
                        this.mySearchEverywhereTypeaheadState = SearchEverywhereTypeaheadState.TRIGGERED;
                        this.ourLastTimePressed.set(keyEvent.getWhen());
                        break;
                    }
                    case TRIGGERED: {
                        long timeDelta2 = keyEvent.getWhen() - this.ourLastTimePressed.get();
                        if (timeDelta2 >= 100L && timeDelta2 <= 500L) {
                            this.delayKeyEvents.set(true);
                            this.lastTypeaheadTimestamp = System.currentTimeMillis();
                            this.mySearchEverywhereTypeaheadState = SearchEverywhereTypeaheadState.DETECTED;
                            break;
                        }
                        this.mySearchEverywhereTypeaheadState = SearchEverywhereTypeaheadState.DEACTIVATED;
                        this.flushDelayedKeyEvents();
                        break;
                    }
                }
            }
            if (this.isTypeaheadTimeoutExceeded()) {
                TYPEAHEAD_LOG.debug("Clear delayed events because of IdeFrame deactivation");
                this.delayKeyEvents.set(false);
                this.flushDelayedKeyEvents();
                this.lastTypeaheadTimestamp = 0L;
                if (typeAheadSearchEverywhereEnabled) {
                    this.mySearchEverywhereTypeaheadState = SearchEverywhereTypeaheadState.DEACTIVATED;
                }
            }
        }
        super.postEvent(event);
        if (typeAheadSearchEverywhereEnabled && event instanceof KeyEvent && (this.mySearchEverywhereTypeaheadState == SearchEverywhereTypeaheadState.TRIGGERED || this.mySearchEverywhereTypeaheadState == SearchEverywhereTypeaheadState.DETECTED) && ((timeDelta = ((KeyEvent)event).getWhen() - this.ourLastTimePressed.get()) < 100L || timeDelta > 500L)) {
            this.mySearchEverywhereTypeaheadState = SearchEverywhereTypeaheadState.DEACTIVATED;
            this.flushDelayedKeyEvents();
        }
        if (typeAheadEnabled && IdeEventQueue.doesFocusGoIntoPopup(event)) {
            this.delayKeyEvents.set(false);
            this.postDelayedKeyEvents();
            if (typeAheadSearchEverywhereEnabled) {
                this.mySearchEverywhereTypeaheadState = SearchEverywhereTypeaheadState.DEACTIVATED;
            }
        }
        return true;
    }

    private int numberOfDelayedKeyEvents() {
        return this.myDelayedKeyEvents.size();
    }

    private void postDelayedKeyEvents() {
        KeyEvent event;
        if (TYPEAHEAD_LOG.isDebugEnabled()) {
            TYPEAHEAD_LOG.debug("Stop delaying events. Events to post: " + this.numberOfDelayedKeyEvents());
        }
        while ((event = this.myDelayedKeyEvents.poll()) != null) {
            if (TYPEAHEAD_LOG.isDebugEnabled()) {
                TYPEAHEAD_LOG.debug("Posted after delay: " + event.paramString());
            }
            super.postEvent(event);
        }
        if (TYPEAHEAD_LOG.isDebugEnabled()) {
            TYPEAHEAD_LOG.debug("Events after posting: " + this.numberOfDelayedKeyEvents());
        }
    }

    public void flushDelayedKeyEvents() {
        if (this.delayKeyEvents.compareAndSet(true, false)) {
            this.postDelayedKeyEvents();
        }
    }

    @NotNull
    private Set<Shortcut> getShortcutsShowingPopups() {
        KeymapManager keymapManager2 = KeymapManager.getInstance();
        if (this.shortcutsShowingPopups.isEmpty() && keymapManager2 != null && keymapManager2.getActiveKeymap() != null) {
            String actionsAwareTypeaheadActionsList = Registry.get((String)"action.aware.typeahead.actions.list").asString();
            this.actionsShowingPopupsList.addAll(StringUtil.split((String)actionsAwareTypeaheadActionsList, (String)","));
            this.actionsShowingPopupsList.forEach(actionId -> {
                List<Shortcut> shortcuts = Arrays.asList(keymapManager2.getActiveKeymap().getShortcuts(actionId));
                if (TYPEAHEAD_LOG.isDebugEnabled()) {
                    shortcuts.forEach(s -> TYPEAHEAD_LOG.debug("Typeahead for " + actionId + " : Shortcuts: " + s));
                }
                this.shortcutsShowingPopups.addAll(shortcuts);
            });
        }
        return this.shortcutsShowingPopups;
    }

    private static boolean isKeyboardEvent(@NotNull AWTEvent event) {
        return event instanceof KeyEvent;
    }

    @Override
    public AWTEvent peekEvent() {
        AWTEvent event = super.peekEvent();
        if (event != null) {
            return event;
        }
        if (this.isTestMode() && LaterInvocator.ensureFlushRequested()) {
            return super.peekEvent();
        }
        return null;
    }

    private boolean isTestMode() {
        Boolean testMode = this.myTestMode;
        if (testMode != null) {
            return testMode;
        }
        Application application = ApplicationManager.getApplication();
        if (application == null) {
            return false;
        }
        this.myTestMode = testMode = Boolean.valueOf(application.isUnitTestMode());
        return testMode;
    }

    public void addPostEventListener(@NotNull PostEventHook listener2, @NotNull Disposable parentDisposable) {
        this.myPostEventListeners.addListener((EventListener)listener2, parentDisposable);
    }

    public static void unsafeNonblockingExecute(@NotNull Runnable r) {
        assert (EventQueue.isDispatchThread());
        if (Holder.unsafeNonBlockingExecuteRef != null) {
            try {
                Holder.unsafeNonBlockingExecuteRef.invoke((Object)Toolkit.getDefaultToolkit(), r);
                return;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        r.run();
    }

    private class MyLastShortcut {
        public final long when;
        public final char keyChar;

        private MyLastShortcut(long when, char keyChar) {
            this.when = when;
            this.keyChar = keyChar;
        }
    }

    private static class Holder {
        private static final Method unsafeNonBlockingExecuteRef = ReflectionUtil.getDeclaredMethod(SunToolkit.class, (String)"unsafeNonblockingExecute", (Class[])new Class[]{Runnable.class});

        private Holder() {
        }
    }

    @FunctionalInterface
    public static interface PostEventHook
    extends EventListener {
        public boolean consumePostedEvent(@NotNull AWTEvent var1);
    }

    public static enum BlockMode {
        COMPLETE,
        ACTIONS;

    }

    private static enum SearchEverywhereTypeaheadState {
        DEACTIVATED,
        TRIGGERED,
        DETECTED;

    }

    private static class SequencedEventNestedFieldHolder {
        private static final Field NESTED_FIELD;
        private static final Class<?> SEQUENCED_EVENT_CLASS;

        private SequencedEventNestedFieldHolder() {
        }

        static {
            try {
                SEQUENCED_EVENT_CLASS = Class.forName("java.awt.SequencedEvent");
                NESTED_FIELD = ReflectionUtil.getDeclaredField(SEQUENCED_EVENT_CLASS, (String)"nested");
                if (NESTED_FIELD == null) {
                    throw new RuntimeException();
                }
            }
            catch (ClassNotFoundException e) {
                throw new RuntimeException(e);
            }
        }
    }

    private static class EditingCanceller
    implements EventDispatcher {
        private EditingCanceller() {
        }

        @Override
        public boolean dispatch(@NotNull AWTEvent e) {
            if (e instanceof KeyEvent && e.getID() == 401 && ((KeyEvent)e).getKeyCode() == 27 && !IdeEventQueue.getInstance().getPopupManager().isPopupActive()) {
                Component owner = UIUtil.findParentByCondition((Component)KeyboardFocusManager.getCurrentKeyboardFocusManager().getFocusOwner(), component -> component instanceof JTable || component instanceof JTree);
                if (owner instanceof JTable && ((JTable)owner).isEditing()) {
                    ((JTable)owner).editingCanceled(null);
                    return true;
                }
                if (owner instanceof JTree && ((JTree)owner).isEditing()) {
                    ((JTree)owner).cancelEditing();
                    return true;
                }
            }
            return false;
        }
    }

    private class WindowsUpMaximizer
    implements EventDispatcher {
        private WindowsUpMaximizer() {
        }

        @Override
        public boolean dispatch(@NotNull AWTEvent e) {
            Window parent;
            if (IdeEventQueue.this.myWinMetaPressed && e instanceof KeyEvent && e.getID() == 402 && (((KeyEvent)e).getKeyCode() == 38 || ((KeyEvent)e).getKeyCode() == 40) && (parent = UIUtil.getWindow((Component)((KeyEvent)e).getComponent())) instanceof JDialog) {
                JDialog dialog2 = (JDialog)parent;
                SwingUtilities.invokeLater(() -> {
                    if (((KeyEvent)e).getKeyCode() == 38) {
                        MaximizeActiveDialogAction.maximize(dialog2);
                    } else {
                        MaximizeActiveDialogAction.normalize(dialog2);
                    }
                });
                return true;
            }
            return false;
        }
    }

    private static class WindowsAltSuppressor
    implements EventDispatcher {
        private boolean myWaitingForAltRelease;
        private Robot myRobot;

        private WindowsAltSuppressor() {
        }

        @Override
        public boolean dispatch(@NotNull AWTEvent e) {
            boolean dispatch2 = true;
            if (e instanceof KeyEvent) {
                boolean pureAlt;
                KeyEvent ke = (KeyEvent)e;
                Component component = ke.getComponent();
                boolean bl = pureAlt = ke.getKeyCode() == 18 && (ke.getModifiers() | 8) == 8;
                if (!pureAlt) {
                    this.myWaitingForAltRelease = false;
                } else {
                    UISettings uiSettings = UISettings.getInstanceOrNull();
                    if (uiSettings == null || !SystemInfo.isWindows || !Registry.is((String)"actionSystem.win.suppressAlt") || !uiSettings.getHideToolStripes() && !uiSettings.getPresentationMode()) {
                        return false;
                    }
                    if (ke.getID() == 401) {
                        dispatch2 = !this.myWaitingForAltRelease;
                    } else if (ke.getID() == 402) {
                        if (this.myWaitingForAltRelease) {
                            this.myWaitingForAltRelease = false;
                            dispatch2 = false;
                        } else if (component != null) {
                            SwingUtilities.invokeLater(() -> {
                                try {
                                    Window window = UIUtil.getWindow((Component)component);
                                    if (window == null || !window.isActive()) {
                                        return;
                                    }
                                    this.myWaitingForAltRelease = true;
                                    if (this.myRobot == null) {
                                        this.myRobot = new Robot();
                                    }
                                    this.myRobot.keyPress(18);
                                    this.myRobot.keyRelease(18);
                                }
                                catch (AWTException e1) {
                                    LOG.debug((Throwable)e1);
                                }
                            });
                        }
                    }
                }
            }
            return !dispatch2;
        }
    }

    private final class MyFireIdleRequest
    implements Runnable {
        private final Runnable myRunnable;
        private final int myTimeout;

        MyFireIdleRequest(Runnable runnable2, int timeout) {
            this.myTimeout = timeout;
            this.myRunnable = runnable2;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            this.myRunnable.run();
            Object object = IdeEventQueue.this.myLock;
            synchronized (object) {
                if (IdeEventQueue.this.myIdleListeners.contains(this.myRunnable)) {
                    IdeEventQueue.this.myIdleRequestsAlarm.addRequest((Runnable)this, this.myTimeout, ModalityState.NON_MODAL);
                }
            }
        }

        public int getTimeout() {
            return this.myTimeout;
        }

        public String toString() {
            return "Fire idle request. delay: " + this.getTimeout() + "; runnable: " + this.myRunnable;
        }
    }

    @FunctionalInterface
    public static interface EventDispatcher {
        public boolean dispatch(@NotNull AWTEvent var1);
    }

    private static class IdeEventQueueHolder {
        private static final IdeEventQueue INSTANCE = new IdeEventQueue();

        private IdeEventQueueHolder() {
        }
    }
}

