/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectManager;
import com.intellij.openapi.project.ProjectManagerListener;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.wm.IdeFocusManager;
import com.intellij.openapi.wm.StatusBar;
import com.intellij.openapi.wm.impl.IdeFrameImpl;
import com.intellij.util.Alarm;
import com.intellij.util.BitUtil;
import com.intellij.util.ReflectionUtil;
import java.awt.Component;
import java.awt.KeyboardFocusManager;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.HierarchyEvent;
import java.lang.reflect.Field;
import java.util.EventListener;
import javax.accessibility.Accessible;
import javax.accessibility.AccessibleContext;
import javax.swing.JComponent;
import javax.swing.JProgressBar;
import javax.swing.JSlider;
import javax.swing.SwingUtilities;
import javax.swing.event.CaretListener;
import javax.swing.event.ChangeListener;
import javax.swing.event.DocumentListener;
import javax.swing.text.AbstractDocument;
import javax.swing.text.Document;
import javax.swing.text.JTextComponent;
import org.jetbrains.annotations.NotNull;

public final class SwingCleanuper {
    private final Alarm myAlarm;

    public SwingCleanuper(@NotNull Application application) {
        this.myAlarm = new Alarm((Disposable)application);
        application.getMessageBus().connect().subscribe(ProjectManager.TOPIC, (Object)new ProjectManagerListener(){

            public void projectOpened(@NotNull Project project) {
                SwingCleanuper.this.myAlarm.cancelAllRequests();
            }

            public void projectClosed(@NotNull Project project) {
                SwingCleanuper.this.myAlarm.cancelAllRequests();
                SwingCleanuper.this.myAlarm.addRequest(() -> {
                    StatusBar statusBar;
                    Application app;
                    Window window = KeyboardFocusManager.getCurrentKeyboardFocusManager().getFocusedWindow();
                    IdeFrameImpl frame = (IdeFrameImpl)(window instanceof IdeFrameImpl ? window : SwingUtilities.getAncestorOfClass(IdeFrameImpl.class, window));
                    if (frame != null && (app = ApplicationManager.getApplication()) != null && app.isActive() && (statusBar = frame.getStatusBar()) != null) {
                        IdeFocusManager.getGlobalInstance().doWhenFocusSettlesDown(() -> IdeFocusManager.getGlobalInstance().requestFocus((Component)((JComponent)statusBar), true));
                    }
                }, 2500);
            }
        });
        if (SystemInfo.isMac) {
            Toolkit.getDefaultToolkit().addAWTEventListener(event -> {
                if (!Registry.is((String)"ide.mac.fix.accessibleLeak")) {
                    return;
                }
                HierarchyEvent he = (HierarchyEvent)event;
                if (BitUtil.isSet((long)he.getChangeFlags(), (long)4L) && he.getComponent() != null && !he.getComponent().isShowing()) {
                    ChangeListener[] changeListeners;
                    Component c = he.getComponent();
                    if (c instanceof JTextComponent) {
                        CaretListener[] carets;
                        JTextComponent textComponent = (JTextComponent)c;
                        for (CaretListener each : carets = (CaretListener[])textComponent.getListeners(CaretListener.class)) {
                            if (!SwingCleanuper.isCAccessibleListener(each)) continue;
                            textComponent.removeCaretListener(each);
                        }
                        Document document = textComponent.getDocument();
                        if (document instanceof AbstractDocument) {
                            DocumentListener[] documentListeners;
                            for (DocumentListener each : documentListeners = ((AbstractDocument)document).getDocumentListeners()) {
                                if (!SwingCleanuper.isCAccessibleListener(each)) continue;
                                document.removeDocumentListener(each);
                            }
                        }
                    } else if (c instanceof JProgressBar) {
                        JProgressBar bar = (JProgressBar)c;
                        changeListeners = bar.getChangeListeners();
                        for (ChangeListener each : changeListeners) {
                            if (!SwingCleanuper.isCAccessibleListener(each)) continue;
                            bar.removeChangeListener(each);
                        }
                    } else if (c instanceof JSlider) {
                        JSlider slider = (JSlider)c;
                        changeListeners = slider.getChangeListeners();
                        for (ChangeListener each : changeListeners) {
                            if (!SwingCleanuper.isCAccessibleListener(each)) continue;
                            slider.removeChangeListener(each);
                        }
                    }
                    Field nativeAXResource_Field = null;
                    Field accessibleContext_Field = null;
                    try {
                        nativeAXResource_Field = ReflectionUtil.findField(AccessibleContext.class, Object.class, (String)"nativeAXResource");
                        accessibleContext_Field = ReflectionUtil.findField(Component.class, AccessibleContext.class, (String)"accessibleContext");
                    }
                    catch (NoSuchFieldException document) {
                        // empty catch block
                    }
                    if (accessibleContext_Field != null) {
                        try {
                            Object resource;
                            AccessibleContext ac = (AccessibleContext)accessibleContext_Field.get(c);
                            if (ac != null && (ac = c.getAccessibleContext()) != null && (resource = nativeAXResource_Field.get(ac)) != null && SwingCleanuper.isCAccessible(resource)) {
                                Field accessible = ReflectionUtil.findField(resource.getClass(), Accessible.class, (String)"accessible");
                                accessible.set(resource, null);
                            }
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    }
                }
            }, 32768L);
        }
    }

    private static boolean isCAccessible(Object resource) {
        String name = resource.getClass().getName();
        return SwingCleanuper.isCAccessible(name);
    }

    static boolean isCAccessible(String name) {
        return name.equals("apple.awt.CAccessible") || name.equals("sun.lwawt.macosx.CAccessible");
    }

    private static boolean isCAccessibleListener(EventListener listener2) {
        return listener2 != null && listener2.toString().contains("AXTextChangeNotifier");
    }
}

