/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.actions;

import com.intellij.ide.actions.AboutPopup;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.application.ApplicationNamesInfo;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.wm.WindowManager;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AboutAction
extends AnAction
implements DumbAware {
    public void update(@NotNull AnActionEvent e) {
        e.getPresentation().setEnabledAndVisible(!SystemInfo.isMacSystemMenu || !"MainMenu".equals(e.getPlace()));
        e.getPresentation().setDescription("Show information about " + ApplicationNamesInfo.getInstance().getFullProductName());
    }

    public void actionPerformed(@NotNull AnActionEvent e) {
        AboutAction.perform((Project)e.getData(CommonDataKeys.PROJECT));
    }

    public static void perform(@Nullable Project project) {
        AboutPopup.show(WindowManager.getInstance().suggestParentWindow(project), false);
    }
}

