/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.actions;

import com.intellij.ide.DataManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.PlatformDataKeys;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.wm.ToolWindow;
import com.intellij.ui.content.Content;
import com.intellij.ui.content.ContentManager;
import com.intellij.ui.content.ContentManagerUtil;
import java.awt.Component;
import org.jetbrains.annotations.NotNull;

public class CloseActiveTabAction
extends AnAction
implements DumbAware {
    public void actionPerformed(@NotNull AnActionEvent e) {
        DataContext context;
        ToolWindow tw;
        Content selectedContent;
        ContentManager contentManager = ContentManagerUtil.getContentManagerFromContext(e.getDataContext(), true);
        boolean processed2 = false;
        if (contentManager != null && contentManager.canCloseContents() && (selectedContent = contentManager.getSelectedContent()) != null && selectedContent.isCloseable()) {
            contentManager.removeContent(selectedContent, true);
            processed2 = true;
        }
        if (!processed2 && contentManager != null && (tw = (ToolWindow)PlatformDataKeys.TOOL_WINDOW.getData(context = DataManager.getInstance().getDataContext((Component)contentManager.getComponent()))) != null) {
            tw.hide(null);
        }
    }

    public void update(@NotNull AnActionEvent event) {
        Presentation presentation = event.getPresentation();
        ContentManager contentManager = ContentManagerUtil.getContentManagerFromContext(event.getDataContext(), true);
        presentation.setEnabled(contentManager != null && contentManager.canCloseContents());
        if (!presentation.isEnabled() && contentManager != null) {
            DataContext context = DataManager.getInstance().getDataContext((Component)contentManager.getComponent());
            presentation.setEnabled(PlatformDataKeys.TOOL_WINDOW.getData(context) != null);
        }
    }
}

