/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.actions;

import com.intellij.ide.IdeBundle;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.command.CommandProcessor;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.fileEditor.ex.FileEditorManagerEx;
import com.intellij.openapi.fileEditor.impl.EditorWindow;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import org.jetbrains.annotations.NotNull;

public class CloseAllEditorsAction
extends AnAction
implements DumbAware {
    public void actionPerformed(@NotNull AnActionEvent e) {
        Project project = (Project)e.getData(CommonDataKeys.PROJECT);
        CommandProcessor commandProcessor = CommandProcessor.getInstance();
        commandProcessor.executeCommand(project, () -> {
            VirtualFile[] openFiles;
            EditorWindow window = (EditorWindow)e.getData(EditorWindow.DATA_KEY);
            if (window != null) {
                VirtualFile[] files2;
                for (VirtualFile file2 : files2 = window.getFiles()) {
                    window.closeFile(file2);
                }
                return;
            }
            FileEditorManagerEx fileEditorManager = FileEditorManagerEx.getInstanceEx(project);
            VirtualFile selectedFile = fileEditorManager.getSelectedFiles()[0];
            for (VirtualFile openFile2 : openFiles = fileEditorManager.getSiblings(selectedFile)) {
                fileEditorManager.closeFile(openFile2);
            }
        }, IdeBundle.message((String)"command.close.all.editors", (Object[])new Object[0]), null);
    }

    public void update(@NotNull AnActionEvent event) {
        Presentation presentation = event.getPresentation();
        EditorWindow editorWindow = (EditorWindow)event.getData(EditorWindow.DATA_KEY);
        if (editorWindow != null && editorWindow.inSplitter()) {
            presentation.setText(IdeBundle.message((String)"action.close.all.editors.in.tab.group", (Object[])new Object[0]));
        } else {
            presentation.setText(IdeBundle.message((String)"action.close.all.editors", (Object[])new Object[0]));
        }
        Project project = (Project)event.getData(CommonDataKeys.PROJECT);
        if (project == null) {
            presentation.setEnabled(false);
            return;
        }
        presentation.setEnabled(FileEditorManager.getInstance((Project)project).getSelectedFiles().length > 0);
    }
}

