/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.actions;

import com.intellij.ide.actions.ShowFilePathAction;
import com.intellij.ide.troubleshooting.CompositeGeneralTroubleInfoCollector;
import com.intellij.ide.util.PropertiesComponent;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.application.ApplicationNamesInfo;
import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.settingsSummary.ProblemType;
import com.intellij.troubleshooting.TroubleInfoCollector;
import com.intellij.util.SystemProperties;
import com.intellij.util.io.Compressor;
import java.io.File;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CollectZippedLogsAction
extends AnAction
implements DumbAware {
    private static final String CONFIRMATION_DIALOG = "zipped.logs.action.show.confirmation.dialog";

    public void actionPerformed(@NotNull AnActionEvent e) {
        Project project = e.getProject();
        boolean doNotShowDialog = PropertiesComponent.getInstance().getBoolean(CONFIRMATION_DIALOG);
        try {
            if (!doNotShowDialog) {
                Messages.showIdeaMessageDialog((Project)project, (String)"Included logs and settings may contain sensitive data.", (String)"Sensitive Data", (String[])new String[]{"Show in " + ShowFilePathAction.getFileManagerName()}, (int)1, (Icon)Messages.getWarningIcon(), (DialogWrapper.DoNotAskOption)new DialogWrapper.DoNotAskOption.Adapter(){

                    public void rememberChoice(boolean selected, int exitCode) {
                        PropertiesComponent.getInstance().setValue(CollectZippedLogsAction.CONFIRMATION_DIALOG, selected);
                    }
                });
            }
            final StringBuilder troubleshooting = CollectZippedLogsAction.collectInfoFromExtensions(project);
            File zippedLogsFile = (File)ProgressManager.getInstance().run((Task.WithResult)new Task.WithResult<File, IOException>(project, "Collecting Log Files", false){

                protected File compute(@NotNull ProgressIndicator indicator) throws IOException {
                    indicator.setIndeterminate(true);
                    return CollectZippedLogsAction.createZip(troubleshooting);
                }
            });
            if (ShowFilePathAction.isSupported()) {
                ShowFilePathAction.openFile(zippedLogsFile);
            } else {
                Messages.showInfoMessage((String)zippedLogsFile.getAbsolutePath(), (String)"Log File");
            }
        }
        catch (IOException exception) {
            Messages.showErrorDialog((String)("Can't create zip file with logs: " + exception.getLocalizedMessage()), (String)"Can't Create File");
        }
    }

    @NotNull
    private static File createZip(@Nullable StringBuilder troubleshooting) throws IOException {
        String productName = ApplicationNamesInfo.getInstance().getLowercaseProductName().toLowerCase(Locale.US);
        File zippedLogsFile = FileUtil.createTempFile((String)(productName + "-logs-" + CollectZippedLogsAction.getDate()), (String)".zip");
        try (Compressor.Zip zip = new Compressor.Zip(zippedLogsFile);){
            zip.addDirectory(new File(PathManager.getLogPath()));
            if (troubleshooting != null) {
                zip.addFile("troubleshooting.txt", troubleshooting.toString().getBytes(StandardCharsets.UTF_8));
            }
            for (File javaErrorLog : CollectZippedLogsAction.getJavaErrorLogs()) {
                zip.addFile(javaErrorLog.getName(), javaErrorLog);
            }
        }
        catch (IOException exception) {
            FileUtil.delete((File)zippedLogsFile);
            throw exception;
        }
        return zippedLogsFile;
    }

    @Nullable
    private static StringBuilder collectInfoFromExtensions(@Nullable Project project) {
        StringBuilder settings = null;
        if (project != null) {
            settings = new StringBuilder();
            settings.append(new CompositeGeneralTroubleInfoCollector().collectInfo(project));
            for (TroubleInfoCollector troubleInfoCollector : (TroubleInfoCollector[])TroubleInfoCollector.EP_SETTINGS.getExtensions()) {
                settings.append(troubleInfoCollector.collectInfo(project)).append('\n');
            }
            for (ProblemType problemType : (ProblemType[])ProblemType.EP_SETTINGS.getExtensions()) {
                settings.append(problemType.collectInfo(project)).append('\n');
            }
        }
        return settings;
    }

    private static File[] getJavaErrorLogs() {
        return new File(SystemProperties.getUserHome()).listFiles(file2 -> file2.isFile() && file2.getName().startsWith("java_error_in") && !file2.getName().endsWith("hprof"));
    }

    @NotNull
    private static String getDate() {
        return new SimpleDateFormat("yyyyMMdd-HHmmss").format(new Date());
    }

    public void update(@NotNull AnActionEvent e) {
        Presentation presentation = e.getPresentation();
        presentation.setText(CollectZippedLogsAction.getActionName());
    }

    @NotNull
    private static String getActionName() {
        return "Compress Logs and Show in " + ShowFilePathAction.getFileManagerName();
    }
}

