/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.actions;

import com.intellij.icons.AllIcons;
import com.intellij.ide.IdeBundle;
import com.intellij.ide.actions.CreateElementActionBase;
import com.intellij.idea.ActionsBundle;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.WriteAction;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.FileTypeManager;
import com.intellij.openapi.fileTypes.ex.FileTypeChooser;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.InputValidator;
import com.intellij.openapi.ui.InputValidatorEx;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.io.FileUtilRt;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.util.IncorrectOperationException;
import java.io.File;
import java.util.List;
import java.util.StringTokenizer;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CreateFileAction
extends CreateElementActionBase
implements DumbAware {
    public CreateFileAction() {
        super(ActionsBundle.message((String)"action.NewFile.text", (Object[])new Object[0]), IdeBundle.message((String)"action.create.new.file.description", (Object[])new Object[0]), AllIcons.FileTypes.Text);
    }

    public CreateFileAction(String text, String description, Icon icon) {
        super(text, description, icon);
    }

    public boolean isDumbAware() {
        return CreateFileAction.class.equals(((Object)((Object)this)).getClass());
    }

    @NotNull
    protected PsiElement[] invokeDialog(Project project, PsiDirectory directory) {
        MyValidator validator = new MyValidator(project, directory);
        if (ApplicationManager.getApplication().isUnitTestMode()) {
            try {
                return validator.create("test");
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        Messages.showInputDialog((Project)project, (String)IdeBundle.message((String)"prompt.enter.new.file.name", (Object[])new Object[0]), (String)IdeBundle.message((String)"title.new.file", (Object[])new Object[0]), null, null, (InputValidator)validator);
        return validator.getCreatedElements();
    }

    @NotNull
    protected PsiElement[] create(@NotNull String newName, PsiDirectory directory) throws Exception {
        MkDirs mkdirs = new MkDirs(newName, directory);
        return new PsiElement[]{(PsiElement)WriteAction.compute(() -> mkdirs.directory.createFile(this.getFileName(mkdirs.newName)))};
    }

    public static PsiDirectory findOrCreateSubdirectory(@NotNull PsiDirectory parent, @NotNull String subdirName) {
        PsiDirectory sub = parent.findSubdirectory(subdirName);
        return sub == null ? (PsiDirectory)WriteAction.compute(() -> parent.createSubdirectory(subdirName)) : sub;
    }

    protected String getActionName(PsiDirectory directory, String newName) {
        return IdeBundle.message((String)"progress.creating.file", (Object[])new Object[]{directory.getVirtualFile().getPresentableUrl(), File.separator, newName});
    }

    protected String getErrorTitle() {
        return IdeBundle.message((String)"title.cannot.create.file", (Object[])new Object[0]);
    }

    protected String getCommandName() {
        return IdeBundle.message((String)"command.create.file", (Object[])new Object[0]);
    }

    protected String getFileName(String newName) {
        if (this.getDefaultExtension() == null || FileUtilRt.getExtension((String)newName).length() > 0) {
            return newName;
        }
        return newName + "." + this.getDefaultExtension();
    }

    @Nullable
    protected String getDefaultExtension() {
        return null;
    }

    protected class MyValidator
    extends CreateElementActionBase.MyInputValidator
    implements InputValidatorEx {
        private String myErrorText;

        public MyValidator(Project project, PsiDirectory directory) {
            super((CreateElementActionBase)CreateFileAction.this, project, directory);
        }

        public boolean checkInput(String inputString) {
            StringTokenizer tokenizer = new StringTokenizer(inputString, "\\/");
            VirtualFile vFile = this.getDirectory().getVirtualFile();
            boolean firstToken = true;
            while (tokenizer.hasMoreTokens()) {
                String token = tokenizer.nextToken();
                if ((token.equals(".") || token.equals("..")) && !tokenizer.hasMoreTokens()) {
                    this.myErrorText = "Can't create file with name '" + token + "'";
                    return false;
                }
                if (vFile != null) {
                    if (firstToken && "~".equals(token)) {
                        VirtualFile userHomeDir = VfsUtil.getUserHomeDir();
                        if (userHomeDir == null) {
                            this.myErrorText = "User home directory not found";
                            return false;
                        }
                        vFile = userHomeDir;
                    } else if ("..".equals(token)) {
                        if ((vFile = vFile.getParent()) == null) {
                            this.myErrorText = "Not a valid directory";
                            return false;
                        }
                    } else if (!".".equals(token)) {
                        VirtualFile child2 = vFile.findChild(token);
                        if (child2 != null) {
                            if (!child2.isDirectory()) {
                                this.myErrorText = "A file with name '" + token + "' already exists";
                                return false;
                            }
                            if (!tokenizer.hasMoreTokens()) {
                                this.myErrorText = "A directory with name '" + token + "' already exists";
                                return false;
                            }
                        }
                        vFile = child2;
                    }
                }
                if (FileTypeManager.getInstance().isFileIgnored(CreateFileAction.this.getFileName(token))) {
                    this.myErrorText = "'" + token + "' is an ignored name (Settings | Editor | File Types | Ignore files and folders)";
                    return true;
                }
                firstToken = false;
            }
            this.myErrorText = null;
            return true;
        }

        public String getErrorText(String inputString) {
            return this.myErrorText;
        }

        public PsiElement[] create(@NotNull String newName) throws Exception {
            return super.create(newName);
        }

        public boolean canClose(String inputString) {
            if (inputString.length() == 0) {
                return super.canClose(inputString);
            }
            PsiDirectory psiDirectory = this.getDirectory();
            Project project = psiDirectory.getProject();
            FileType fileType = FileTypeChooser.getKnownFileTypeOrAssociate(psiDirectory.getVirtualFile(), CreateFileAction.this.getFileName(inputString), project);
            if (fileType == null) {
                return false;
            }
            return super.canClose(CreateFileAction.this.getFileName(inputString));
        }
    }

    public static class MkDirs {
        public final String newName;
        public final PsiDirectory directory;

        public MkDirs(@NotNull String newName, @NotNull PsiDirectory directory) {
            if (SystemInfo.isWindows) {
                newName = newName.replace('\\', '/');
            }
            if (newName.contains("/")) {
                List subDirs = StringUtil.split((String)newName, (String)"/");
                newName = (String)subDirs.remove(subDirs.size() - 1);
                boolean firstToken = true;
                for (String dir : subDirs) {
                    if (firstToken && "~".equals(dir)) {
                        VirtualFile userHomeDir = VfsUtil.getUserHomeDir();
                        if (userHomeDir == null) {
                            throw new IncorrectOperationException("User home directory not found");
                        }
                        PsiDirectory directory1 = directory.getManager().findDirectory(userHomeDir);
                        if (directory1 == null) {
                            throw new IncorrectOperationException("User home directory not found");
                        }
                        directory = directory1;
                    } else if ("..".equals(dir)) {
                        PsiDirectory parentDirectory = directory.getParentDirectory();
                        if (parentDirectory == null) {
                            throw new IncorrectOperationException("Not a valid directory");
                        }
                        directory = parentDirectory;
                    } else if (!".".equals(dir)) {
                        directory = CreateFileAction.findOrCreateSubdirectory(directory, dir);
                    }
                    firstToken = false;
                }
            }
            this.newName = newName;
            this.directory = directory;
        }
    }
}

