/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.actions;

import com.intellij.ide.CutProvider;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.PlatformDataKeys;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import org.jetbrains.annotations.NotNull;

public class CutAction
extends AnAction
implements DumbAware {
    public CutAction() {
        this.setEnabledInModalContext(true);
    }

    public void actionPerformed(@NotNull AnActionEvent e) {
        CutProvider provider = CutAction.getAvailableCutProvider(e);
        if (provider == null) {
            return;
        }
        provider.performCut(e.getDataContext());
    }

    private static CutProvider getAvailableCutProvider(@NotNull AnActionEvent e) {
        CutProvider provider = (CutProvider)PlatformDataKeys.CUT_PROVIDER.getData(e.getDataContext());
        Project project = e.getProject();
        if (project != null && DumbService.isDumb((Project)project) && !DumbService.isDumbAware((Object)provider)) {
            return null;
        }
        return provider;
    }

    public void update(@NotNull AnActionEvent event) {
        Presentation presentation = event.getPresentation();
        DataContext dataContext = event.getDataContext();
        CutProvider provider = CutAction.getAvailableCutProvider(event);
        Project project = (Project)CommonDataKeys.PROJECT.getData(dataContext);
        presentation.setEnabled(project != null && project.isOpen() && provider != null && provider.isCutEnabled(dataContext));
        if (event.getPlace().equals("EditorPopup") && provider != null) {
            presentation.setVisible(provider.isCutVisible(dataContext));
        } else {
            presentation.setVisible(true);
        }
    }
}

