/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.actions;

import com.intellij.ide.actions.GotoFileItemProvider;
import com.intellij.ide.util.gotoByName.GotoFileModel;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.LibraryOrSdkOrderEntry;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.roots.OrderEntry;
import com.intellij.openapi.roots.OrderRootType;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileVisitor;
import com.intellij.openapi.vfs.newvfs.NewVirtualFile;
import com.intellij.psi.codeStyle.MinusculeMatcher;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.GlobalSearchScopesCore;
import com.intellij.util.Processor;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.BooleanSupplier;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class DirectoryPathMatcher {
    @NotNull
    private final GotoFileModel myModel;
    @Nullable
    private final List<Pair<VirtualFile, String>> myFiles;
    @NotNull
    final String dirPattern;

    private DirectoryPathMatcher(@NotNull GotoFileModel model, @Nullable List<Pair<VirtualFile, String>> files2, @NotNull String pattern) {
        this.myModel = model;
        this.myFiles = files2;
        this.dirPattern = pattern;
    }

    @Nullable
    static DirectoryPathMatcher root(@NotNull GotoFileModel model, @NotNull String pattern) {
        DirectoryPathMatcher matcher = new DirectoryPathMatcher(model, null, "");
        for (int i = 0; i < pattern.length(); ++i) {
            if ((matcher = matcher.appendChar(pattern.charAt(i))) != null) continue;
            return null;
        }
        return matcher;
    }

    @Nullable
    DirectoryPathMatcher appendChar(char c) {
        String nextPattern = this.dirPattern + c;
        if (c == '*' || c == '/' || c == ' ') {
            return new DirectoryPathMatcher(this.myModel, this.myFiles, nextPattern);
        }
        List<Pair<VirtualFile, String>> files2 = this.getMatchingRoots();
        ArrayList<Pair<VirtualFile, String>> nextRoots = new ArrayList<Pair<VirtualFile, String>>();
        MinusculeMatcher matcher = GotoFileItemProvider.getQualifiedNameMatcher(nextPattern);
        ArrayList<VirtualFile> nonMatchingRoots = new ArrayList<VirtualFile>();
        for (Pair<VirtualFile, String> pair : files2) {
            if (DirectoryPathMatcher.containsChar((CharSequence)pair.second, c) && matcher.matches((String)pair.second)) {
                nextRoots.add(pair);
                continue;
            }
            nonMatchingRoots.add((VirtualFile)pair.first);
        }
        this.processProjectFilesUnder(nonMatchingRoots, (Processor<? super VirtualFile>)((Processor)sub -> {
            if (!sub.isDirectory()) {
                return false;
            }
            if (!DirectoryPathMatcher.containsChar(sub.getNameSequence(), c)) {
                return true;
            }
            String fullName = this.myModel.getFullName((VirtualFile)sub);
            if (fullName == null) {
                return true;
            }
            if (matcher.matches(fullName = FileUtil.toSystemIndependentName((String)fullName))) {
                nextRoots.add(Pair.create((Object)sub, (Object)fullName));
                return false;
            }
            return true;
        }));
        return nextRoots.isEmpty() ? null : new DirectoryPathMatcher(this.myModel, nextRoots, nextPattern);
    }

    @Nullable
    Set<String> findFileNamesMatchingIfCheap(char nextLetter, MinusculeMatcher matcher) {
        List<Pair<VirtualFile, String>> files2 = this.getMatchingRoots();
        HashSet<String> names = new HashSet<String>();
        AtomicInteger counter = new AtomicInteger();
        BooleanSupplier tooMany = () -> counter.get() > 1000;
        ArrayList<VirtualFile> nonMatchingRoots = new ArrayList<VirtualFile>();
        for (Pair<VirtualFile, String> pair : files2) {
            if (DirectoryPathMatcher.containsChar((CharSequence)pair.second, nextLetter) && matcher.matches((String)pair.second)) {
                names.add(((VirtualFile)pair.first).getName());
                continue;
            }
            nonMatchingRoots.add((VirtualFile)pair.first);
        }
        this.processProjectFilesUnder(nonMatchingRoots, (Processor<? super VirtualFile>)((Processor)sub -> {
            counter.incrementAndGet();
            if (tooMany.getAsBoolean()) {
                return false;
            }
            String name = sub.getName();
            if (DirectoryPathMatcher.containsChar(name, nextLetter) && matcher.matches(name)) {
                names.add(name);
            }
            return true;
        }));
        return tooMany.getAsBoolean() ? null : names;
    }

    @NotNull
    private List<Pair<VirtualFile, String>> getMatchingRoots() {
        return this.myFiles != null ? this.myFiles : DirectoryPathMatcher.getProjectRoots(this.myModel);
    }

    @NotNull
    GlobalSearchScope narrowDown(@NotNull GlobalSearchScope fileSearchScope) {
        if (this.myFiles == null) {
            return fileSearchScope;
        }
        VirtualFile[] array = (VirtualFile[])ContainerUtil.map2Array(this.myFiles, VirtualFile.class, p -> (VirtualFile)p.first);
        return GlobalSearchScopesCore.directoriesScope((Project)this.myModel.getProject(), (boolean)true, (VirtualFile[])array).intersectWith(fileSearchScope);
    }

    private void processProjectFilesUnder(List<VirtualFile> roots, final Processor<? super VirtualFile> consumer) {
        final HashSet visited = new HashSet(roots.size());
        final GlobalSearchScope scope = GlobalSearchScope.allScope((Project)this.myModel.getProject());
        for (VirtualFile root : roots) {
            VfsUtilCore.visitChildrenRecursively((VirtualFile)root, (VirtualFileVisitor)new VirtualFileVisitor<Object>(new VirtualFileVisitor.Option[0]){

                public boolean visitFile(@NotNull VirtualFile file2) {
                    return visited.add(file2) && scope.contains(file2) && consumer.process((Object)file2);
                }

                @Nullable
                public Iterable<VirtualFile> getChildrenIterable(@NotNull VirtualFile file2) {
                    return file2 instanceof NewVirtualFile ? ((NewVirtualFile)file2).getCachedChildren() : null;
                }
            });
        }
    }

    private static boolean containsChar(CharSequence name, char c) {
        return StringUtil.indexOf((CharSequence)name, (char)c, (int)0, (int)name.length(), (boolean)false) >= 0;
    }

    @NotNull
    private static List<Pair<VirtualFile, String>> getProjectRoots(GotoFileModel model) {
        HashSet roots = new HashSet();
        for (Module module : ModuleManager.getInstance((Project)model.getProject()).getModules()) {
            Collections.addAll(roots, ModuleRootManager.getInstance((Module)module).getContentRoots());
            for (OrderEntry entry : ModuleRootManager.getInstance((Module)module).getOrderEntries()) {
                if (!(entry instanceof LibraryOrSdkOrderEntry)) continue;
                Collections.addAll(roots, entry.getFiles(OrderRootType.CLASSES));
                Collections.addAll(roots, entry.getFiles(OrderRootType.SOURCES));
            }
        }
        return roots.stream().map(root -> {
            VirtualFile top = model.getTopLevelRoot((VirtualFile)root);
            return top != null ? top : root;
        }).distinct().map(r -> Pair.create((Object)r, (Object)StringUtil.notNullize((String)model.getFullName((VirtualFile)r)))).collect(Collectors.toList());
    }
}

