/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.actions;

import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.fileEditor.impl.FileEditorManagerImpl;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import java.util.Arrays;
import org.jetbrains.annotations.NotNull;

public class EditSourceInNewWindowAction
extends DumbAwareAction {
    public void actionPerformed(@NotNull AnActionEvent e) {
        Project project = (Project)e.getRequiredData(CommonDataKeys.PROJECT);
        FileEditorManager manager = FileEditorManager.getInstance((Project)project);
        ((FileEditorManagerImpl)manager).openFileInNewWindow(this.getVirtualFiles(e)[0]);
    }

    protected VirtualFile[] getVirtualFiles(@NotNull AnActionEvent e) {
        VirtualFile[] virtualFileArray;
        VirtualFile[] files2 = (VirtualFile[])e.getData(CommonDataKeys.VIRTUAL_FILE_ARRAY);
        if (files2 != null) {
            return (VirtualFile[])Arrays.stream(files2).filter(file2 -> !file2.isDirectory()).toArray(VirtualFile[]::new);
        }
        VirtualFile file3 = (VirtualFile)e.getData(CommonDataKeys.VIRTUAL_FILE);
        if (file3 == null || file3.isDirectory()) {
            virtualFileArray = VirtualFile.EMPTY_ARRAY;
        } else {
            VirtualFile[] virtualFileArray2 = new VirtualFile[1];
            virtualFileArray = virtualFileArray2;
            virtualFileArray2[0] = file3;
        }
        return virtualFileArray;
    }

    public void update(@NotNull AnActionEvent e) {
        e.getPresentation().setEnabledAndVisible(EditSourceInNewWindowAction.getEventProject((AnActionEvent)e) != null && this.getVirtualFiles(e).length == 1);
    }
}

