/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.actions;

import com.intellij.codeInsight.TargetElementUtil;
import com.intellij.codeInsight.documentation.DocumentationManager;
import com.intellij.featureStatistics.FeatureUsageTracker;
import com.intellij.ide.BrowserUtil;
import com.intellij.ide.DataManager;
import com.intellij.ide.IdeBundle;
import com.intellij.lang.documentation.CompositeDocumentationProvider;
import com.intellij.lang.documentation.DocumentationProvider;
import com.intellij.lang.documentation.ExternalDocumentationHandler;
import com.intellij.lang.documentation.ExternalDocumentationProvider;
import com.intellij.openapi.actionSystem.ActionPlaces;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.PlatformDataKeys;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.ui.popup.ListPopupStep;
import com.intellij.openapi.ui.popup.PopupStep;
import com.intellij.openapi.ui.popup.util.BaseListPopupStep;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiReference;
import com.intellij.util.ArrayUtil;
import com.intellij.util.containers.ContainerUtil;
import java.awt.Component;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ExternalJavaDocAction
extends AnAction {
    public ExternalJavaDocAction() {
        this.setInjectedContext(true);
    }

    public void actionPerformed(@NotNull AnActionEvent e) {
        DataContext dataContext = e.getDataContext();
        Project project = (Project)CommonDataKeys.PROJECT.getData(dataContext);
        if (project == null) {
            return;
        }
        Editor editor = (Editor)CommonDataKeys.EDITOR.getData(dataContext);
        PsiElement element = ExternalJavaDocAction.getElement(dataContext, editor);
        if (element == null) {
            Messages.showMessageDialog((Project)project, (String)IdeBundle.message((String)"message.please.select.element.for.javadoc", (Object[])new Object[0]), (String)IdeBundle.message((String)"title.no.element.selected", (Object[])new Object[0]), (Icon)Messages.getErrorIcon());
            return;
        }
        PsiFile context = (PsiFile)CommonDataKeys.PSI_FILE.getData(dataContext);
        PsiElement originalElement = ExternalJavaDocAction.getOriginalElement(context, editor);
        DocumentationManager.storeOriginalElement(project, originalElement, element);
        ExternalJavaDocAction.showExternalJavadoc(element, originalElement, null, dataContext);
    }

    public static void showExternalJavadoc(PsiElement element, PsiElement originalElement, String docUrl, DataContext dataContext) {
        DocumentationProvider provider = DocumentationManager.getProviderFromElement(element);
        if (provider instanceof ExternalDocumentationHandler && ((ExternalDocumentationHandler)provider).handleExternal(element, originalElement)) {
            return;
        }
        FeatureUsageTracker.getInstance().triggerFeatureUsed("codeassists.javadoc.external");
        Project project = (Project)dataContext.getData(CommonDataKeys.PROJECT);
        Component contextComponent = (Component)PlatformDataKeys.CONTEXT_COMPONENT.getData(dataContext);
        ApplicationManager.getApplication().executeOnPooledThread(() -> {
            List<String> urls = StringUtil.isEmptyOrSpaces((String)docUrl) ? (List<String>)ReadAction.compute(() -> provider.getUrlFor(element, originalElement)) : Collections.singletonList(docUrl);
            if (provider instanceof ExternalDocumentationProvider && urls != null && urls.size() > 1) {
                for (String url : urls) {
                    List<String> thisUrlList = Collections.singletonList(url);
                    String doc = ((ExternalDocumentationProvider)provider).fetchExternalDocumentation(project, element, thisUrlList);
                    if (doc == null) continue;
                    urls = thisUrlList;
                    break;
                }
            }
            List<String> finalUrls = urls;
            ApplicationManager.getApplication().invokeLater(() -> {
                if (ContainerUtil.isEmpty((Collection)finalUrls)) {
                    ExternalDocumentationProvider externalDocumentationProvider;
                    if (element != null && provider instanceof ExternalDocumentationProvider && (externalDocumentationProvider = (ExternalDocumentationProvider)provider).canPromptToConfigureDocumentation(element)) {
                        externalDocumentationProvider.promptToConfigureDocumentation(element);
                    }
                } else if (finalUrls.size() == 1) {
                    BrowserUtil.browse((String)((String)finalUrls.get(0)));
                } else {
                    JBPopupFactory.getInstance().createListPopup((ListPopupStep)new BaseListPopupStep<String>("Choose external documentation root", ArrayUtil.toStringArray((Collection)finalUrls)){

                        public PopupStep onChosen(String selectedValue, boolean finalChoice) {
                            BrowserUtil.browse((String)selectedValue);
                            return FINAL_CHOICE;
                        }
                    }).showInBestPositionFor(DataManager.getInstance().getDataContext(contextComponent));
                }
            }, ModalityState.NON_MODAL);
        });
    }

    @Nullable
    private static PsiElement getOriginalElement(PsiFile context, Editor editor) {
        return context != null && editor != null ? context.findElementAt(editor.getCaretModel().getOffset()) : null;
    }

    public void update(@NotNull AnActionEvent event) {
        boolean enabled;
        Presentation presentation = event.getPresentation();
        DataContext dataContext = event.getDataContext();
        Editor editor = (Editor)CommonDataKeys.EDITOR.getData(dataContext);
        PsiElement element = ExternalJavaDocAction.getElement(dataContext, editor);
        PsiElement originalElement = ExternalJavaDocAction.getOriginalElement((PsiFile)CommonDataKeys.PSI_FILE.getData(dataContext), editor);
        DocumentationManager.storeOriginalElement((Project)CommonDataKeys.PROJECT.getData(dataContext), originalElement, element);
        DocumentationProvider provider = DocumentationManager.getProviderFromElement(element);
        if (provider instanceof ExternalDocumentationProvider) {
            ExternalDocumentationProvider edProvider = (ExternalDocumentationProvider)provider;
            enabled = CompositeDocumentationProvider.hasUrlsFor((DocumentationProvider)provider, (PsiElement)element, (PsiElement)originalElement) || edProvider.canPromptToConfigureDocumentation(element);
        } else {
            List urls = provider.getUrlFor(element, originalElement);
            boolean bl = enabled = urls != null && !urls.isEmpty();
        }
        if (editor != null) {
            presentation.setEnabled(enabled);
            if (ActionPlaces.isMainMenuOrActionSearch((String)event.getPlace())) {
                presentation.setVisible(true);
            } else {
                presentation.setVisible(enabled);
            }
        } else {
            presentation.setEnabled(enabled);
            presentation.setVisible(true);
        }
    }

    private static PsiElement getElement(DataContext dataContext, Editor editor) {
        PsiReference reference;
        PsiElement element = (PsiElement)CommonDataKeys.PSI_ELEMENT.getData(dataContext);
        if (element == null && editor != null && (reference = TargetElementUtil.findReference(editor, editor.getCaretModel().getOffset())) != null) {
            element = reference.getElement();
        }
        return element;
    }
}

