/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.actions;

import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.command.CommandProcessor;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileVisitor;
import org.jetbrains.annotations.NotNull;

public class FixLineSeparatorsAction
extends AnAction {
    public void actionPerformed(@NotNull AnActionEvent e) {
        Project project = (Project)e.getData(CommonDataKeys.PROJECT);
        VirtualFile[] vFiles = (VirtualFile[])e.getData(CommonDataKeys.VIRTUAL_FILE_ARRAY);
        if (project == null || vFiles == null) {
            return;
        }
        CommandProcessor.getInstance().executeCommand(project, () -> {
            for (VirtualFile vFile : vFiles) {
                FixLineSeparatorsAction.fixSeparators(vFile);
            }
        }, "fixing line separators", null);
    }

    private static void fixSeparators(VirtualFile vFile) {
        VfsUtilCore.visitChildrenRecursively((VirtualFile)vFile, (VirtualFileVisitor)new VirtualFileVisitor(new VirtualFileVisitor.Option[0]){

            public boolean visitFile(@NotNull VirtualFile file2) {
                Document document;
                if (!file2.isDirectory() && !file2.getFileType().isBinary() && FixLineSeparatorsAction.areSeparatorsBroken(document = FileDocumentManager.getInstance().getDocument(file2))) {
                    FixLineSeparatorsAction.fixSeparators(document);
                }
                return true;
            }
        });
    }

    private static boolean areSeparatorsBroken(Document document) {
        int count = document.getLineCount();
        for (int i = 1; i < count; i += 2) {
            if (document.getLineStartOffset(i) == document.getLineEndOffset(i)) continue;
            return false;
        }
        return true;
    }

    private static void fixSeparators(Document document) {
        ApplicationManager.getApplication().runWriteAction(() -> {
            for (int i = 1; i < document.getLineCount(); ++i) {
                int start2 = document.getLineEndOffset(i);
                int end = document.getLineEndOffset(i) + document.getLineSeparatorLength(i);
                document.deleteString(start2, end);
            }
        });
    }
}

