/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.actions;

import com.intellij.featureStatistics.FeatureUsageTracker;
import com.intellij.ide.IdeBundle;
import com.intellij.ide.actions.GotoActionBase;
import com.intellij.ide.actions.searcheverywhere.FileSearchEverywhereContributor;
import com.intellij.ide.util.gotoByName.ChooseByNameFilter;
import com.intellij.ide.util.gotoByName.ChooseByNamePopup;
import com.intellij.ide.util.gotoByName.GotoFileConfiguration;
import com.intellij.ide.util.gotoByName.GotoFileModel;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.fileEditor.OpenFileDescriptor;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.FileTypeManager;
import com.intellij.openapi.fileTypes.FileTypes;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.pom.Navigatable;
import com.intellij.psi.PsiFile;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;

public class GotoFileAction
extends GotoActionBase
implements DumbAware {
    public static final String ID = "GotoFile";

    @Override
    public void actionPerformed(@NotNull AnActionEvent e) {
        if (Registry.is((String)"new.search.everywhere")) {
            this.showInSearchEverywherePopup(FileSearchEverywhereContributor.class.getSimpleName(), e, true, true);
        } else {
            super.actionPerformed(e);
        }
    }

    @Override
    public void gotoActionPerformed(@NotNull AnActionEvent e) {
        final Project project = (Project)e.getData(CommonDataKeys.PROJECT);
        if (project == null) {
            return;
        }
        FeatureUsageTracker.getInstance().triggerFeatureUsed("navigation.popup.file");
        final GotoFileModel gotoFileModel = new GotoFileModel(project);
        GotoActionBase.GotoActionCallback<FileType> callback2 = new GotoActionBase.GotoActionCallback<FileType>(){

            @Override
            protected ChooseByNameFilter<FileType> createFilter(@NotNull ChooseByNamePopup popup2) {
                return new GotoFileFilter(popup2, gotoFileModel, project);
            }

            @Override
            public void elementChosen(ChooseByNamePopup popup2, Object element) {
                if (element == null) {
                    return;
                }
                ApplicationManager.getApplication().assertIsDispatchThread();
                Navigatable n = (Navigatable)element;
                if (element instanceof PsiFile) {
                    VirtualFile file2 = ((PsiFile)element).getVirtualFile();
                    if (file2 == null) {
                        return;
                    }
                    OpenFileDescriptor descriptor = new OpenFileDescriptor(project, file2, popup2.getLinePosition(), popup2.getColumnPosition());
                    n = descriptor.setUseCurrentWindow(popup2.isOpenInCurrentWindowRequested());
                }
                if (n.canNavigate()) {
                    n.navigate(true);
                }
            }
        };
        this.showNavigationPopup(e, gotoFileModel, callback2, IdeBundle.message((String)"go.to.file.toolwindow.title", (Object[])new Object[0]), true, true);
    }

    public static class FileTypeComparator
    implements Comparator<FileType> {
        public static final Comparator<FileType> INSTANCE = new FileTypeComparator();

        @Override
        public int compare(FileType o1, FileType o2) {
            if (o1 == o2) {
                return 0;
            }
            if (o1 == FileTypes.UNKNOWN) {
                return 1;
            }
            if (o2 == FileTypes.UNKNOWN) {
                return -1;
            }
            if (o1.isBinary() && !o2.isBinary()) {
                return 1;
            }
            if (!o1.isBinary() && o2.isBinary()) {
                return -1;
            }
            return o1.getName().compareToIgnoreCase(o2.getName());
        }
    }

    protected static class GotoFileFilter
    extends ChooseByNameFilter<FileType> {
        GotoFileFilter(ChooseByNamePopup popup2, GotoFileModel model, Project project) {
            super(popup2, model, GotoFileConfiguration.getInstance(project), project);
        }

        @Override
        @NotNull
        protected List<FileType> getAllFilterValues() {
            ArrayList<FileType> elements = new ArrayList<FileType>();
            ContainerUtil.addAll(elements, (Object[])FileTypeManager.getInstance().getRegisteredFileTypes());
            Collections.sort(elements, FileTypeComparator.INSTANCE);
            return elements;
        }

        @Override
        protected String textForFilterValue(@NotNull FileType value) {
            return value.getName();
        }

        @Override
        protected Icon iconForFilterValue(@NotNull FileType value) {
            return value.getIcon();
        }
    }
}

