/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.actions;

import com.intellij.ide.actions.DirectoryPathMatcher;
import com.intellij.ide.util.gotoByName.ChooseByNameBase;
import com.intellij.ide.util.gotoByName.ChooseByNamePopup;
import com.intellij.ide.util.gotoByName.DefaultChooseByNameItemProvider;
import com.intellij.ide.util.gotoByName.DefaultFileNavigationContributor;
import com.intellij.ide.util.gotoByName.GotoFileModel;
import com.intellij.ide.util.gotoByName.MatchResult;
import com.intellij.navigation.ChooseByNameContributor;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.io.FileUtilRt;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFileSystemItem;
import com.intellij.psi.codeStyle.FixingLayoutMatcher;
import com.intellij.psi.codeStyle.MinusculeMatcher;
import com.intellij.psi.codeStyle.NameUtil;
import com.intellij.psi.search.FilenameIndex;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.util.Processor;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.FList;
import com.intellij.util.indexing.FindSymbolParameters;
import com.intellij.util.indexing.IdFilter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import one.util.streamex.IntStreamEx;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GotoFileItemProvider
extends DefaultChooseByNameItemProvider {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.ide.actions.GotoFileItemProvider");
    private final Project myProject;
    private final GotoFileModel myModel;

    public GotoFileItemProvider(@NotNull Project project, @Nullable PsiElement context, GotoFileModel model) {
        super(context);
        this.myProject = project;
        this.myModel = model;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean filterElements(@NotNull ChooseByNameBase base, @NotNull String pattern, boolean everywhere, @NotNull ProgressIndicator indicator, @NotNull Processor<Object> consumer) {
        long start2 = System.currentTimeMillis();
        try {
            PsiFileSystemItem absolute = this.getFileByAbsolutePath(pattern);
            if (absolute != null && !consumer.process((Object)absolute)) {
                boolean bl = true;
                return bl;
            }
            if (pattern.startsWith("./") || pattern.startsWith(".\\")) {
                pattern = pattern.substring(1);
            }
            if (!this.processItemsForPattern(base, pattern, everywhere, consumer, indicator)) {
                boolean bl = false;
                return bl;
            }
            String fixed = FixingLayoutMatcher.fixLayout((String)pattern);
            boolean bl = fixed == null || this.processItemsForPattern(base, fixed, everywhere, consumer, indicator);
            return bl;
        }
        finally {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Goto File \"" + pattern + "\" took " + (System.currentTimeMillis() - start2) + " ms");
            }
        }
    }

    private boolean processItemsForPattern(@NotNull ChooseByNameBase base, @NotNull String pattern, boolean everywhere, @NotNull Processor<Object> consumer, @NotNull ProgressIndicator indicator) {
        int index;
        String sanitized = GotoFileItemProvider.getSanitizedPattern(pattern, this.myModel);
        int qualifierEnd = sanitized.lastIndexOf(47) + 1;
        NameGrouper grouper = new NameGrouper(sanitized.substring(qualifierEnd), indicator);
        this.processNames((Processor<String>)((Processor)grouper::processName));
        Ref hasSuggestions = Ref.create((Object)false);
        for (DirectoryPathMatcher dirMatcher = DirectoryPathMatcher.root(this.myModel, sanitized.substring(0, qualifierEnd)); dirMatcher != null; dirMatcher = dirMatcher.appendChar(grouper.namePattern.charAt(index))) {
            index = grouper.index;
            SuffixMatches group = grouper.nextGroup(base);
            if (group == null) break;
            if (group.processFiles(pattern, dirMatcher.dirPattern, everywhere, consumer, (Ref<Boolean>)hasSuggestions, dirMatcher)) continue;
            return false;
        }
        return true;
    }

    private void processNames(Processor<String> nameProcessor) {
        List contributors = DumbService.getDumbAwareExtensions((Project)this.myProject, (ExtensionPointName)ChooseByNameContributor.FILE_EP_NAME);
        for (ChooseByNameContributor contributor : contributors) {
            if (contributor instanceof DefaultFileNavigationContributor) {
                FilenameIndex.processAllFileNames(nameProcessor, FindSymbolParameters.searchScopeFor(this.myProject, true), IdFilter.getProjectIdFilter((Project)this.myProject, (boolean)true));
                continue;
            }
            this.myModel.processContributorNames(contributor, true, nameProcessor);
        }
    }

    @NotNull
    public static String getSanitizedPattern(@NotNull String pattern, GotoFileModel model) {
        return GotoFileItemProvider.removeSlashes(StringUtil.replace((String)ChooseByNamePopup.getTransformedPattern(pattern, model), (String)"\\", (String)"/"));
    }

    @NotNull
    public static MinusculeMatcher getQualifiedNameMatcher(@NotNull String pattern) {
        return NameUtil.buildMatcher((String)("*" + StringUtil.replace((String)StringUtil.replace((String)pattern, (String)"\\", (String)"*\\*"), (String)"/", (String)"*/*")), (NameUtil.MatchingCaseSensitivity)NameUtil.MatchingCaseSensitivity.NONE);
    }

    @NotNull
    private static String removeSlashes(String s) {
        if (s.startsWith("/")) {
            return GotoFileItemProvider.removeSlashes(s.substring(1));
        }
        if (s.endsWith("/")) {
            return GotoFileItemProvider.removeSlashes(s.substring(0, s.length() - 1));
        }
        return s;
    }

    @Nullable
    private PsiFileSystemItem getFileByAbsolutePath(@NotNull String pattern) {
        if (pattern.contains("/") || pattern.contains("\\")) {
            ProjectFileIndex index;
            String path = FileUtil.toSystemIndependentName((String)ChooseByNamePopup.getTransformedPattern(pattern, this.myModel));
            VirtualFile vFile = LocalFileSystem.getInstance().findFileByPathIfCached(path);
            if (vFile != null && ((index = ProjectFileIndex.SERVICE.getInstance((Project)this.myProject)).isInContent(vFile) || index.isInLibrary(vFile))) {
                return PsiUtilCore.findFileSystemItem((Project)this.myProject, (VirtualFile)vFile);
            }
        }
        return null;
    }

    @NotNull
    private List<PsiFileSystemItem> getFilesMatchingPath(@NotNull String pattern, boolean everywhere, MinusculeMatcher qualifierMatcher, List<String> fileNames, DirectoryPathMatcher dirMatcher, @NotNull ProgressIndicator indicator) {
        GlobalSearchScope scope = dirMatcher.narrowDown(FindSymbolParameters.searchScopeFor(this.myProject, everywhere));
        FindSymbolParameters parameters = new FindSymbolParameters(pattern, pattern, scope, null);
        ArrayList<PsiFileSystemItem> group = new ArrayList<PsiFileSystemItem>();
        HashMap<PsiFileSystemItem, Integer> qualifierMatchingDegrees = new HashMap<PsiFileSystemItem, Integer>();
        HashMap<PsiFileSystemItem, Integer> dirCloseness = new HashMap<PsiFileSystemItem, Integer>();
        HashMap<PsiFileSystemItem, Integer> nesting = new HashMap<PsiFileSystemItem, Integer>();
        for (String fileName2 : fileNames) {
            ProgressManager.checkCanceled();
            for (Object o : this.myModel.getElementsByName(fileName2, parameters, indicator)) {
                String qualifier;
                FList fragments;
                ProgressManager.checkCanceled();
                String fullName = this.myModel.getFullName(o);
                if (!(o instanceof PsiFileSystemItem) || fullName == null || (fragments = qualifierMatcher.matchingFragments(qualifier = StringUtil.getPackageName((String)FileUtilRt.toSystemIndependentName((String)fullName), (char)'/') + '/')) == null) continue;
                group.add((PsiFileSystemItem)o);
                int gapPenalty = fragments.isEmpty() ? 0 : qualifier.length() - ((TextRange)fragments.get(fragments.size() - 1)).getEndOffset();
                qualifierMatchingDegrees.put((PsiFileSystemItem)o, -qualifierMatcher.matchingDegree(qualifier, false, fragments) + gapPenalty);
                String matchingArea = qualifier.substring(fragments.isEmpty() ? 0 : ((TextRange)fragments.getHead()).getStartOffset());
                dirCloseness.put((PsiFileSystemItem)o, StringUtil.countChars((CharSequence)matchingArea, (char)'/'));
                nesting.put((PsiFileSystemItem)o, StringUtil.countChars((CharSequence)qualifier, (char)'/'));
            }
        }
        if (group.size() > 1) {
            Collections.sort(group, Comparator.comparing(f -> f instanceof PsiDirectory).thenComparing(qualifierMatchingDegrees::get).thenComparing(i -> FileUtilRt.getNameWithoutExtension((String)i.getName()).toLowerCase()).thenComparing(i -> i.getName().toLowerCase()).thenComparing(nesting::get).thenComparing(dirCloseness::get).thenComparing(this.getPathProximityComparator()).thenComparing(this.myModel::getFullName));
        }
        return group;
    }

    private static int findMatchStartingPosition(String candidateName, String namePattern) {
        int namePos = candidateName.length();
        for (int i = namePattern.length(); i > 0; --i) {
            char c = namePattern.charAt(i - 1);
            if (!Character.isLetterOrDigit(c) || (namePos = StringUtil.lastIndexOfIgnoreCase((String)candidateName, (char)c, (int)(namePos - 1))) >= 0) continue;
            return i;
        }
        return 0;
    }

    private class SuffixMatches {
        final String patternSuffix;
        final MinusculeMatcher matcher;
        final List<MatchResult> matchingNames = new ArrayList<MatchResult>();
        final ProgressIndicator indicator;

        SuffixMatches(String pattern, @NotNull int from, ProgressIndicator indicator) {
            this.patternSuffix = pattern.substring(from);
            this.matcher = NameUtil.buildMatcher((String)((from > 0 ? " " : "*") + this.patternSuffix), (NameUtil.MatchingCaseSensitivity)NameUtil.MatchingCaseSensitivity.NONE);
            this.indicator = indicator;
        }

        public String toString() {
            return "SuffixMatches{patternSuffix='" + this.patternSuffix + '\'' + ", matchingNames=" + this.matchingNames + '}';
        }

        boolean matchName(@NotNull ChooseByNameBase base, String name) {
            MatchResult result2 = GotoFileItemProvider.matches(base, this.patternSuffix, this.matcher, name);
            if (result2 != null) {
                this.matchingNames.add(result2);
                return true;
            }
            return false;
        }

        boolean processFiles(@NotNull String pattern, String qualifierPattern, boolean everywhere, Processor<? super PsiFileSystemItem> processor2, Ref<Boolean> hasSuggestions, DirectoryPathMatcher dirMatcher) {
            Set<String> existingNames;
            MinusculeMatcher qualifierMatcher = GotoFileItemProvider.getQualifiedNameMatcher(qualifierPattern);
            List matchingNames = this.matchingNames;
            if (this.patternSuffix.length() <= 3 && (existingNames = dirMatcher.findFileNamesMatchingIfCheap(this.patternSuffix.charAt(0), this.matcher)) != null) {
                matchingNames = ContainerUtil.filter(matchingNames, mr -> existingNames.contains(mr.elementName));
            }
            List<List<String>> groups = this.groupByMatchingDegree(!pattern.startsWith("*"), matchingNames);
            for (List<String> group : groups) {
                List files2 = GotoFileItemProvider.this.getFilesMatchingPath(pattern, everywhere, qualifierMatcher, group, dirMatcher, this.indicator);
                if (!files2.isEmpty()) {
                    hasSuggestions.set((Object)true);
                }
                if (ContainerUtil.process((List)files2, processor2)) continue;
                return false;
            }
            return (Boolean)hasSuggestions.get() != false || everywhere || !this.hasSuggestionsOutsideProject(pattern, qualifierMatcher, groups, dirMatcher);
        }

        private boolean hasSuggestionsOutsideProject(@NotNull String pattern, MinusculeMatcher qualifierMatcher, List<List<String>> groups, DirectoryPathMatcher dirMatcher) {
            return ContainerUtil.exists(groups, group -> !GotoFileItemProvider.this.getFilesMatchingPath(pattern, true, qualifierMatcher, group, dirMatcher, this.indicator).isEmpty());
        }

        private List<List<String>> groupByMatchingDegree(boolean preferStartMatches, List<MatchResult> matchingNames) {
            if (matchingNames.isEmpty()) {
                return Collections.emptyList();
            }
            ArrayList<List<String>> groups = new ArrayList<List<String>>();
            Comparator comparator2 = (mr1, mr2) -> {
                boolean exactPrefix1 = StringUtil.startsWith((CharSequence)mr1.elementName, (CharSequence)this.patternSuffix);
                boolean exactPrefix2 = StringUtil.startsWith((CharSequence)mr2.elementName, (CharSequence)this.patternSuffix);
                if (exactPrefix1 && exactPrefix2) {
                    return 0;
                }
                if (exactPrefix1 != exactPrefix2) {
                    return exactPrefix1 ? -1 : 1;
                }
                return mr1.compareDegrees((MatchResult)mr2, preferStartMatches);
            };
            Collections.sort(matchingNames, comparator2);
            ArrayList group = ContainerUtil.newArrayList((Object[])new String[]{matchingNames.get((int)0).elementName});
            for (int j = 1; j < matchingNames.size(); ++j) {
                MatchResult current = matchingNames.get(j);
                if (comparator2.compare(matchingNames.get(j - 1), current) == 0) {
                    group.add(current.elementName);
                    continue;
                }
                groups.add(group);
                group = ContainerUtil.newArrayList((Object[])new String[]{current.elementName});
            }
            groups.add(group);
            return groups;
        }
    }

    private class NameGrouper {
        private final String namePattern;
        @NotNull
        private final ProgressIndicator indicator;
        private final List<List<String>> candidateNames;
        private int index = 0;

        NameGrouper(@NotNull String namePattern, ProgressIndicator indicator) {
            this.namePattern = namePattern;
            this.candidateNames = IntStreamEx.range((int)0, (int)namePattern.length()).mapToObj(__ -> new ArrayList()).toList();
            this.indicator = indicator;
        }

        boolean processName(String name) {
            ProgressManager.checkCanceled();
            int position = GotoFileItemProvider.findMatchStartingPosition(name, this.namePattern);
            if (position < this.namePattern.length()) {
                this.candidateNames.get(position).add(name);
            }
            return true;
        }

        @Nullable
        SuffixMatches nextGroup(ChooseByNameBase base) {
            if (this.index >= this.namePattern.length()) {
                return null;
            }
            SuffixMatches matches = new SuffixMatches(this.namePattern, this.index, this.indicator);
            for (String name : this.candidateNames.get(this.index)) {
                if (matches.matchName(base, name) || this.index + 1 >= this.namePattern.length()) continue;
                this.candidateNames.get(this.index + 1).add(name);
            }
            this.candidateNames.set(this.index, null);
            ++this.index;
            return matches;
        }
    }
}

