/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.actions;

import com.intellij.featureStatistics.FeatureUsageTracker;
import com.intellij.ide.actions.GotoActionBase;
import com.intellij.ide.actions.GotoClassAction;
import com.intellij.ide.actions.searcheverywhere.SymbolSearchEverywhereContributor;
import com.intellij.ide.util.gotoByName.ChooseByNameFilter;
import com.intellij.ide.util.gotoByName.ChooseByNameLanguageFilter;
import com.intellij.ide.util.gotoByName.ChooseByNamePopup;
import com.intellij.ide.util.gotoByName.GotoClassSymbolConfiguration;
import com.intellij.ide.util.gotoByName.GotoSymbolModel2;
import com.intellij.lang.Language;
import com.intellij.navigation.ChooseByNameRegistry;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.psi.PsiDocumentManager;
import org.jetbrains.annotations.NotNull;

public class GotoSymbolAction
extends GotoActionBase {
    @Override
    public void actionPerformed(@NotNull AnActionEvent e) {
        if (Registry.is((String)"new.search.everywhere")) {
            this.showInSearchEverywherePopup(SymbolSearchEverywhereContributor.class.getSimpleName(), e, true, true);
        } else {
            super.actionPerformed(e);
        }
    }

    @Override
    public void gotoActionPerformed(@NotNull AnActionEvent e) {
        FeatureUsageTracker.getInstance().triggerFeatureUsed("navigation.popup.symbol");
        final Project project = e.getProject();
        if (project == null) {
            return;
        }
        final GotoSymbolModel2 model = new GotoSymbolModel2(project);
        PsiDocumentManager.getInstance((Project)project).commitAllDocuments();
        this.showNavigationPopup(e, model, new GotoActionBase.GotoActionCallback<Language>(){

            @Override
            protected ChooseByNameFilter<Language> createFilter(@NotNull ChooseByNamePopup popup2) {
                return new ChooseByNameLanguageFilter(popup2, model, GotoClassSymbolConfiguration.getInstance(project), project);
            }

            @Override
            public void elementChosen(ChooseByNamePopup popup2, Object element) {
                GotoClassAction.handleSubMemberNavigation(popup2, element);
            }
        }, "Symbols matching patterns", true);
    }

    @Override
    protected boolean hasContributors(@NotNull DataContext dataContext) {
        return ChooseByNameRegistry.getInstance().getSymbolModelContributors().size() > 0;
    }
}

