/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.actions;

import com.intellij.ide.IdeBundle;
import com.intellij.ide.actions.HideToolWindowAction;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.wm.ex.ToolWindowManagerEx;
import com.intellij.openapi.wm.impl.DesktopLayout;
import org.jetbrains.annotations.NotNull;

public class HideAllToolWindowsAction
extends AnAction
implements DumbAware {
    public void actionPerformed(@NotNull AnActionEvent e) {
        Project project = e.getProject();
        if (project == null) {
            return;
        }
        HideAllToolWindowsAction.performAction(project);
    }

    public static void performAction(Project project) {
        ToolWindowManagerEx toolWindowManager = ToolWindowManagerEx.getInstanceEx(project);
        DesktopLayout layout = new DesktopLayout();
        layout.copyFrom(toolWindowManager.getLayout());
        toolWindowManager.clearSideStack();
        String[] ids = toolWindowManager.getToolWindowIds();
        boolean hasVisible = false;
        for (String id : ids) {
            if (!HideToolWindowAction.shouldBeHiddenByShortCut(toolWindowManager, id)) continue;
            toolWindowManager.getToolWindow(id).hide(null);
            hasVisible = true;
        }
        if (hasVisible) {
            toolWindowManager.setLayoutToRestoreLater(layout);
            toolWindowManager.activateEditorComponent();
        } else {
            DesktopLayout restoredLayout = toolWindowManager.getLayoutToRestoreLater();
            if (restoredLayout != null) {
                toolWindowManager.setLayoutToRestoreLater(null);
                toolWindowManager.setLayout(restoredLayout);
            }
        }
    }

    public void update(@NotNull AnActionEvent event) {
        String[] ids;
        Presentation presentation = event.getPresentation();
        Project project = event.getProject();
        if (project == null) {
            presentation.setEnabled(false);
            return;
        }
        ToolWindowManagerEx toolWindowManager = ToolWindowManagerEx.getInstanceEx(project);
        for (String id : ids = toolWindowManager.getToolWindowIds()) {
            if (!HideToolWindowAction.shouldBeHiddenByShortCut(toolWindowManager, id)) continue;
            presentation.setEnabled(true);
            presentation.setText(IdeBundle.message((String)"action.hide.all.windows", (Object[])new Object[0]), true);
            return;
        }
        DesktopLayout layout = toolWindowManager.getLayoutToRestoreLater();
        if (layout != null) {
            presentation.setEnabled(true);
            presentation.setText(IdeBundle.message((String)"action.restore.windows", (Object[])new Object[0]));
            return;
        }
        presentation.setEnabled(false);
    }
}

