/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.actions;

import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.ActionPlaces;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.Separator;
import com.intellij.openapi.actionSystem.ex.ActionUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.function.Predicate;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class NewActionGroup
extends ActionGroup {
    private static final String PROJECT_OR_MODULE_GROUP_ID = "NewProjectOrModuleGroup";

    @NotNull
    public AnAction[] getChildren(@Nullable AnActionEvent e) {
        AnAction[] newProjectActions;
        AnAction newGroup;
        AnAction[] actions = ((ActionGroup)ActionManager.getInstance().getAction("WeighingNewGroup")).getChildren(e);
        if ((e == null || ActionPlaces.isMainMenuOrActionSearch((String)e.getPlace())) && (newGroup = ActionManager.getInstance().getAction(PROJECT_OR_MODULE_GROUP_ID)) != null && (newProjectActions = ((ActionGroup)newGroup).getChildren(e)).length > 0) {
            ArrayList<Separator> mergedActions = new ArrayList<Separator>(newProjectActions.length + 1 + actions.length);
            Collections.addAll(mergedActions, newProjectActions);
            mergedActions.add(Separator.getInstance());
            Collections.addAll(mergedActions, actions);
            return mergedActions.toArray(AnAction.EMPTY_ARRAY);
        }
        return actions;
    }

    public static boolean isActionInNewPopupMenu(@NotNull AnAction action) {
        ActionManager actionManager = ActionManager.getInstance();
        ActionGroup fileGroup = (ActionGroup)actionManager.getAction("FileMenu");
        if (!ActionUtil.anyActionFromGroupMatches((ActionGroup)fileGroup, (boolean)false, child2 -> child2 instanceof NewActionGroup)) {
            return false;
        }
        AnAction newProjectOrModuleGroup = ActionManager.getInstance().getAction(PROJECT_OR_MODULE_GROUP_ID);
        if (newProjectOrModuleGroup instanceof ActionGroup && ActionUtil.anyActionFromGroupMatches((ActionGroup)((ActionGroup)newProjectOrModuleGroup), (boolean)false, Predicate.isEqual(action))) {
            return true;
        }
        ActionGroup newGroup = (ActionGroup)actionManager.getAction("NewGroup");
        return ActionUtil.anyActionFromGroupMatches((ActionGroup)newGroup, (boolean)false, Predicate.isEqual(action));
    }
}

