/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.actions;

import com.intellij.ide.IdeBundle;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionGroupUtil;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.ActionPlaces;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.LangDataKeys;
import com.intellij.openapi.actionSystem.PopupAction;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.ui.popup.ListPopup;
import com.intellij.openapi.util.Condition;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class NewElementAction
extends DumbAwareAction
implements PopupAction {
    public void actionPerformed(@NotNull AnActionEvent e) {
        this.createPopup(e.getDataContext()).showInBestPositionFor(e.getDataContext());
    }

    @NotNull
    protected ListPopup createPopup(@NotNull DataContext dataContext) {
        return JBPopupFactory.getInstance().createActionGroupPopup(this.getPopupTitle(), this.getGroup(dataContext), dataContext, this.getActionSelectionAid(), this.isShowDisabledActions(), this.getDisposeCallback(), this.getMaxRowCount(), this.getPreselectActionCondition(dataContext), this.getPlace());
    }

    @Nullable
    protected JBPopupFactory.ActionSelectionAid getActionSelectionAid() {
        return null;
    }

    protected int getMaxRowCount() {
        return -1;
    }

    @Nullable
    protected Condition<AnAction> getPreselectActionCondition(DataContext dataContext) {
        return (Condition)LangDataKeys.PRESELECT_NEW_ACTION_CONDITION.getData(dataContext);
    }

    @Nullable
    protected Runnable getDisposeCallback() {
        return null;
    }

    protected boolean isShowDisabledActions() {
        return false;
    }

    protected String getPopupTitle() {
        return IdeBundle.message((String)"title.popup.new.element", (Object[])new Object[0]);
    }

    public void update(@NotNull AnActionEvent e) {
        Presentation presentation = e.getPresentation();
        Project project = e.getProject();
        if (project == null) {
            presentation.setEnabled(false);
            return;
        }
        if (!this.isEnabled(e)) {
            presentation.setEnabled(false);
            return;
        }
        presentation.setEnabled(!ActionGroupUtil.isGroupEmpty((ActionGroup)this.getGroup(e.getDataContext()), (AnActionEvent)e, (boolean)this.isEnabledInModalContext()));
    }

    protected boolean isEnabled(@NotNull AnActionEvent e) {
        return !Boolean.TRUE.equals(LangDataKeys.NO_NEW_ACTION.getData(e.getDataContext()));
    }

    protected ActionGroup getGroup(DataContext dataContext) {
        return (ActionGroup)ActionManager.getInstance().getAction("WeighingNewGroup");
    }

    @NotNull
    protected String getPlace() {
        return ActionPlaces.getActionGroupPopupPlace((String)"WeighingNewGroup");
    }
}

