/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.actions;

import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.fileTypes.FileTypeManager;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileVisitor;
import java.io.IOException;
import org.jetbrains.annotations.NotNull;

public class PruneEmptyDirectoriesAction
extends AnAction {
    public void update(@NotNull AnActionEvent e) {
        VirtualFile[] files2 = (VirtualFile[])CommonDataKeys.VIRTUAL_FILE_ARRAY.getData(e.getDataContext());
        e.getPresentation().setEnabled(files2 != null && files2.length > 0);
    }

    public void actionPerformed(@NotNull AnActionEvent e) {
        VirtualFile[] files2 = (VirtualFile[])CommonDataKeys.VIRTUAL_FILE_ARRAY.getData(e.getDataContext());
        assert (files2 != null);
        FileTypeManager ftManager = FileTypeManager.getInstance();
        try {
            for (VirtualFile file2 : files2) {
                PruneEmptyDirectoriesAction.pruneEmptiesIn(file2, ftManager);
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private static void pruneEmptiesIn(VirtualFile file2, final FileTypeManager ftManager) throws IOException {
        VfsUtilCore.visitChildrenRecursively((VirtualFile)file2, (VirtualFileVisitor)new VirtualFileVisitor(new VirtualFileVisitor.Option[0]){

            public boolean visitFile(@NotNull VirtualFile file2) {
                if (file2.isDirectory()) {
                    if (ftManager.isFileIgnored(file2)) {
                        return false;
                    }
                } else if (".DS_Store".equals(file2.getName())) {
                    PruneEmptyDirectoriesAction.delete(file2);
                    return false;
                }
                return true;
            }

            public void afterChildrenVisited(@NotNull VirtualFile file2) {
                if (file2.isDirectory() && file2.getChildren().length == 0) {
                    PruneEmptyDirectoriesAction.delete(file2);
                }
            }
        });
    }

    private static void delete(VirtualFile file2) {
        ApplicationManager.getApplication().runWriteAction(() -> {
            try {
                file2.delete(PruneEmptyDirectoriesAction.class);
                System.out.println("Deleted: " + file2.getPresentableUrl());
            }
            catch (IOException e) {
                Messages.showErrorDialog((String)("Cannot delete '" + file2.getPresentableUrl() + "', " + e.getLocalizedMessage()), (String)"IOException");
            }
        });
    }
}

