/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.actions;

import com.intellij.ide.actions.QualifiedNameProvider;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class QualifiedNameProviderUtil {
    private QualifiedNameProviderUtil() {
    }

    @Nullable
    public static PsiElement adjustElementToCopy(@NotNull PsiElement element) {
        for (QualifiedNameProvider provider : QualifiedNameProvider.EP_NAME.getExtensionList()) {
            PsiElement adjustedElement = provider.adjustElementToCopy(element);
            if (adjustedElement == null) continue;
            return adjustedElement;
        }
        return null;
    }

    @Nullable
    public static String getQualifiedName(@NotNull PsiElement element) {
        for (QualifiedNameProvider provider : QualifiedNameProvider.EP_NAME.getExtensionList()) {
            String qualifiedName = provider.getQualifiedName(element);
            if (qualifiedName == null) continue;
            return qualifiedName;
        }
        return null;
    }

    @Nullable
    public static PsiElement qualifiedNameToElement(@NotNull String qualifiedName, @NotNull Project project) {
        for (QualifiedNameProvider provider : QualifiedNameProvider.EP_NAME.getExtensionList()) {
            PsiElement element = provider.qualifiedNameToElement(qualifiedName, project);
            if (element == null) continue;
            return element;
        }
        return null;
    }
}

