/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.actions;

import com.intellij.ide.actions.QuickSwitchSchemeAction;
import com.intellij.ide.ui.LafManager;
import com.intellij.ide.ui.UITheme;
import com.intellij.ide.ui.laf.LafManagerImpl;
import com.intellij.ide.ui.laf.UIThemeBasedLookAndFeelInfo;
import com.intellij.ide.ui.laf.darcula.DarculaInstaller;
import com.intellij.ide.ui.laf.darcula.DarculaLookAndFeelInfo;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.application.ApplicationBundle;
import com.intellij.openapi.application.ApplicationNamesInfo;
import com.intellij.openapi.editor.colors.EditorColorsManager;
import com.intellij.openapi.editor.colors.EditorColorsScheme;
import com.intellij.openapi.options.Scheme;
import com.intellij.openapi.options.SchemeManager;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.ui.ColorUtil;
import com.intellij.util.ui.UIUtil;
import java.awt.Color;
import javax.swing.Icon;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import org.jetbrains.annotations.NotNull;

public class QuickChangeColorSchemeAction
extends QuickSwitchSchemeAction {
    protected void fillActions(Project project, @NotNull DefaultActionGroup group, @NotNull DataContext dataContext) {
        EditorColorsScheme current = EditorColorsManager.getInstance().getGlobalScheme();
        for (EditorColorsScheme scheme2 : EditorColorsManager.getInstance().getAllSchemes()) {
            QuickChangeColorSchemeAction.addScheme(group, current, scheme2, false);
        }
    }

    private static void addScheme(DefaultActionGroup group, EditorColorsScheme current, final EditorColorsScheme scheme2, final boolean addScheme) {
        group.add((AnAction)new DumbAwareAction(SchemeManager.getDisplayName((Scheme)scheme2), "", scheme2 == current ? ourCurrentAction : ourNotCurrentAction){

            public void actionPerformed(@NotNull AnActionEvent e) {
                if (addScheme) {
                    EditorColorsManager.getInstance().addColorsScheme(scheme2);
                }
                EditorColorsManager.getInstance().setGlobalScheme(scheme2);
                QuickChangeColorSchemeAction.changeLafIfNecessary(scheme2);
            }
        });
    }

    public static void changeLafIfNecessary(EditorColorsScheme scheme2) {
        UIManager.LookAndFeelInfo currentLafInfo;
        UITheme theme;
        String productName = ApplicationNamesInfo.getInstance().getFullProductName();
        LafManager lafManager = LafManager.getInstance();
        boolean isDarkEditorTheme = ColorUtil.isDark((Color)scheme2.getDefaultBackground());
        UIManager.LookAndFeelInfo suitableLaf = null;
        String schemeName = SchemeManager.getDisplayName((Scheme)scheme2);
        for (UIManager.LookAndFeelInfo laf : lafManager.getInstalledLookAndFeels()) {
            if (!(laf instanceof UIThemeBasedLookAndFeelInfo) || !schemeName.equals(((UIThemeBasedLookAndFeelInfo)laf).getTheme().getEditorSchemeName())) continue;
            suitableLaf = laf;
            break;
        }
        UITheme uITheme = theme = (currentLafInfo = lafManager.getCurrentLookAndFeel()) instanceof UIThemeBasedLookAndFeelInfo ? ((UIThemeBasedLookAndFeelInfo)currentLafInfo).getTheme() : null;
        if (isDarkEditorTheme && (UIUtil.isUnderIntelliJLaF() || theme != null && !theme.isDark())) {
            if (Messages.showYesNoDialog((String)ApplicationBundle.message((String)"color.scheme.theme.change.confirmation", (Object[])new Object[]{"dark", productName}), (String)ApplicationBundle.message((String)"color.scheme.theme.change.confirmation.title", (Object[])new Object[]{productName}), (String)Messages.YES_BUTTON, (String)Messages.NO_BUTTON, (Icon)Messages.getQuestionIcon()) == 0) {
                lafManager.setCurrentLookAndFeel(suitableLaf != null ? suitableLaf : new DarculaLookAndFeelInfo());
                lafManager.updateUI();
                SwingUtilities.invokeLater(DarculaInstaller::install);
            }
        } else if (!isDarkEditorTheme && (UIUtil.isUnderDarcula() || theme != null && theme.isDark()) && lafManager instanceof LafManagerImpl && Messages.showYesNoDialog((String)ApplicationBundle.message((String)"color.scheme.theme.change.confirmation", (Object[])new Object[]{"bright", productName}), (String)ApplicationBundle.message((String)"color.scheme.theme.change.confirmation.title", (Object[])new Object[]{productName}), (String)Messages.YES_BUTTON, (String)Messages.NO_BUTTON, (Icon)Messages.getQuestionIcon()) == 0) {
            lafManager.setCurrentLookAndFeel(suitableLaf != null ? suitableLaf : ((LafManagerImpl)lafManager).getDefaultLaf());
            lafManager.updateUI();
            SwingUtilities.invokeLater(DarculaInstaller::uninstall);
        }
    }

    protected boolean isEnabled() {
        return EditorColorsManager.getInstance().getAllSchemes().length > 1;
    }
}

