/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.actions;

import com.intellij.ide.actions.ChangeLAFAnimator;
import com.intellij.ide.actions.QuickSwitchSchemeAction;
import com.intellij.ide.ui.LafManager;
import com.intellij.ide.ui.LafManagerListener;
import com.intellij.ide.ui.laf.darcula.DarculaInstaller;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.util.ui.UIUtil;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import org.jetbrains.annotations.NotNull;

public class QuickChangeLookAndFeel
extends QuickSwitchSchemeAction {
    protected void fillActions(Project project, @NotNull DefaultActionGroup group, @NotNull DataContext dataContext) {
        final LafManager lafMan = LafManager.getInstance();
        UIManager.LookAndFeelInfo[] lfs = lafMan.getInstalledLookAndFeels();
        UIManager.LookAndFeelInfo current = lafMan.getCurrentLookAndFeel();
        for (final UIManager.LookAndFeelInfo lf : lfs) {
            group.add((AnAction)new DumbAwareAction(lf.getName(), "", lf == current ? ourCurrentAction : ourNotCurrentAction){

                public void actionPerformed(@NotNull AnActionEvent e) {
                    QuickChangeLookAndFeel.switchLafAndUpdateUI(lafMan, lf, false);
                }
            });
        }
    }

    public static void switchLafAndUpdateUI(@NotNull LafManager lafMan, @NotNull UIManager.LookAndFeelInfo lf, boolean async) {
        UIManager.LookAndFeelInfo cur = lafMan.getCurrentLookAndFeel();
        if (cur == lf) {
            return;
        }
        ChangeLAFAnimator animator = Registry.is((String)"ide.intellij.laf.enable.animation") ? ChangeLAFAnimator.showSnapshot() : null;
        boolean wasDarcula = UIUtil.isUnderDarcula();
        lafMan.setCurrentLookAndFeel(lf);
        Runnable updater = () -> {
            Ref updated = Ref.create((Object)false);
            LafManagerListener listener2 = s -> updated.set((Object)true);
            lafMan.addLafManagerListener(listener2);
            try {
                if (UIUtil.isUnderDarcula()) {
                    DarculaInstaller.install();
                } else if (wasDarcula) {
                    DarculaInstaller.uninstall();
                }
            }
            finally {
                lafMan.removeLafManagerListener(listener2);
                if (!((Boolean)updated.get()).booleanValue()) {
                    lafMan.updateUI();
                }
                if (animator != null) {
                    animator.hideSnapshotWithAnimation();
                }
            }
        };
        if (async) {
            SwingUtilities.invokeLater(updater);
        } else {
            updater.run();
        }
    }

    protected boolean isEnabled() {
        return LafManager.getInstance().getInstalledLookAndFeels().length > 1;
    }
}

