/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.actions;

import com.intellij.codeInsight.hint.HintUtil;
import com.intellij.ide.actions.RecentLocationItem;
import com.intellij.ide.actions.RecentLocationsAction;
import com.intellij.ide.actions.RecentLocationsDataModel;
import com.intellij.openapi.editor.CaretState;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.HighlighterColors;
import com.intellij.openapi.editor.actions.EditorActionUtil;
import com.intellij.openapi.editor.colors.CodeInsightColors;
import com.intellij.openapi.editor.colors.EditorColorsScheme;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.editor.markup.HighlighterTargetArea;
import com.intellij.openapi.editor.markup.TextAttributes;
import com.intellij.openapi.fileEditor.impl.IdeDocumentHistoryImpl;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.VerticalFlowLayout;
import com.intellij.openapi.util.SystemInfoRt;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.ui.ColoredListCellRenderer;
import com.intellij.ui.Gray;
import com.intellij.ui.JBColor;
import com.intellij.ui.SimpleColoredComponent;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.ui.components.JBCheckBox;
import com.intellij.ui.speedSearch.SpeedSearch;
import com.intellij.ui.speedSearch.SpeedSearchUtil;
import com.intellij.util.FontUtil;
import com.intellij.util.IconUtil;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.UIUtil;
import com.intellij.util.ui.components.BorderLayoutPanel;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.LayoutManager;
import java.util.ArrayList;
import java.util.Iterator;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.border.Border;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class RecentLocationsRenderer
extends ColoredListCellRenderer<RecentLocationItem> {
    @NotNull
    private final Project myProject;
    @NotNull
    private final SpeedSearch mySpeedSearch;
    @NotNull
    private final RecentLocationsDataModel myData;
    @NotNull
    private final JBCheckBox myCheckBox;

    RecentLocationsRenderer(@NotNull Project project, @NotNull SpeedSearch speedSearch, @NotNull RecentLocationsDataModel data, @NotNull JBCheckBox checkBox2) {
        this.myProject = project;
        this.mySpeedSearch = speedSearch;
        this.myData = data;
        this.myCheckBox = checkBox2;
    }

    public Component getListCellRendererComponent(JList<? extends RecentLocationItem> list2, RecentLocationItem value, int index, boolean selected, boolean hasFocus) {
        EditorEx editor = value.getEditor();
        if (this.myProject.isDisposed() || editor.isDisposed()) {
            return super.getListCellRendererComponent(list2, (Object)value, index, selected, hasFocus);
        }
        EditorColorsScheme colorsScheme = editor.getColorsScheme();
        String breadcrumbs = this.myData.getBreadcrumbsMap(this.myCheckBox.isSelected()).get(value.getInfo());
        JPanel panel2 = new JPanel((LayoutManager)new VerticalFlowLayout(0, 0));
        if (index != 0) {
            panel2.add(RecentLocationsRenderer.createSeparatorLine(colorsScheme));
        }
        panel2.add(RecentLocationsRenderer.createTitleComponent(this.myProject, list2, this.mySpeedSearch, breadcrumbs, value.getInfo(), colorsScheme, selected));
        panel2.add(RecentLocationsRenderer.setupEditorComponent(editor, editor.getDocument().getText(), this.mySpeedSearch, colorsScheme, selected));
        return panel2;
    }

    @NotNull
    private static Color getBackgroundColor(@NotNull EditorColorsScheme colorsScheme, boolean selected) {
        return selected ? HintUtil.getRecentLocationsSelectionColor() : colorsScheme.getDefaultBackground();
    }

    @NotNull
    private static JComponent createTitleComponent(@NotNull Project project, @NotNull JList<? extends RecentLocationItem> list2, @NotNull SpeedSearch speedSearch, @Nullable String breadcrumb, @NotNull IdeDocumentHistoryImpl.PlaceInfo placeInfo, @NotNull EditorColorsScheme colorsScheme, boolean selected) {
        BorderLayoutPanel title = ((BorderLayoutPanel)JBUI.Panels.simplePanel().withBorder((Border)JBUI.Borders.empty())).addToLeft((Component)RecentLocationsRenderer.createTitleTextComponent(project, list2, speedSearch, placeInfo, colorsScheme, breadcrumb, selected));
        title.setBorder((Border)JBUI.Borders.empty((int)8, (int)6, (int)5, (int)0));
        title.setBackground(RecentLocationsRenderer.getBackgroundColor(colorsScheme, selected));
        return title;
    }

    @NotNull
    private static JPanel createSeparatorLine(@NotNull EditorColorsScheme colorsScheme) {
        Color color = colorsScheme.getColor(CodeInsightColors.METHOD_SEPARATORS_COLOR);
        if (color == null) {
            color = JBColor.namedColor((String)"Group.separatorColor", (Color)new JBColor((Color)Gray.xCD, (Color)Gray.x51));
        }
        return JBUI.Panels.simplePanel().withBorder(JBUI.Borders.customLine((Color)color, (int)1, (int)0, (int)0, (int)0));
    }

    @NotNull
    private static JComponent setupEditorComponent(@NotNull EditorEx editor, @NotNull String text, @NotNull SpeedSearch speedSearch, @NotNull EditorColorsScheme colorsScheme, boolean selected) {
        Iterable ranges = speedSearch.matchingFragments(text);
        if (ranges != null) {
            RecentLocationsRenderer.selectSearchResultsInEditor(editor, ranges.iterator());
        } else {
            RecentLocationsAction.clearSelectionInEditor(editor);
        }
        editor.setBackgroundColor(RecentLocationsRenderer.getBackgroundColor(colorsScheme, selected));
        editor.setBorder((Border)JBUI.Borders.empty((int)0, (int)4, (int)6, (int)0));
        if (RecentLocationsAction.EMPTY_FILE_TEXT.equals(editor.getDocument().getText())) {
            editor.getMarkupModel().addRangeHighlighter(0, RecentLocationsAction.EMPTY_FILE_TEXT.length(), 1000, RecentLocationsRenderer.createEmptyTextForegroundTextAttributes(colorsScheme), HighlighterTargetArea.EXACT_RANGE);
        }
        return editor.getComponent();
    }

    @NotNull
    private static SimpleColoredComponent createTitleTextComponent(@NotNull Project project, @NotNull JList<? extends RecentLocationItem> list2, @NotNull SpeedSearch speedSearch, @NotNull IdeDocumentHistoryImpl.PlaceInfo placeInfo, @NotNull EditorColorsScheme colorsScheme, @Nullable String breadcrumbText, boolean selected) {
        Icon icon;
        String fileName2;
        SimpleColoredComponent titleTextComponent = new SimpleColoredComponent();
        String text = fileName2 = placeInfo.getFile().getName();
        titleTextComponent.append(fileName2, RecentLocationsRenderer.createFileNameTextAttributes(colorsScheme, selected));
        if (StringUtil.isNotEmpty((String)breadcrumbText) && !StringUtil.equals((CharSequence)breadcrumbText, (CharSequence)fileName2)) {
            text = text + " " + breadcrumbText;
            titleTextComponent.append("  ");
            titleTextComponent.append(breadcrumbText, RecentLocationsRenderer.createBreadcrumbsTextAttributes(colorsScheme, selected));
        }
        if ((icon = RecentLocationsRenderer.fetchIcon(project, placeInfo)) != null) {
            titleTextComponent.setIcon(icon);
            titleTextComponent.setIconTextGap(4);
        }
        titleTextComponent.setBorder((Border)JBUI.Borders.empty());
        if (!SystemInfoRt.isWindows) {
            titleTextComponent.setFont(FontUtil.minusOne((Font)UIUtil.getLabelFont()));
        }
        if (speedSearch.matchingFragments(text) != null) {
            SpeedSearchUtil.applySpeedSearchHighlighting(list2, (SimpleColoredComponent)titleTextComponent, (boolean)false, (boolean)selected);
        }
        return titleTextComponent;
    }

    @Nullable
    private static Icon fetchIcon(@NotNull Project project, @NotNull IdeDocumentHistoryImpl.PlaceInfo placeInfo) {
        return IconUtil.getIcon((VirtualFile)placeInfo.getFile(), (int)2, (Project)project);
    }

    @NotNull
    private static SimpleTextAttributes createFileNameTextAttributes(@NotNull EditorColorsScheme colorsScheme, boolean selected) {
        TextAttributes textAttributes = RecentLocationsRenderer.createDefaultTextAttributesWithBackground(colorsScheme, RecentLocationsRenderer.getBackgroundColor(colorsScheme, selected));
        textAttributes.setFontType(1);
        return SimpleTextAttributes.fromTextAttributes((TextAttributes)textAttributes);
    }

    @NotNull
    private static SimpleTextAttributes createBreadcrumbsTextAttributes(@NotNull EditorColorsScheme colorsScheme, boolean selected) {
        Color unusedForeground;
        Color backgroundColor = RecentLocationsRenderer.getBackgroundColor(colorsScheme, selected);
        TextAttributes attributes = colorsScheme.getAttributes(CodeInsightColors.NOT_USED_ELEMENT_ATTRIBUTES);
        if (attributes != null && (unusedForeground = attributes.getForegroundColor()) != null) {
            return SimpleTextAttributes.fromTextAttributes((TextAttributes)new TextAttributes(unusedForeground, backgroundColor, null, null, 0));
        }
        return SimpleTextAttributes.fromTextAttributes((TextAttributes)RecentLocationsRenderer.createDefaultTextAttributesWithBackground(colorsScheme, backgroundColor));
    }

    @NotNull
    private static TextAttributes createDefaultTextAttributesWithBackground(@NotNull EditorColorsScheme colorsScheme, @NotNull Color backgroundColor) {
        TextAttributes defaultTextAttributes = new TextAttributes();
        TextAttributes textAttributes = colorsScheme.getAttributes(HighlighterColors.TEXT);
        if (textAttributes != null) {
            defaultTextAttributes = textAttributes.clone();
            defaultTextAttributes.setBackgroundColor(backgroundColor);
        }
        return defaultTextAttributes;
    }

    @NotNull
    private static TextAttributes createEmptyTextForegroundTextAttributes(@NotNull EditorColorsScheme colorsScheme) {
        TextAttributes unusedAttributes = colorsScheme.getAttributes(CodeInsightColors.NOT_USED_ELEMENT_ATTRIBUTES);
        return unusedAttributes != null ? unusedAttributes : SimpleTextAttributes.GRAYED_ATTRIBUTES.toTextAttributes();
    }

    protected void customizeCellRenderer(@NotNull JList<? extends RecentLocationItem> list2, RecentLocationItem value, int index, boolean selected, boolean hasFocus) {
    }

    private static void selectSearchResultsInEditor(@NotNull Editor editor, @NotNull Iterator<TextRange> resultIterator) {
        if (!editor.getCaretModel().supportsMultipleCarets()) {
            return;
        }
        ArrayList<CaretState> caretStates = new ArrayList<CaretState>();
        while (resultIterator.hasNext()) {
            TextRange findResult = resultIterator.next();
            int caretOffset = findResult.getEndOffset();
            int selectionStartOffset = findResult.getStartOffset();
            int selectionEndOffset = findResult.getEndOffset();
            EditorActionUtil.makePositionVisible(editor, caretOffset);
            EditorActionUtil.makePositionVisible(editor, selectionStartOffset);
            EditorActionUtil.makePositionVisible(editor, selectionEndOffset);
            caretStates.add(new CaretState(editor.offsetToLogicalPosition(caretOffset), editor.offsetToLogicalPosition(selectionStartOffset), editor.offsetToLogicalPosition(selectionEndOffset)));
        }
        if (caretStates.isEmpty()) {
            return;
        }
        editor.getCaretModel().setCaretsAndSelections(caretStates);
    }
}

