/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.actions;

import com.intellij.ide.RecentProjectsManager;
import com.intellij.ide.ReopenProjectAction;
import com.intellij.idea.ActionsBundle;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.text.StringUtil;
import java.util.Arrays;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class RecentProjectsGroup
extends ActionGroup
implements DumbAware {
    public RecentProjectsGroup() {
        Presentation presentation = this.getTemplatePresentation();
        presentation.setText(ActionsBundle.message((String)(SystemInfo.isMac ? "group.reopen.mac.text" : "group.reopen.win.text"), (Object[])new Object[0]));
    }

    @NotNull
    public AnAction[] getChildren(@Nullable AnActionEvent e) {
        return RecentProjectsGroup.removeCurrentProject(e == null ? null : e.getProject(), RecentProjectsManager.getInstance().getRecentProjectsActions(true));
    }

    public static AnAction[] removeCurrentProject(Project project, AnAction[] actions) {
        if (project != null) {
            return (AnAction[])Arrays.stream(actions).filter(action -> !(action instanceof ReopenProjectAction) || !StringUtil.equals((CharSequence)((ReopenProjectAction)((Object)action)).getProjectPath(), (CharSequence)project.getBasePath())).toArray(AnAction[]::new);
        }
        return actions;
    }

    public void update(@NotNull AnActionEvent event) {
        Presentation presentation = event.getPresentation();
        presentation.setEnabled(RecentProjectsManager.getInstance().getRecentProjectsActions(true).length > 0);
    }
}

