/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.actions;

import com.intellij.icons.AllIcons;
import com.intellij.ide.BrowserUtil;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.application.ex.ApplicationInfoEx;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.io.FileUtil;
import java.io.File;
import org.jetbrains.annotations.NotNull;

public class RefCardAction
extends AnAction
implements DumbAware {
    private static final String REF_CARD_PATH = PathManager.getHomePath() + "/help/" + (SystemInfo.isMac ? "ReferenceCardForMac.pdf" : "ReferenceCard.pdf");

    public void actionPerformed(@NotNull AnActionEvent e) {
        File file2 = RefCardAction.getRefCardFile();
        if (file2.isFile()) {
            BrowserUtil.browse((File)file2);
        } else {
            String webUrl = RefCardAction.getKeymapUrl();
            if (webUrl != null) {
                BrowserUtil.browse((String)webUrl);
            }
        }
    }

    public void update(@NotNull AnActionEvent e) {
        e.getPresentation().setEnabledAndVisible(RefCardAction.isRefCardAvailable());
        boolean atWelcome = "WelcomeScreen".equals(e.getPlace());
        e.getPresentation().setIcon(atWelcome ? AllIcons.General.DefaultKeymap : null);
    }

    private static boolean isRefCardAvailable() {
        return RefCardAction.getRefCardFile().exists() || RefCardAction.getKeymapUrl() != null;
    }

    private static String getKeymapUrl() {
        ApplicationInfoEx appInfo = ApplicationInfoEx.getInstanceEx();
        return SystemInfo.isMac ? appInfo.getMacKeymapUrl() : appInfo.getWinKeymapUrl();
    }

    @NotNull
    private static File getRefCardFile() {
        return new File(FileUtil.toSystemDependentName((String)REF_CARD_PATH));
    }
}

