/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.actions;

import com.intellij.codeInsight.daemon.LineMarkerProvider;
import com.intellij.codeInsight.daemon.RelatedItemLineMarkerInfo;
import com.intellij.codeInsight.daemon.RelatedItemLineMarkerProvider;
import com.intellij.codeInsight.daemon.impl.LineMarkersPass;
import com.intellij.lang.Language;
import com.intellij.navigation.GotoRelatedItem;
import com.intellij.navigation.GotoRelatedProvider;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class RelatedItemLineMarkerGotoAdapter
extends GotoRelatedProvider {
    @NotNull
    public List<? extends GotoRelatedItem> getItems(@NotNull PsiElement context) {
        ArrayList<PsiElement> parents = new ArrayList<PsiElement>();
        HashSet<Language> languages = new HashSet<Language>();
        for (PsiElement current = context; current != null; current = current.getParent()) {
            parents.add(current);
            languages.add(current.getLanguage());
            if (current instanceof PsiFile) break;
        }
        ArrayList<LineMarkerProvider> providers = new ArrayList<LineMarkerProvider>();
        for (Language language : languages) {
            providers.addAll(LineMarkersPass.getMarkerProviders(language, context.getProject()));
        }
        ArrayList items = new ArrayList();
        for (LineMarkerProvider provider : providers) {
            if (!(provider instanceof RelatedItemLineMarkerProvider)) continue;
            ArrayList markers = new ArrayList();
            RelatedItemLineMarkerProvider relatedItemLineMarkerProvider = (RelatedItemLineMarkerProvider)provider;
            for (PsiElement parent : parents) {
                ContainerUtil.addIfNotNull(markers, (Object)relatedItemLineMarkerProvider.getLineMarkerInfo(parent));
            }
            relatedItemLineMarkerProvider.collectNavigationMarkers(parents, markers, true);
            RelatedItemLineMarkerGotoAdapter.addItemsForMarkers(markers, items);
        }
        return items;
    }

    private static void addItemsForMarkers(List<? extends RelatedItemLineMarkerInfo> markers, List<? super GotoRelatedItem> result2) {
        HashSet addedFiles = new HashSet();
        for (RelatedItemLineMarkerInfo relatedItemLineMarkerInfo : markers) {
            Collection items = relatedItemLineMarkerInfo.createGotoRelatedItems();
            for (GotoRelatedItem item : items) {
                PsiFile file2;
                PsiElement element = item.getElement();
                if (element instanceof PsiFile && addedFiles.contains(file2 = (PsiFile)element)) continue;
                if (element != null) {
                    ContainerUtil.addIfNotNull(addedFiles, (Object)element.getContainingFile());
                }
                result2.add((GotoRelatedItem)item);
            }
        }
    }
}

