/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.actions;

import com.intellij.ide.IdeBundle;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.command.CommandProcessor;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;

public class ReloadFromDiskAction
extends AnAction
implements DumbAware {
    public void actionPerformed(@NotNull AnActionEvent e) {
        Project project = e.getProject();
        Editor editor = (Editor)CommonDataKeys.EDITOR.getData(e.getDataContext());
        if (project == null || editor == null) {
            return;
        }
        PsiFile file2 = PsiDocumentManager.getInstance((Project)project).getPsiFile(editor.getDocument());
        if (file2 == null) {
            return;
        }
        String message = IdeBundle.message((String)"prompt.reload.file.from.disk", (Object[])new Object[]{file2.getVirtualFile().getPresentableUrl()});
        int res2 = Messages.showOkCancelDialog((Project)project, (String)message, (String)IdeBundle.message((String)"title.reload.file", (Object[])new Object[0]), (Icon)Messages.getWarningIcon());
        if (res2 != 0) {
            return;
        }
        Runnable command = () -> ApplicationManager.getApplication().runWriteAction(() -> {
            if (!project.isDisposed()) {
                file2.getVirtualFile().refresh(false, false);
                PsiManager.getInstance((Project)project).reloadFromDisk(file2);
            }
        });
        CommandProcessor.getInstance().executeCommand(project, command, IdeBundle.message((String)"command.reload.from.disk", (Object[])new Object[0]), null);
    }

    public void update(@NotNull AnActionEvent event) {
        PsiFile file2;
        boolean enabled = false;
        Project project = event.getProject();
        Editor editor = (Editor)CommonDataKeys.EDITOR.getData(event.getDataContext());
        if (project != null && editor != null && (file2 = PsiDocumentManager.getInstance((Project)project).getPsiFile(editor.getDocument())) != null && file2.getVirtualFile() != null) {
            enabled = true;
        }
        event.getPresentation().setEnabled(enabled);
    }
}

