/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.actions;

import com.intellij.ide.actions.ShowFilePathAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.vfs.VirtualFile;
import java.io.File;
import org.jetbrains.annotations.NotNull;

public class RevealFileAction
extends DumbAwareAction {
    public RevealFileAction() {
        this.getTemplatePresentation().setText(RevealFileAction.getActionName());
    }

    public void update(@NotNull AnActionEvent e) {
        VirtualFile file2 = ShowFilePathAction.findLocalFile((VirtualFile)CommonDataKeys.VIRTUAL_FILE.getData(e.getDataContext()));
        Presentation presentation = e.getPresentation();
        presentation.setText(RevealFileAction.getActionName());
        presentation.setEnabled(file2 != null);
    }

    @NotNull
    public static String getActionName() {
        return SystemInfo.isMac ? "Reveal in Finder" : "Show in " + ShowFilePathAction.getFileManagerName();
    }

    public void actionPerformed(@NotNull AnActionEvent e) {
        VirtualFile file2 = ShowFilePathAction.findLocalFile((VirtualFile)CommonDataKeys.VIRTUAL_FILE.getData(e.getDataContext()));
        if (file2 != null) {
            ShowFilePathAction.openFile(new File(file2.getPresentableUrl()));
        }
    }
}

