/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.actions;

import com.intellij.ide.SelectInContext;
import com.intellij.ide.SelectInManager;
import com.intellij.ide.SelectInTarget;
import com.intellij.ide.actions.SelectInContextImpl;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.wm.ToolWindowId;
import com.intellij.psi.PsiDocumentManager;
import org.jetbrains.annotations.NotNull;

public class SelectInProjectViewAction
extends DumbAwareAction {
    private static PsiDocumentManager getDocumentManager(Project project) {
        return project == null || project.isDisposed() ? null : PsiDocumentManager.getInstance((Project)project);
    }

    public void beforeActionPerformedUpdate(@NotNull AnActionEvent event) {
        PsiDocumentManager manager = SelectInProjectViewAction.getDocumentManager(event.getProject());
        if (manager != null) {
            manager.commitAllDocuments();
        }
        super.beforeActionPerformedUpdate(event);
    }

    public void update(@NotNull AnActionEvent event) {
        SelectInTarget target2 = SelectInManager.findSelectInTarget((String)ToolWindowId.PROJECT_VIEW, (Project)event.getProject());
        SelectInContext context = target2 == null ? null : SelectInContextImpl.createContext(event);
        event.getPresentation().setEnabled(context != null && target2.canSelect(context));
    }

    public void actionPerformed(@NotNull AnActionEvent event) {
        SelectInContext context;
        SelectInTarget target2 = SelectInManager.findSelectInTarget((String)ToolWindowId.PROJECT_VIEW, (Project)event.getProject());
        SelectInContext selectInContext = context = target2 == null ? null : SelectInContextImpl.createContext(event);
        if (context != null) {
            target2.selectIn(context, true);
        }
    }
}

