/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.actions;

import com.intellij.ide.actions.SearchEverywhereAction;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DataKey;
import com.intellij.openapi.actionSystem.PlatformDataKeys;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.actionSystem.ex.QuickList;
import com.intellij.openapi.keymap.Keymap;
import com.intellij.openapi.keymap.KeymapManager;
import com.intellij.openapi.keymap.impl.ActionShortcutRestrictions;
import com.intellij.openapi.keymap.impl.ui.KeymapPanel;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.popup.JBPopup;
import java.awt.Component;
import org.jetbrains.annotations.NotNull;

public class SetShortcutAction
extends AnAction
implements DumbAware {
    public static final DataKey<AnAction> SELECTED_ACTION = DataKey.create((String)"SelectedAction");

    public SetShortcutAction() {
        this.setEnabledInModalContext(true);
    }

    public void actionPerformed(@NotNull AnActionEvent e) {
        Keymap activeKeymap;
        JBPopup seDialog;
        Project project = e.getProject();
        JBPopup jBPopup = seDialog = project == null ? null : (JBPopup)project.getUserData(SearchEverywhereAction.SEARCH_EVERYWHERE_POPUP);
        if (seDialog == null) {
            return;
        }
        KeymapManager km = KeymapManager.getInstance();
        Keymap keymap = activeKeymap = km != null ? km.getActiveKeymap() : null;
        if (activeKeymap == null) {
            return;
        }
        AnAction action = (AnAction)e.getData(SELECTED_ACTION);
        Component component = (Component)e.getData(PlatformDataKeys.CONTEXT_COMPONENT);
        if (action == null || component == null) {
            return;
        }
        seDialog.cancel();
        String id = ActionManager.getInstance().getId(action);
        KeymapPanel.addKeyboardShortcut(id, ActionShortcutRestrictions.getInstance().getForActionId(id), activeKeymap, component, new QuickList[0]);
    }

    public void update(@NotNull AnActionEvent e) {
        Keymap activeKeymap;
        JBPopup seDialog;
        Presentation presentation = e.getPresentation();
        Project project = e.getProject();
        JBPopup jBPopup = seDialog = project == null ? null : (JBPopup)project.getUserData(SearchEverywhereAction.SEARCH_EVERYWHERE_POPUP);
        if (seDialog == null) {
            presentation.setEnabled(false);
            return;
        }
        KeymapManager km = KeymapManager.getInstance();
        Keymap keymap = activeKeymap = km != null ? km.getActiveKeymap() : null;
        if (activeKeymap == null) {
            presentation.setEnabled(false);
            return;
        }
        AnAction action = (AnAction)e.getData(SELECTED_ACTION);
        Component component = (Component)e.getData(PlatformDataKeys.CONTEXT_COMPONENT);
        presentation.setEnabled(action != null && component != null);
    }
}

