/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.actions;

import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.PopupAction;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.ui.awt.RelativePoint;
import com.intellij.util.ObjectUtils;
import com.intellij.util.ui.UIUtil;
import java.awt.Component;
import java.awt.KeyboardFocusManager;
import java.awt.Point;
import java.awt.event.MouseEvent;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;

public class ShowPopupMenuAction
extends DumbAwareAction
implements PopupAction {
    public ShowPopupMenuAction() {
        this.setEnabledInModalContext(true);
    }

    public void actionPerformed(@NotNull AnActionEvent e) {
        RelativePoint relPoint = JBPopupFactory.getInstance().guessBestPopupLocation(e.getDataContext());
        KeyboardFocusManager focusManager = KeyboardFocusManager.getCurrentKeyboardFocusManager();
        Component focusOwner = focusManager.getFocusOwner();
        Point point1 = relPoint.getPoint(focusOwner);
        Component deepest = (Component)ObjectUtils.notNull((Object)UIUtil.getDeepestComponentAt((Component)focusOwner, (int)point1.x, (int)(point1.y / 2)), (Object)focusOwner);
        Point point2 = relPoint.getPoint(deepest);
        Editor editor = (Editor)e.getData(CommonDataKeys.EDITOR);
        int coord = editor != null ? Math.max(0, point2.y - 1) : point2.y;
        MouseEvent event = new MouseEvent(focusOwner, 501, System.currentTimeMillis(), 0, point2.x, coord, 1, true, 3);
        for (Component cur = deepest; cur != null; cur = cur.getParent()) {
            cur.dispatchEvent(event);
            if (event.isConsumed()) break;
        }
    }

    public void update(@NotNull AnActionEvent e) {
        KeyboardFocusManager focusManager = KeyboardFocusManager.getCurrentKeyboardFocusManager();
        e.getPresentation().setEnabled(focusManager.getFocusOwner() instanceof JComponent);
    }
}

