/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.actions;

import com.intellij.ide.ui.search.SearchUtil;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.options.Configurable;
import com.intellij.openapi.options.ConfigurableGroup;
import com.intellij.openapi.options.ShowSettingsUtil;
import com.intellij.openapi.options.TabbedConfigurable;
import com.intellij.openapi.options.UnnamedConfigurable;
import com.intellij.openapi.options.ex.ConfigurableExtensionPointUtil;
import com.intellij.openapi.options.ex.ConfigurableVisitor;
import com.intellij.openapi.options.ex.ConfigurableWrapper;
import com.intellij.openapi.options.newEditor.SettingsDialogFactory;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectManager;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.ui.navigation.Place;
import com.intellij.util.ui.update.Activatable;
import com.intellij.util.ui.update.UiNotifyConnector;
import java.awt.Component;
import java.awt.Composite;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.Predicate;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ShowSettingsUtilImpl
extends ShowSettingsUtil {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.ide.actions.ShowSettingsUtilImpl");

    @NotNull
    private static Project getProject(@Nullable Project project) {
        return project != null ? project : ProjectManager.getInstance().getDefaultProject();
    }

    @NotNull
    public static DialogWrapper getDialog(@Nullable Project project, @NotNull ConfigurableGroup[] groups, @Nullable Configurable toSelect2) {
        project = ShowSettingsUtilImpl.getProject(project);
        ConfigurableGroup[] filteredGroups = ShowSettingsUtilImpl.filterEmptyGroups(groups);
        return SettingsDialogFactory.getInstance().create(project, filteredGroups, toSelect2, null);
    }

    @NotNull
    public static ConfigurableGroup[] getConfigurableGroups(@Nullable Project project, boolean withIdeSettings) {
        ConfigurableGroup group = ConfigurableExtensionPointUtil.getConfigurableGroup(project, withIdeSettings);
        return new ConfigurableGroup[]{group};
    }

    @NotNull
    public static List<Configurable> getConfigurables(@Nullable Project project, boolean withIdeSettings) {
        ConfigurableGroup group = ConfigurableExtensionPointUtil.getConfigurableGroup(project, withIdeSettings);
        ArrayList<Configurable> list2 = new ArrayList<Configurable>();
        ShowSettingsUtilImpl.collect(list2, group.getConfigurables());
        return list2;
    }

    private static void collect(List<? super Configurable> list2, Configurable ... configurables) {
        for (Configurable configurable : configurables) {
            list2.add((Configurable)configurable);
            if (!(configurable instanceof Configurable.Composite)) continue;
            Configurable.Composite composite = (Configurable.Composite)configurable;
            ShowSettingsUtilImpl.collect(list2, composite.getConfigurables());
        }
    }

    public void showSettingsDialog(@NotNull Project project, ConfigurableGroup ... group) {
        try {
            ShowSettingsUtilImpl.getDialog(project, group, null).show();
        }
        catch (Exception e) {
            LOG.error((Throwable)e);
        }
    }

    public <T extends Configurable> void showSettingsDialog(@Nullable Project project, @NotNull Class<T> configurableClass) {
        this.showSettingsDialog(project, configurableClass, null);
    }

    public <T extends Configurable> void showSettingsDialog(@Nullable Project project, @NotNull Class<T> configurableClass, @Nullable Consumer<T> additionalConfiguration) {
        assert (Configurable.class.isAssignableFrom(configurableClass)) : "Not a configurable: " + configurableClass.getName();
        this.showSettingsDialog(project, (? super Configurable it) -> ConfigurableWrapper.cast(configurableClass, (UnnamedConfigurable)it) != null, (? super Configurable it) -> {
            if (additionalConfiguration != null) {
                Configurable toConfigure = (Configurable)ConfigurableWrapper.cast(configurableClass, (UnnamedConfigurable)it);
                assert (toConfigure != null) : "Wrong configurable found: " + it.getClass();
                additionalConfiguration.accept(toConfigure);
            }
        });
    }

    public void showSettingsDialog(@Nullable Project project, final @NotNull Predicate<? super Configurable> predicate, @Nullable Consumer<? super Configurable> additionalConfiguration) {
        ConfigurableGroup[] groups = ShowSettingsUtilImpl.getConfigurableGroups(project, true);
        Configurable config2 = new ConfigurableVisitor(){

            @Override
            protected boolean accept(Configurable configurable) {
                return predicate.test(configurable);
            }
        }.find(groups);
        assert (config2 != null) : "Cannot find configurable for specified predicate";
        if (additionalConfiguration != null) {
            additionalConfiguration.accept((Configurable)config2);
        }
        ShowSettingsUtilImpl.getDialog(project, groups, config2).show();
    }

    public void showSettingsDialog(@Nullable Project project, @NotNull String nameToSelect) {
        ConfigurableGroup[] groups = ShowSettingsUtilImpl.getConfigurableGroups(project, true);
        Project actualProject = ShowSettingsUtilImpl.getProject(project);
        groups = ShowSettingsUtilImpl.filterEmptyGroups(groups);
        ShowSettingsUtilImpl.getDialog(actualProject, groups, ShowSettingsUtilImpl.findPreselectedByDisplayName(nameToSelect, groups)).show();
    }

    @Nullable
    private static Configurable findPreselectedByDisplayName(String preselectedConfigurableDisplayName, ConfigurableGroup[] groups) {
        List<Configurable> all = SearchUtil.expand(groups);
        for (Configurable each : all) {
            if (!preselectedConfigurableDisplayName.equals(each.getDisplayName())) continue;
            return each;
        }
        return null;
    }

    public static void showSettingsDialog(@Nullable Project project, String id2Select, String filter) {
        ConfigurableGroup[] group = ShowSettingsUtilImpl.getConfigurableGroups(project, true);
        group = ShowSettingsUtilImpl.filterEmptyGroups(group);
        Configurable configurable2Select = id2Select == null ? null : new ConfigurableVisitor.ByID(id2Select).find(group);
        SettingsDialogFactory.getInstance().create(ShowSettingsUtilImpl.getProject(project), group, configurable2Select, filter).show();
    }

    public void showSettingsDialog(@NotNull Project project, Configurable toSelect2) {
        ShowSettingsUtilImpl.getDialog(project, ShowSettingsUtilImpl.getConfigurableGroups(project, true), toSelect2).show();
    }

    @NotNull
    private static ConfigurableGroup[] filterEmptyGroups(@NotNull ConfigurableGroup[] group) {
        ArrayList<ConfigurableGroup> groups = new ArrayList<ConfigurableGroup>();
        for (ConfigurableGroup g : group) {
            if (g.getConfigurables().length <= 0) continue;
            groups.add(g);
        }
        return groups.toArray(new ConfigurableGroup[0]);
    }

    public boolean editConfigurable(Project project, Configurable configurable) {
        return this.editConfigurable(project, ShowSettingsUtilImpl.createDimensionKey(configurable), configurable);
    }

    public <T extends Configurable> T findProjectConfigurable(Project project, Class<T> confClass) {
        return ConfigurableExtensionPointUtil.findProjectConfigurable(project, confClass);
    }

    public boolean editConfigurable(Project project, String dimensionServiceKey, @NotNull Configurable configurable) {
        return this.editConfigurable(project, dimensionServiceKey, configurable, ShowSettingsUtilImpl.isWorthToShowApplyButton(configurable));
    }

    private static boolean isWorthToShowApplyButton(@NotNull Configurable configurable) {
        return configurable instanceof Place.Navigator || configurable instanceof Composite || configurable instanceof TabbedConfigurable;
    }

    public boolean editConfigurable(Project project, String dimensionServiceKey, @NotNull Configurable configurable, boolean showApplyButton) {
        return ShowSettingsUtilImpl.editConfigurable(null, project, configurable, dimensionServiceKey, null, showApplyButton);
    }

    public boolean editConfigurable(Project project, Configurable configurable, Runnable advancedInitialization) {
        return ShowSettingsUtilImpl.editConfigurable(null, project, configurable, ShowSettingsUtilImpl.createDimensionKey(configurable), advancedInitialization, ShowSettingsUtilImpl.isWorthToShowApplyButton(configurable));
    }

    public boolean editConfigurable(@Nullable Component parent, @NotNull Configurable configurable) {
        return this.editConfigurable(parent, configurable, null);
    }

    public boolean editConfigurable(@Nullable Component parent, @NotNull Configurable configurable, @Nullable Runnable advancedInitialization) {
        return ShowSettingsUtilImpl.editConfigurable(parent, null, configurable, ShowSettingsUtilImpl.createDimensionKey(configurable), advancedInitialization, ShowSettingsUtilImpl.isWorthToShowApplyButton(configurable));
    }

    private static boolean editConfigurable(@Nullable Component parent, @Nullable Project project, @NotNull Configurable configurable, String dimensionKey, final @Nullable Runnable advancedInitialization, boolean showApplyButton) {
        DialogWrapper editor = parent == null ? SettingsDialogFactory.getInstance().create(project, dimensionKey, configurable, showApplyButton, false) : SettingsDialogFactory.getInstance().create(parent, dimensionKey, configurable, showApplyButton, false);
        if (advancedInitialization != null) {
            new UiNotifyConnector.Once((Component)editor.getContentPane(), (Activatable)new Activatable.Adapter(){

                public void showNotify() {
                    advancedInitialization.run();
                }
            });
        }
        return editor.showAndGet();
    }

    @NotNull
    public static String createDimensionKey(@NotNull Configurable configurable) {
        return '#' + configurable.getDisplayName().replace('\n', '_').replace(' ', '_');
    }

    public boolean editConfigurable(Component parent, String dimensionServiceKey, Configurable configurable) {
        return ShowSettingsUtilImpl.editConfigurable(parent, null, configurable, dimensionServiceKey, null, ShowSettingsUtilImpl.isWorthToShowApplyButton(configurable));
    }
}

