/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.actions;

import com.intellij.ide.IdeBundle;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vcs.changes.VcsDirtyScopeManager;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.newvfs.NewVirtualFile;
import com.intellij.openapi.vfs.newvfs.RefreshQueue;
import com.intellij.openapi.vfs.newvfs.VfsPresentationUtil;
import com.intellij.openapi.wm.StatusBar;
import com.intellij.openapi.wm.WindowManager;
import com.intellij.util.containers.JBIterable;
import java.util.Collection;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class SynchronizeCurrentFileAction
extends AnAction
implements DumbAware {
    public void update(@NotNull AnActionEvent e) {
        List files2 = SynchronizeCurrentFileAction.getFiles(e).take(2).toList();
        Project project = e.getProject();
        if (project == null || files2.isEmpty()) {
            e.getPresentation().setEnabledAndVisible(false);
        } else {
            e.getPresentation().setEnabledAndVisible(true);
            e.getPresentation().setText(SynchronizeCurrentFileAction.getMessage(project, files2));
        }
    }

    @NotNull
    private static String getMessage(@NotNull Project project, @NotNull List<? extends VirtualFile> files2) {
        VirtualFile single = files2.size() == 1 ? files2.get(0) : null;
        return single != null ? IdeBundle.message((String)"action.synchronize.file", (Object[])new Object[]{VfsPresentationUtil.getPresentableNameForAction(project, single)}) : IdeBundle.message((String)"action.synchronize.selected.files", (Object[])new Object[0]);
    }

    public void actionPerformed(@NotNull AnActionEvent e) {
        Project project = SynchronizeCurrentFileAction.getEventProject((AnActionEvent)e);
        List files2 = SynchronizeCurrentFileAction.getFiles(e).toList();
        if (project == null || files2.isEmpty()) {
            return;
        }
        for (VirtualFile file2 : files2) {
            if (file2.isDirectory()) {
                file2.getChildren();
            }
            if (!(file2 instanceof NewVirtualFile)) continue;
            ((NewVirtualFile)file2).markClean();
            ((NewVirtualFile)file2).markDirtyRecursively();
        }
        RefreshQueue.getInstance().refresh(true, true, () -> SynchronizeCurrentFileAction.postRefresh(project, files2), (Collection)files2);
    }

    private static void postRefresh(Project project, List<? extends VirtualFile> files2) {
        VcsDirtyScopeManager dirtyScopeManager = VcsDirtyScopeManager.getInstance((Project)project);
        for (VirtualFile virtualFile : files2) {
            if (virtualFile.isDirectory()) {
                dirtyScopeManager.dirDirtyRecursively(virtualFile);
                continue;
            }
            dirtyScopeManager.fileDirty(virtualFile);
        }
        StatusBar statusBar = WindowManager.getInstance().getStatusBar(project);
        if (statusBar != null) {
            statusBar.setInfo(IdeBundle.message((String)"action.sync.completed.successfully", (Object[])new Object[]{SynchronizeCurrentFileAction.getMessage(project, files2)}));
        }
    }

    @NotNull
    private static JBIterable<VirtualFile> getFiles(@NotNull AnActionEvent e) {
        return JBIterable.of((Object[])((Object[])e.getData(CommonDataKeys.VIRTUAL_FILE_ARRAY))).filter(o -> o.isInLocalFileSystem());
    }
}

