/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.actions;

import com.intellij.CommonBundle;
import com.intellij.idea.ActionsBundle;
import com.intellij.notification.Notification;
import com.intellij.notification.NotificationType;
import com.intellij.notification.Notifications;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.application.WriteAction;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.io.ReadOnlyAttributeUtil;
import java.io.IOException;
import java.util.stream.Stream;
import org.jetbrains.annotations.NotNull;

public class ToggleReadOnlyAttributeAction
extends AnAction
implements DumbAware {
    public void update(@NotNull AnActionEvent e) {
        VirtualFile[] files2 = ToggleReadOnlyAttributeAction.getFiles(e.getDataContext());
        e.getPresentation().setEnabledAndVisible(files2.length > 0);
        if (files2.length > 0) {
            int ro = 0;
            int rw = 0;
            int f = 0;
            int d = 0;
            for (VirtualFile file2 : files2) {
                if (file2.isWritable()) {
                    ++rw;
                } else {
                    ++ro;
                }
                if (file2.isDirectory()) {
                    ++d;
                    continue;
                }
                ++f;
            }
            if (ro > 0 && rw > 0) {
                e.getPresentation().setText(ActionsBundle.message((String)"action.ToggleReadOnlyAttribute.text", (Object[])new Object[0]));
            } else if (f > 0 && d == 0) {
                e.getPresentation().setText(ActionsBundle.message((String)"action.ToggleReadOnlyAttribute.files", (Object[])new Object[]{ro, rw, f, d}));
            } else if (f == 0 && d > 0) {
                e.getPresentation().setText(ActionsBundle.message((String)"action.ToggleReadOnlyAttribute.dirs", (Object[])new Object[]{ro, rw, f, d}));
            } else {
                e.getPresentation().setText(ActionsBundle.message((String)"action.ToggleReadOnlyAttribute.mixed", (Object[])new Object[]{ro, rw, f, d}));
            }
        }
    }

    public void actionPerformed(@NotNull AnActionEvent e) {
        VirtualFile[] files2 = ToggleReadOnlyAttributeAction.getFiles(e.getDataContext());
        if (files2.length > 0) {
            WriteAction.run(() -> {
                FileDocumentManager.getInstance().saveAllDocuments();
                try {
                    for (VirtualFile file2 : files2) {
                        ReadOnlyAttributeUtil.setReadOnlyAttribute((VirtualFile)file2, (boolean)file2.isWritable());
                    }
                }
                catch (IOException x) {
                    Notifications.Bus.notify((Notification)new Notification("System Messages", CommonBundle.getErrorTitle(), x.getMessage(), NotificationType.ERROR), (Project)e.getProject());
                }
            });
        }
    }

    private static VirtualFile[] getFiles(DataContext context) {
        VirtualFile[] files2 = (VirtualFile[])CommonDataKeys.VIRTUAL_FILE_ARRAY.getData(context);
        return files2 == null ? VirtualFile.EMPTY_ARRAY : (VirtualFile[])Stream.of(files2).filter(VirtualFile::isInLocalFileSystem).toArray(VirtualFile[]::new);
    }
}

