/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.actions;

import com.intellij.icons.AllIcons;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.actionSystem.PlatformDataKeys;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.wm.ToolWindow;
import com.intellij.openapi.wm.ToolWindowAnchor;
import com.intellij.openapi.wm.ToolWindowManager;
import com.intellij.ui.UIBundle;
import java.util.Arrays;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ToolWindowMoveAction
extends DumbAwareAction {
    @NotNull
    private final Anchor myAnchor;

    @Nullable
    protected ToolWindowManager getToolWindowManager(AnActionEvent e) {
        Project project = e.getProject();
        return project == null || project.isDisposed() ? null : ToolWindowManager.getInstance((Project)project);
    }

    @Nullable
    protected ToolWindow getToolWindow(AnActionEvent e) {
        ToolWindowManager manager = this.getToolWindowManager(e);
        if (manager == null) {
            return null;
        }
        ToolWindow window = (ToolWindow)e.getData(PlatformDataKeys.TOOL_WINDOW);
        if (window != null) {
            return window;
        }
        String id = manager.getActiveToolWindowId();
        return id == null ? null : manager.getToolWindow(id);
    }

    public ToolWindowMoveAction(@NotNull Anchor anchor2) {
        super(anchor2.toString(), null, anchor2.getIcon());
        this.myAnchor = anchor2;
    }

    public void actionPerformed(@NotNull AnActionEvent e) {
        ToolWindow toolWindow = this.getToolWindow(e);
        if (toolWindow != null) {
            this.myAnchor.applyTo(toolWindow);
        }
    }

    public void update(@NotNull AnActionEvent e) {
        ToolWindow toolWindow = this.getToolWindow(e);
        e.getPresentation().setEnabled(toolWindow != null && !this.myAnchor.isApplied(toolWindow));
    }

    public static class Group
    extends DefaultActionGroup {
        private boolean isInitialized = false;

        public Group() {
            super(UIBundle.message((String)"tool.window.move.to.action.group.name", (Object[])new Object[0]), true);
        }

        public boolean isDumbAware() {
            return true;
        }

        public void update(@NotNull AnActionEvent e) {
            if (!this.isInitialized) {
                for (Anchor anchor2 : Anchor.values()) {
                    this.add((AnAction)new ToolWindowMoveAction(anchor2));
                }
                this.isInitialized = true;
            }
            super.update(e);
        }
    }

    public static enum Anchor {
        LeftTop,
        LeftBottom,
        BottomLeft,
        BottomRight,
        RightBottom,
        RightTop,
        TopRight,
        TopLeft;


        public String toString() {
            String top = UIBundle.message((String)"tool.window.move.to.top.action.name", (Object[])new Object[0]);
            String left = UIBundle.message((String)"tool.window.move.to.left.action.name", (Object[])new Object[0]);
            String bottom = UIBundle.message((String)"tool.window.move.to.bottom.action.name", (Object[])new Object[0]);
            String right = UIBundle.message((String)"tool.window.move.to.right.action.name", (Object[])new Object[0]);
            switch (this) {
                case LeftTop: {
                    return left + " " + top;
                }
                case LeftBottom: {
                    return left + " " + bottom;
                }
                case BottomLeft: {
                    return bottom + " " + left;
                }
                case BottomRight: {
                    return bottom + " " + right;
                }
                case RightBottom: {
                    return right + " " + bottom;
                }
                case RightTop: {
                    return right + " " + top;
                }
                case TopRight: {
                    return top + " " + right;
                }
                case TopLeft: {
                    return top + " " + left;
                }
            }
            return super.toString();
        }

        @NotNull
        private ToolWindowAnchor getAnchor() {
            switch (this) {
                case LeftTop: 
                case LeftBottom: {
                    return ToolWindowAnchor.LEFT;
                }
                case BottomLeft: 
                case BottomRight: {
                    return ToolWindowAnchor.BOTTOM;
                }
                case RightBottom: 
                case RightTop: {
                    return ToolWindowAnchor.RIGHT;
                }
            }
            return ToolWindowAnchor.TOP;
        }

        private boolean isSplit() {
            return Arrays.asList(LeftBottom, BottomRight, RightBottom, TopRight).contains((Object)this);
        }

        @NotNull
        private Icon getIcon() {
            switch (this) {
                case LeftTop: {
                    return AllIcons.Actions.MoveToLeftTop;
                }
                case LeftBottom: {
                    return AllIcons.Actions.MoveToLeftBottom;
                }
                case BottomLeft: {
                    return AllIcons.Actions.MoveToBottomLeft;
                }
                case BottomRight: {
                    return AllIcons.Actions.MoveToBottomRight;
                }
                case RightBottom: {
                    return AllIcons.Actions.MoveToRightBottom;
                }
                case RightTop: {
                    return AllIcons.Actions.MoveToRightTop;
                }
                case TopRight: {
                    return AllIcons.Actions.MoveToTopRight;
                }
            }
            return AllIcons.Actions.MoveToTopLeft;
        }

        boolean isApplied(@NotNull ToolWindow window) {
            return this.getAnchor() == window.getAnchor() && window.isSplitMode() == this.isSplit();
        }

        void applyTo(@NotNull ToolWindow window) {
            window.setAnchor(this.getAnchor(), null);
            window.setSplitMode(this.isSplit(), null);
        }
    }
}

