/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.actions;

import com.intellij.idea.ActionsBundle;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.actionSystem.PlatformDataKeys;
import com.intellij.openapi.project.DumbAwareToggleAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.wm.ToolWindow;
import com.intellij.openapi.wm.ToolWindowManager;
import com.intellij.openapi.wm.ToolWindowType;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ToolWindowViewModeAction
extends DumbAwareToggleAction {
    @NotNull
    protected final ViewMode myMode;

    protected ToolWindowViewModeAction(@NotNull ViewMode mode) {
        this.myMode = mode;
        this.getTemplatePresentation().setText(this.myMode.toString());
    }

    @Nullable
    protected ToolWindowManager getToolWindowManager(AnActionEvent e) {
        Project project = e.getProject();
        return project == null || project.isDisposed() ? null : ToolWindowManager.getInstance((Project)project);
    }

    @Nullable
    protected ToolWindow getToolWindow(AnActionEvent e) {
        ToolWindowManager manager = this.getToolWindowManager(e);
        if (manager == null) {
            return null;
        }
        ToolWindow window = (ToolWindow)e.getData(PlatformDataKeys.TOOL_WINDOW);
        if (window != null) {
            return window;
        }
        String id = manager.getActiveToolWindowId();
        return id == null ? null : manager.getToolWindow(id);
    }

    public final boolean isSelected(@NotNull AnActionEvent e) {
        Project project = e.getProject();
        if (project == null || project.isDisposed()) {
            return false;
        }
        ToolWindow window = this.getToolWindow(e);
        return window != null && this.isSelected(window);
    }

    protected boolean isSelected(@NotNull ToolWindow window) {
        return this.myMode.isApplied(window);
    }

    public void setSelected(@NotNull AnActionEvent e, boolean state) {
        ToolWindow window = this.getToolWindow(e);
        if (window == null) {
            return;
        }
        if (!this.myMode.isApplied(window)) {
            this.myMode.applyTo(window);
        }
    }

    public void update(@NotNull AnActionEvent e) {
        super.update(e);
        e.getPresentation().setEnabled(this.getToolWindow(e) != null);
    }

    public static class Group
    extends DefaultActionGroup {
        private boolean isInitialized = false;

        public Group() {
            super(ActionsBundle.groupText((String)"ViewMode"), true);
        }

        public boolean isDumbAware() {
            return true;
        }

        public void update(@NotNull AnActionEvent e) {
            if (!this.isInitialized) {
                ActionManager actionManager = ActionManager.getInstance();
                for (ViewMode viewMode : ViewMode.values()) {
                    ToolWindowViewModeAction action = new ToolWindowViewModeAction(viewMode);
                    AnAction template = actionManager.getAction(viewMode.getActionID());
                    if (template != null) {
                        action.copyShortcutFrom(template);
                    }
                    this.add((AnAction)action);
                }
                this.isInitialized = true;
            }
            super.update(e);
        }
    }

    public static enum ViewMode {
        DockPinned("DockPinnedMode"),
        DockUnpinned("DockUnpinnedMode"),
        Undock("UndockMode"),
        Float("FloatMode"),
        Window("WindowMode");

        private final String myActionID;

        private ViewMode(String actionID) {
            this.myActionID = actionID;
        }

        public String getActionID() {
            return this.myActionID;
        }

        boolean isApplied(@NotNull ToolWindow window) {
            ToolWindowType type = window.getType();
            switch (this) {
                case DockPinned: {
                    return type == ToolWindowType.DOCKED && !window.isAutoHide();
                }
                case DockUnpinned: {
                    return type == ToolWindowType.DOCKED && window.isAutoHide();
                }
                case Undock: {
                    return type == ToolWindowType.SLIDING;
                }
                case Float: {
                    return type == ToolWindowType.FLOATING;
                }
                case Window: {
                    return type == ToolWindowType.WINDOWED;
                }
            }
            return false;
        }

        void applyTo(@NotNull ToolWindow window) {
            switch (this) {
                case DockPinned: {
                    window.setType(ToolWindowType.DOCKED, null);
                    window.setAutoHide(false);
                    return;
                }
                case DockUnpinned: {
                    window.setType(ToolWindowType.DOCKED, null);
                    window.setAutoHide(true);
                    return;
                }
                case Undock: {
                    window.setType(ToolWindowType.SLIDING, null);
                    return;
                }
                case Float: {
                    window.setType(ToolWindowType.FLOATING, null);
                    return;
                }
                case Window: {
                    window.setType(ToolWindowType.WINDOWED, null);
                }
            }
        }

        public String toString() {
            switch (this) {
                case DockPinned: {
                    return "Dock Pinned";
                }
                case DockUnpinned: {
                    return "Dock Unpinned";
                }
            }
            return this.name();
        }
    }
}

