/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.actions;

import com.intellij.featureStatistics.FeatureUsageTracker;
import com.intellij.ide.structureView.StructureView;
import com.intellij.ide.structureView.StructureViewBuilder;
import com.intellij.ide.structureView.StructureViewModel;
import com.intellij.ide.structureView.TreeBasedStructureViewBuilder;
import com.intellij.ide.structureView.impl.StructureViewComposite;
import com.intellij.ide.util.FileStructurePopup;
import com.intellij.ide.util.StructureViewCompositeModel;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.PlatformDataKeys;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.ex.util.EditorUtil;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.fileEditor.TextEditor;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.ui.EditorTextField;
import com.intellij.ui.PlaceHolder;
import com.intellij.util.ObjectUtils;
import java.util.Arrays;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ViewStructureAction
extends DumbAwareAction {
    public ViewStructureAction() {
        this.setEnabledInModalContext(true);
    }

    public void actionPerformed(@NotNull AnActionEvent e) {
        Editor editor;
        Project project = (Project)e.getData(CommonDataKeys.PROJECT);
        if (project == null) {
            return;
        }
        FileEditor fileEditor = (FileEditor)e.getData(PlatformDataKeys.FILE_EDITOR);
        if (fileEditor == null) {
            return;
        }
        VirtualFile virtualFile = fileEditor.getFile();
        Editor editor2 = editor = fileEditor instanceof TextEditor ? ((TextEditor)fileEditor).getEditor() : (Editor)e.getData(CommonDataKeys.EDITOR);
        if (editor != null) {
            PsiDocumentManager.getInstance((Project)project).commitDocument(editor.getDocument());
        }
        FeatureUsageTracker.getInstance().triggerFeatureUsed("navigation.popup.file.structure");
        FileStructurePopup popup2 = ViewStructureAction.createPopup(project, fileEditor);
        if (popup2 == null) {
            return;
        }
        String title = virtualFile == null ? fileEditor.getName() : virtualFile.getName();
        popup2.setTitle(title);
        popup2.show();
    }

    @Nullable
    public static FileStructurePopup createPopup(@NotNull Project project, @NotNull FileEditor fileEditor) {
        StructureViewModel treeModel;
        StructureView structureView;
        PsiDocumentManager.getInstance((Project)project).commitAllDocuments();
        StructureViewBuilder builder2 = fileEditor.getStructureViewBuilder();
        if (builder2 == null) {
            return null;
        }
        if (builder2 instanceof TreeBasedStructureViewBuilder) {
            structureView = null;
            treeModel = ((TreeBasedStructureViewBuilder)builder2).createStructureViewModel((Editor)EditorUtil.getEditorEx(fileEditor));
        } else {
            structureView = builder2.createStructureView(fileEditor, project);
            treeModel = ViewStructureAction.createStructureViewModel(project, fileEditor, structureView);
        }
        if (treeModel instanceof PlaceHolder) {
            ((PlaceHolder)treeModel).setPlace((Object)"StructureViewPopup");
        }
        FileStructurePopup popup2 = new FileStructurePopup(project, fileEditor, treeModel);
        if (structureView != null) {
            Disposer.register((Disposable)popup2, (Disposable)structureView);
        }
        return popup2;
    }

    public void update(@NotNull AnActionEvent e) {
        Project project = (Project)e.getData(CommonDataKeys.PROJECT);
        if (project == null) {
            e.getPresentation().setEnabled(false);
            return;
        }
        FileEditor fileEditor = (FileEditor)e.getData(PlatformDataKeys.FILE_EDITOR);
        Editor editor = fileEditor instanceof TextEditor ? ((TextEditor)fileEditor).getEditor() : (Editor)e.getData(CommonDataKeys.EDITOR);
        boolean enabled = fileEditor != null && !Boolean.TRUE.equals(EditorTextField.SUPPLEMENTARY_KEY.get((UserDataHolder)editor)) && fileEditor.getStructureViewBuilder() != null;
        e.getPresentation().setEnabled(enabled);
    }

    @NotNull
    public static StructureViewModel createStructureViewModel(@NotNull Project project, @NotNull FileEditor fileEditor, @NotNull StructureView structureView) {
        Object treeModel;
        VirtualFile virtualFile = fileEditor.getFile();
        if (structureView instanceof StructureViewComposite && virtualFile != null) {
            StructureViewComposite.StructureViewDescriptor[] views = ((StructureViewComposite)structureView).getStructureViews();
            PsiFile psiFile = (PsiFile)ObjectUtils.notNull((Object)PsiManager.getInstance((Project)project).findFile(virtualFile));
            treeModel = new StructureViewCompositeModel(psiFile, EditorUtil.getEditorEx(fileEditor), Arrays.asList(views));
            Disposer.register((Disposable)structureView, (Disposable)treeModel);
        } else {
            treeModel = structureView.getTreeModel();
        }
        return treeModel;
    }
}

