/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.actions;

import com.intellij.ide.actions.ExcludingActionGroup;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.actionSystem.Separator;
import com.intellij.openapi.actionSystem.impl.PresentationFactory;
import com.intellij.openapi.actionSystem.impl.Utils;
import java.util.LinkedHashSet;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

abstract class WeighingActionGroup
extends ActionGroup {
    private final PresentationFactory myPresentationFactory = new PresentationFactory();

    WeighingActionGroup() {
    }

    public void update(@NotNull AnActionEvent e) {
        this.getDelegate().update(e);
    }

    protected abstract ActionGroup getDelegate();

    @NotNull
    public AnAction[] getChildren(@Nullable AnActionEvent e) {
        ActionGroup delegate = this.getDelegate();
        AnAction[] children2 = delegate.getChildren(e);
        if (e == null) {
            return children2;
        }
        List<AnAction> visibleActions = Utils.expandActionGroup(false, delegate, this.myPresentationFactory, e.getDataContext(), e.getPlace());
        LinkedHashSet<AnAction> heaviest = null;
        double maxWeight = 0.0;
        for (AnAction action : visibleActions) {
            Presentation presentation = this.myPresentationFactory.getPresentation(action);
            if (!presentation.isEnabled() || !presentation.isVisible()) continue;
            if (presentation.getWeight() > maxWeight) {
                maxWeight = presentation.getWeight();
                heaviest = new LinkedHashSet<AnAction>();
            }
            if (presentation.getWeight() != maxWeight || heaviest == null) continue;
            heaviest.add(action);
        }
        if (heaviest == null) {
            return children2;
        }
        DefaultActionGroup chosen = new DefaultActionGroup();
        boolean prevSeparator = true;
        for (AnAction action : visibleActions) {
            boolean separator = action instanceof Separator;
            if (separator && !prevSeparator) {
                chosen.add(action);
            }
            prevSeparator = separator;
            if (this.shouldBeChosenAnyway(action)) {
                heaviest.add(action);
            }
            if (!heaviest.contains(action)) continue;
            chosen.add(action);
        }
        ExcludingActionGroup other = new ExcludingActionGroup(delegate, heaviest);
        other.setPopup(true);
        other.getTemplatePresentation().setText("Other...");
        return new AnAction[]{chosen, new Separator(), other};
    }

    protected boolean shouldBeChosenAnyway(AnAction action) {
        return false;
    }
}

