/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.actions.project;

import com.intellij.CommonBundle;
import com.intellij.ide.actions.project.ConvertModuleGroupsToQualifiedNamesDialog;
import com.intellij.ide.actions.project.LoadModuleRenamingSchemeAction;
import com.intellij.ide.util.PropertiesComponent;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileChooser.FileChooserFactory;
import com.intellij.openapi.fileChooser.FileSaverDescriptor;
import com.intellij.openapi.module.impl.ModuleRenamingHistoryState;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectBundle;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileWrapper;
import com.intellij.util.JdomKt;
import com.intellij.util.xmlb.XmlSerializer;
import java.nio.file.Path;
import kotlin.Metadata;
import org.jdom.Parent;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=2, d1={"\u0000.\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\u001a\u0012\u0010\u0004\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0002\u001a\u001a\u0010\b\u001a\u00020\t2\u0006\u0010\u0006\u001a\u00020\u00072\b\u0010\n\u001a\u0004\u0018\u00010\u0001H\u0002\u001a\u0010\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0000\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"EXPORTED_PATH_PROPERTY", "", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "getDefaultRenamingSchemeFile", "Lcom/intellij/openapi/vfs/VirtualFile;", "project", "Lcom/intellij/openapi/project/Project;", "saveDefaultRenamingSchemeFilePath", "", "filePath", "saveModuleRenamingScheme", "", "dialog", "Lcom/intellij/ide/actions/project/ConvertModuleGroupsToQualifiedNamesDialog;", "intellij.platform.ide.impl"})
public final class LoadSaveModuleRenameMappingKt {
    private static final Logger LOG = Logger.getInstance(LoadModuleRenamingSchemeAction.class);
    private static final String EXPORTED_PATH_PROPERTY = "module.renaming.scheme.file";

    public static final boolean saveModuleRenamingScheme(@NotNull ConvertModuleGroupsToQualifiedNamesDialog dialog2) {
        Project project = dialog2.getProject();
        FileSaverDescriptor descriptor = new FileSaverDescriptor(ProjectBundle.message((String)"module.renaming.scheme.save.chooser.title", (Object[])new Object[0]), ProjectBundle.message((String)"module.renaming.scheme.save.chooser.description", (Object[])new Object[0]), new String[]{"xml"});
        VirtualFile virtualFile = LoadSaveModuleRenameMappingKt.getDefaultRenamingSchemeFile(project);
        if (virtualFile == null || (virtualFile = virtualFile.getParent()) == null) {
            virtualFile = project.getBaseDir();
        }
        VirtualFile baseDir = virtualFile;
        VirtualFileWrapper fileWrapper = FileChooserFactory.getInstance().createSaveFileDialog(descriptor, project).save(baseDir, "module-renaming-scheme.xml");
        if (fileWrapper != null) {
            LoadSaveModuleRenameMappingKt.saveDefaultRenamingSchemeFilePath(project, FileUtil.toSystemIndependentName((String)fileWrapper.getFile().getAbsolutePath()));
            ModuleRenamingHistoryState state = new ModuleRenamingHistoryState();
            state.oldToNewName.putAll(dialog2.getRenamingScheme());
            try {
                JdomKt.write$default((Parent)((Parent)XmlSerializer.serialize((Object)state)), (Path)fileWrapper.getFile().toPath(), null, (int)2, null);
                VirtualFile virtualFile2 = fileWrapper.getVirtualFile();
                if (virtualFile2 != null) {
                    virtualFile2.refresh(true, false);
                }
                return true;
            }
            catch (Exception e) {
                LOG.info((Throwable)e);
                String string = CommonBundle.getErrorTitle();
                Object[] objectArray = new Object[1];
                String string2 = e.getMessage();
                if (string2 == null) {
                    string2 = "";
                }
                objectArray[0] = string2;
                Messages.showErrorDialog((Project)project, (String)string, (String)ProjectBundle.message((String)"module.renaming.scheme.cannot.save.error", (Object[])objectArray));
            }
        }
        return false;
    }

    private static final void saveDefaultRenamingSchemeFilePath(Project project, String filePath) {
        PropertiesComponent.getInstance((Project)project).setValue(EXPORTED_PATH_PROPERTY, filePath);
    }

    private static final VirtualFile getDefaultRenamingSchemeFile(Project project) {
        VirtualFile virtualFile;
        String string = PropertiesComponent.getInstance((Project)project).getValue(EXPORTED_PATH_PROPERTY);
        if (string != null) {
            String string2;
            String it = string2 = string;
            boolean bl = false;
            virtualFile = LocalFileSystem.getInstance().refreshAndFindFileByPath(it);
        } else {
            virtualFile = null;
        }
        return virtualFile;
    }

    public static final /* synthetic */ VirtualFile access$getDefaultRenamingSchemeFile(Project project) {
        return LoadSaveModuleRenameMappingKt.getDefaultRenamingSchemeFile(project);
    }

    public static final /* synthetic */ Logger access$getLOG$p() {
        return LOG;
    }
}

