/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.actions.runAnything;

import com.intellij.ui.components.fields.ExtendableTextComponent;
import com.intellij.util.Consumer;
import com.intellij.util.ui.UIUtil;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.Icon;
import javax.swing.text.JTextComponent;
import org.jetbrains.annotations.NotNull;

class RunAnythingIconHandler
implements PropertyChangeListener {
    private static final String FOREGROUND_PROPERTY = "foreground";
    protected static final String MATCHED_PROVIDER_PROPERTY = "JTextField.match";
    private final Consumer<? super ExtendableTextComponent.Extension> myConsumer;
    private final JTextComponent myComponent;

    RunAnythingIconHandler(@NotNull Consumer<? super ExtendableTextComponent.Extension> consumer, @NotNull JTextComponent component) {
        this.myConsumer = consumer;
        this.myComponent = component;
        this.setConfigurationIcon(component.getClientProperty(MATCHED_PROVIDER_PROPERTY));
    }

    @Override
    public void propertyChange(PropertyChangeEvent event) {
        if (this.myComponent == null) {
            return;
        }
        if (MATCHED_PROVIDER_PROPERTY.equals(event.getPropertyName())) {
            this.setConfigurationIcon(event.getNewValue());
        } else if (FOREGROUND_PROPERTY.equals(event.getPropertyName())) {
            this.myComponent.setForeground(UIUtil.getTextFieldForeground());
        }
        this.myComponent.repaint();
    }

    private void setConfigurationIcon(Object variant) {
        if (!(variant instanceof Icon)) {
            return;
        }
        this.myConsumer.consume((Object)new RunConfigurationTypeExtension((Icon)variant));
    }

    private static class RunConfigurationTypeExtension
    implements ExtendableTextComponent.Extension {
        private final Icon myVariant;

        RunConfigurationTypeExtension(Icon variant) {
            this.myVariant = variant;
        }

        public Icon getIcon(boolean hovered) {
            return this.myVariant;
        }

        public boolean isIconBeforeText() {
            return true;
        }

        public String toString() {
            return RunAnythingIconHandler.MATCHED_PROVIDER_PROPERTY;
        }
    }
}

