/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.actions.runAnything;

import com.intellij.execution.Executor;
import com.intellij.execution.ExecutorRegistry;
import com.intellij.execution.executors.DefaultRunExecutor;
import com.intellij.featureStatistics.FeatureUsageTracker;
import com.intellij.icons.AllIcons;
import com.intellij.ide.IdeBundle;
import com.intellij.ide.actions.BigPopupUI;
import com.intellij.ide.actions.bigPopup.ShowFilterAction;
import com.intellij.ide.actions.runAnything.RunAnythingAction;
import com.intellij.ide.actions.runAnything.RunAnythingCache;
import com.intellij.ide.actions.runAnything.RunAnythingIconHandler;
import com.intellij.ide.actions.runAnything.RunAnythingMore;
import com.intellij.ide.actions.runAnything.RunAnythingMyAccessibleComponent;
import com.intellij.ide.actions.runAnything.RunAnythingSearchListModel;
import com.intellij.ide.actions.runAnything.RunAnythingUsageCollector;
import com.intellij.ide.actions.runAnything.RunAnythingUtil;
import com.intellij.ide.actions.runAnything.activity.RunAnythingProvider;
import com.intellij.ide.actions.runAnything.groups.RunAnythingCompletionGroup;
import com.intellij.ide.actions.runAnything.groups.RunAnythingGeneralGroup;
import com.intellij.ide.actions.runAnything.groups.RunAnythingGroup;
import com.intellij.ide.actions.runAnything.groups.RunAnythingRecentGroup;
import com.intellij.ide.actions.runAnything.items.RunAnythingItem;
import com.intellij.ide.actions.runAnything.ui.RunAnythingScrollingUtil;
import com.intellij.ide.ui.UISettings;
import com.intellij.ide.util.ElementsChooser;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.ActionToolbar;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.CommonShortcuts;
import com.intellij.openapi.actionSystem.CustomShortcutSet;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.DataKey;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.actionSystem.LangDataKeys;
import com.intellij.openapi.actionSystem.ShortcutSet;
import com.intellij.openapi.actionSystem.impl.ActionToolbarImpl;
import com.intellij.openapi.actionSystem.impl.SimpleDataContext;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.keymap.KeymapUtil;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.util.ProgressIndicatorBase;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.util.ActionCallback;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.wm.IdeFocusManager;
import com.intellij.openapi.wm.ToolWindowId;
import com.intellij.ui.ColoredListCellRenderer;
import com.intellij.ui.DocumentAdapter;
import com.intellij.ui.Gray;
import com.intellij.ui.JBColor;
import com.intellij.ui.ScrollingUtil;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.ui.components.JBList;
import com.intellij.ui.components.JBTextField;
import com.intellij.ui.components.fields.ExtendableTextComponent;
import com.intellij.ui.components.fields.ExtendableTextField;
import com.intellij.ui.components.panels.NonOpaquePanel;
import com.intellij.util.Alarm;
import com.intellij.util.ArrayUtil;
import com.intellij.util.BooleanFunction;
import com.intellij.util.Consumer;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.StatusText;
import com.intellij.util.ui.UIUtil;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.EventQueue;
import java.awt.LayoutManager;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.beans.PropertyChangeListener;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import javax.accessibility.Accessible;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.ListCellRenderer;
import javax.swing.ListModel;
import javax.swing.border.Border;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.text.JTextComponent;
import one.util.streamex.StreamEx;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class RunAnythingPopupUI
extends BigPopupUI {
    public static final int SEARCH_FIELD_COLUMNS = 25;
    public static final Icon UNKNOWN_CONFIGURATION_ICON = AllIcons.Actions.Run_anything;
    public static final DataKey<Executor> EXECUTOR_KEY = DataKey.create((String)"EXECUTOR_KEY");
    static final String RUN_ANYTHING = "RunAnything";
    public static final KeyStroke DOWN_KEYSTROKE = KeyStroke.getKeyStroke(40, 0);
    public static final KeyStroke UP_KEYSTROKE = KeyStroke.getKeyStroke(38, 0);
    private static final Logger LOG = Logger.getInstance(RunAnythingPopupUI.class);
    private static final Border RENDERER_BORDER = JBUI.Borders.empty((int)1, (int)0);
    private static final String HELP_PLACEHOLDER = "?";
    private static final int LIST_REBUILD_DELAY = 200;
    private final Alarm myAlarm = new Alarm(Alarm.ThreadToUse.SWING_THREAD, (Disposable)ApplicationManager.getApplication());
    private final AnActionEvent myActionEvent;
    private boolean myIsUsedTrigger;
    private CalcThread myCalcThread;
    private volatile ActionCallback myCurrentWorker;
    private int myCalcThreadRestartRequestId = 0;
    private final Object myWorkerRestartRequestLock = new Object();
    private boolean mySkipFocusGain = false;
    private Editor myEditor;
    @Nullable
    private VirtualFile myVirtualFile;
    @NotNull
    private final DataContext myDataContext;
    private JLabel myTextFieldTitle;
    private boolean myIsItemSelected;
    private String myLastInputText = null;
    private RunAnythingSearchListModel.RunAnythingMainListModel myListModel;
    private Project myProject;
    private Module myModule;

    private void onMouseClicked(@NotNull MouseEvent event) {
        int clickCount = event.getClickCount();
        if (clickCount > 1 && clickCount % 2 == 0) {
            event.consume();
            int i = this.myResultsList.locationToIndex(event.getPoint());
            if (i != -1) {
                IdeFocusManager.getGlobalInstance().doWhenFocusSettlesDown(() -> IdeFocusManager.getGlobalInstance().requestFocus((Component)this.getField(), true));
                ApplicationManager.getApplication().invokeLater(() -> {
                    this.myResultsList.setSelectedIndex(i);
                    this.executeCommand();
                });
            }
        }
    }

    private void initSearchField() {
        this.mySearchField.getDocument().addDocumentListener((DocumentListener)new DocumentAdapter(){

            protected void textChanged(@NotNull DocumentEvent e) {
                RunAnythingPopupUI.this.myIsUsedTrigger = true;
                String pattern = RunAnythingPopupUI.this.mySearchField.getText();
                if (RunAnythingPopupUI.this.mySearchField.hasFocus()) {
                    ApplicationManager.getApplication().invokeLater(() -> RunAnythingPopupUI.this.myIsItemSelected = false);
                    if (!RunAnythingPopupUI.this.myIsItemSelected) {
                        RunAnythingPopupUI.this.myLastInputText = null;
                        RunAnythingPopupUI.this.clearSelection();
                        RunAnythingPopupUI.this.rebuildList();
                    }
                    if (!RunAnythingPopupUI.isHelpMode(pattern)) {
                        RunAnythingPopupUI.adjustMainListEmptyText(RunAnythingPopupUI.this.mySearchField);
                        return;
                    }
                    RunAnythingPopupUI.adjustEmptyText(RunAnythingPopupUI.this.mySearchField, (BooleanFunction<JBTextField>)((BooleanFunction)field -> true), "", IdeBundle.message((String)"run.anything.help.list.empty.secondary.text", (Object[])new Object[0]));
                }
            }
        });
        this.mySearchField.addFocusListener((FocusListener)new FocusAdapter(){

            @Override
            public void focusGained(FocusEvent e) {
                if (RunAnythingPopupUI.this.mySkipFocusGain) {
                    RunAnythingPopupUI.this.mySkipFocusGain = false;
                    return;
                }
                String text = RunAnythingUtil.getInitialTextForNavigation(RunAnythingPopupUI.this.myEditor);
                text = text != null ? text.trim() : "";
                RunAnythingPopupUI.this.mySearchField.setText(text);
                RunAnythingPopupUI.this.mySearchField.setForeground(UIUtil.getLabelForeground());
                RunAnythingPopupUI.this.mySearchField.selectAll();
                RunAnythingPopupUI.this.mySearchField.setColumns(25);
                ApplicationManager.getApplication().invokeLater(() -> {
                    JComponent parent = (JComponent)RunAnythingPopupUI.this.mySearchField.getParent();
                    parent.revalidate();
                    parent.repaint();
                });
                RunAnythingPopupUI.this.rebuildList();
            }

            @Override
            public void focusLost(FocusEvent e) {
                ActionCallback result2 = new ActionCallback();
                UIUtil.invokeLaterIfNeeded(() -> {
                    try {
                        if (RunAnythingPopupUI.this.myCalcThread != null) {
                            RunAnythingPopupUI.this.myCalcThread.cancel();
                        }
                        RunAnythingPopupUI.this.myAlarm.cancelAllRequests();
                        ApplicationManager.getApplication().invokeLater(() -> ActionToolbarImpl.updateAllToolbarsImmediately());
                        RunAnythingPopupUI.this.searchFinishedHandler.run();
                    }
                    finally {
                        result2.setDone();
                    }
                });
            }
        });
    }

    private static void adjustMainListEmptyText(@NotNull JBTextField editor) {
        RunAnythingPopupUI.adjustEmptyText(editor, (BooleanFunction<JBTextField>)((BooleanFunction)field -> field.getText().isEmpty()), IdeBundle.message((String)"run.anything.main.list.empty.primary.text", (Object[])new Object[0]), IdeBundle.message((String)"run.anything.main.list.empty.secondary.text", (Object[])new Object[0]));
    }

    private static boolean isHelpMode(@NotNull String pattern) {
        return pattern.startsWith(HELP_PLACEHOLDER);
    }

    private void clearSelection() {
        this.myResultsList.getSelectionModel().clearSelection();
    }

    private JTextField getField() {
        return this.mySearchField;
    }

    private void executeCommand() {
        RunAnythingGroup group;
        String pattern = this.getField().getText();
        int index = this.myResultsList.getSelectedIndex();
        if (pattern.isEmpty() && index == -1) {
            return;
        }
        Project project = this.getProject();
        RunAnythingSearchListModel model = RunAnythingPopupUI.getSearchingModel(this.myResultsList);
        if (index != -1 && model != null && this.isMoreItem(index) && (group = model.findGroupByMoreIndex(index)) != null) {
            this.myCurrentWorker.doWhenProcessed(() -> {
                this.myCalcThread = new CalcThread(project, pattern, true);
                RunAnythingUsageCollector.Companion.triggerMoreStatistics(project, group, model.getClass());
                this.myCurrentWorker = this.myCalcThread.insert(index, group);
            });
            return;
        }
        if (model != null) {
            RunAnythingUsageCollector.Companion.triggerExecCategoryStatistics(project, model.getGroups(), model.getClass(), index);
        }
        DataContext dataContext = this.createDataContext(this.myDataContext, RunAnythingAction.ALT_IS_PRESSED.get());
        if (RunAnythingAction.SHIFT_IS_PRESSED.get()) {
            RunAnythingUtil.triggerShiftStatistics(dataContext);
        }
        RunAnythingUtil.executeMatched(dataContext, pattern);
        this.searchFinishedHandler.run();
        this.triggerUsed();
    }

    @NotNull
    private DataContext createDataContext(@NotNull DataContext parentDataContext, boolean isAltPressed) {
        HashMap map2 = ContainerUtil.newHashMap();
        map2.put(CommonDataKeys.VIRTUAL_FILE.getName(), this.getWorkDirectory(this.getModule(), isAltPressed));
        map2.put(EXECUTOR_KEY.getName(), RunAnythingPopupUI.getExecutor());
        return SimpleDataContext.getSimpleContext(map2, parentDataContext);
    }

    @NotNull
    private Project getProject() {
        return this.myProject;
    }

    @Nullable
    private Module getModule() {
        Module moduleForFile;
        Module moduleForFile2;
        if (this.myModule != null) {
            return this.myModule;
        }
        Project project = this.getProject();
        if (this.myVirtualFile != null && (moduleForFile2 = ModuleUtilCore.findModuleForFile((VirtualFile)this.myVirtualFile, (Project)project)) != null) {
            return moduleForFile2;
        }
        VirtualFile[] selectedFiles = FileEditorManager.getInstance((Project)project).getSelectedFiles();
        if (selectedFiles.length != 0 && (moduleForFile = ModuleUtilCore.findModuleForFile((VirtualFile)selectedFiles[0], (Project)project)) != null) {
            return moduleForFile;
        }
        return null;
    }

    @NotNull
    private VirtualFile getWorkDirectory(@Nullable Module module, boolean isAltPressed) {
        if (isAltPressed) {
            VirtualFile file2;
            VirtualFile[] selectedFiles;
            if (this.myVirtualFile != null) {
                VirtualFile file3;
                VirtualFile virtualFile = file3 = this.myVirtualFile.isDirectory() ? this.myVirtualFile : this.myVirtualFile.getParent();
                if (file3 != null) {
                    return file3;
                }
            }
            if ((selectedFiles = FileEditorManager.getInstance((Project)this.getProject()).getSelectedFiles()).length > 0 && (file2 = selectedFiles[0].getParent()) != null) {
                return file2;
            }
        }
        return this.getBaseDirectory(module);
    }

    @NotNull
    private VirtualFile getBaseDirectory(@Nullable Module module) {
        VirtualFile projectBaseDir = this.getProject().getBaseDir();
        if (module == null) {
            return projectBaseDir;
        }
        VirtualFile firstContentRoot = this.getFirstContentRoot(module);
        if (firstContentRoot == null) {
            return projectBaseDir;
        }
        return firstContentRoot;
    }

    @Nullable
    public VirtualFile getFirstContentRoot(@NotNull Module module) {
        if (module.isDisposed()) {
            return null;
        }
        return (VirtualFile)ArrayUtil.getFirstElement((Object[])ModuleRootManager.getInstance((Module)module).getContentRoots());
    }

    private boolean isMoreItem(int index) {
        RunAnythingSearchListModel model = RunAnythingPopupUI.getSearchingModel(this.myResultsList);
        return model != null && model.isMoreIndex(index);
    }

    @Nullable
    public static RunAnythingSearchListModel getSearchingModel(@NotNull JBList list2) {
        ListModel model = list2.getModel();
        return model instanceof RunAnythingSearchListModel ? (RunAnythingSearchListModel)model : null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void rebuildList() {
        String pattern = this.getSearchPattern();
        assert (EventQueue.isDispatchThread()) : "Must be EDT";
        if (this.myCalcThread != null && !this.myCurrentWorker.isProcessed()) {
            this.myCurrentWorker = this.myCalcThread.cancel();
        }
        if (this.myCalcThread != null && !this.myCalcThread.isCanceled()) {
            this.myCalcThread.cancel();
        }
        Object object = this.myWorkerRestartRequestLock;
        synchronized (object) {
            int currentRestartRequest = ++this.myCalcThreadRestartRequestId;
            this.myCurrentWorker.doWhenProcessed(() -> {
                Object object = this.myWorkerRestartRequestLock;
                synchronized (object) {
                    if (currentRestartRequest != this.myCalcThreadRestartRequestId) {
                        return;
                    }
                    this.myCalcThread = new CalcThread(this.getProject(), pattern, false);
                    this.myCurrentWorker = this.myCalcThread.start();
                }
            });
        }
    }

    public void initResultsList() {
        this.myResultsList.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                RunAnythingPopupUI.this.updateAdText(RunAnythingPopupUI.this.myDataContext);
                Object selectedValue = RunAnythingPopupUI.this.myResultsList.getSelectedValue();
                if (selectedValue == null) {
                    return;
                }
                String lastInput = RunAnythingPopupUI.this.mySearchField.getText();
                RunAnythingPopupUI.this.myIsItemSelected = true;
                if (RunAnythingPopupUI.this.isMoreItem(RunAnythingPopupUI.this.myResultsList.getSelectedIndex())) {
                    if (RunAnythingPopupUI.this.myLastInputText != null) {
                        RunAnythingPopupUI.this.mySearchField.setText(RunAnythingPopupUI.this.myLastInputText);
                    }
                    return;
                }
                RunAnythingPopupUI.this.mySearchField.setText(selectedValue instanceof RunAnythingItem ? ((RunAnythingItem)selectedValue).getCommand() : RunAnythingPopupUI.this.myLastInputText);
                if (RunAnythingPopupUI.this.myLastInputText == null) {
                    RunAnythingPopupUI.this.myLastInputText = lastInput;
                }
            }
        });
    }

    @Override
    @NotNull
    public JPanel createTopLeftPanel() {
        this.myTextFieldTitle = new JLabel(IdeBundle.message((String)"run.anything.run.anything.title", (Object[])new Object[0]));
        NonOpaquePanel topPanel = new NonOpaquePanel((LayoutManager)new BorderLayout());
        Color foregroundColor = UIUtil.isUnderDarcula() ? (UIUtil.isUnderWin10LookAndFeel() ? JBColor.WHITE : new JBColor((Color)Gray._240, (Color)Gray._200)) : UIUtil.getLabelForeground();
        this.myTextFieldTitle.setForeground(foregroundColor);
        this.myTextFieldTitle.setBorder(BorderFactory.createEmptyBorder(3, 5, 5, 0));
        if (SystemInfo.isMac) {
            this.myTextFieldTitle.setFont(this.myTextFieldTitle.getFont().deriveFont(1, (float)this.myTextFieldTitle.getFont().getSize() - 1.0f));
        } else {
            this.myTextFieldTitle.setFont(this.myTextFieldTitle.getFont().deriveFont(1));
        }
        topPanel.add(this.myTextFieldTitle);
        return topPanel;
    }

    @NotNull
    public DataContext createDataContext(@NotNull AnActionEvent e) {
        HashMap dataMap = ContainerUtil.newHashMap();
        dataMap.put(CommonDataKeys.PROJECT.getName(), e.getProject());
        dataMap.put(LangDataKeys.MODULE.getName(), this.getModule());
        return this.createDataContext(SimpleDataContext.getSimpleContext(dataMap, e.getDataContext()), RunAnythingAction.ALT_IS_PRESSED.get());
    }

    public void initMySearchField() {
        this.mySearchField.putClientProperty((Object)"JTextField.match", (Object)UNKNOWN_CONFIGURATION_ICON);
        this.setHandleMatchedConfiguration();
        RunAnythingPopupUI.adjustMainListEmptyText(this.mySearchField);
        this.mySearchField.addKeyListener((KeyListener)new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                this.updateByModifierKeysEvent(e);
            }

            @Override
            public void keyReleased(KeyEvent e) {
                this.updateByModifierKeysEvent(e);
            }

            private void updateByModifierKeysEvent(@NotNull KeyEvent e) {
                String message = e.isShiftDown() && e.isAltDown() ? IdeBundle.message((String)"run.anything.run.in.context.debug.title", (Object[])new Object[0]) : (e.isShiftDown() ? IdeBundle.message((String)"run.anything.run.debug.title", (Object[])new Object[0]) : (e.isAltDown() ? IdeBundle.message((String)"run.anything.run.in.context.title", (Object[])new Object[0]) : IdeBundle.message((String)"run.anything.run.anything.title", (Object[])new Object[0])));
                RunAnythingPopupUI.this.myTextFieldTitle.setText(message);
                RunAnythingPopupUI.this.updateMatchedRunConfigurationStuff(e.isAltDown());
            }
        });
        this.initSearchField();
        this.mySearchField.setColumns(25);
    }

    public static void adjustEmptyText(@NotNull JBTextField textEditor, @NotNull BooleanFunction<JBTextField> function, @NotNull String leftText, @NotNull String rightText) {
        textEditor.putClientProperty((Object)"StatusVisibleFunction", function);
        StatusText statusText = textEditor.getEmptyText();
        statusText.setIsVerticalFlow(false);
        statusText.setShowAboveCenter(false);
        statusText.setText(leftText, SimpleTextAttributes.GRAY_ATTRIBUTES);
        statusText.appendSecondaryText(rightText, SimpleTextAttributes.GRAY_ATTRIBUTES, null);
        statusText.setFont(UIUtil.getLabelFont((UIUtil.FontSize)UIUtil.FontSize.SMALL));
    }

    private void setHandleMatchedConfiguration() {
        this.mySearchField.getDocument().addDocumentListener((DocumentListener)new DocumentAdapter(){

            protected void textChanged(@NotNull DocumentEvent e) {
                RunAnythingPopupUI.this.updateMatchedRunConfigurationStuff(RunAnythingAction.ALT_IS_PRESSED.get());
            }
        });
    }

    private void updateMatchedRunConfigurationStuff(boolean isAltPressed) {
        JBTextField textField2 = this.mySearchField;
        String pattern = textField2.getText();
        DataContext dataContext = this.createDataContext(this.myDataContext, isAltPressed);
        RunAnythingProvider provider = RunAnythingProvider.findMatchedProvider(dataContext, pattern);
        if (provider == null) {
            return;
        }
        Object value = provider.findMatchingValue(dataContext, pattern);
        if (value == null) {
            return;
        }
        Icon icon = provider.getIcon(value);
        if (icon == null) {
            return;
        }
        textField2.putClientProperty((Object)"JTextField.match", (Object)icon);
    }

    private void updateAdText(@NotNull DataContext dataContext) {
        String adText;
        RunAnythingProvider provider;
        Object value = this.myResultsList.getSelectedValue();
        if (value instanceof RunAnythingItem && (provider = RunAnythingProvider.findMatchedProvider(dataContext, ((RunAnythingItem)value).getCommand())) != null && (adText = provider.getAdText()) != null) {
            this.setAdText(adText);
        }
    }

    private void triggerUsed() {
        if (this.myIsUsedTrigger) {
            FeatureUsageTracker.getInstance().triggerFeatureUsed(RUN_ANYTHING);
        }
        this.myIsUsedTrigger = false;
    }

    public void setAdText(@NotNull String s) {
        this.myHintLabel.setText(s);
    }

    @NotNull
    public static Executor getExecutor() {
        Executor runExecutor = DefaultRunExecutor.getRunExecutorInstance();
        Executor debugExecutor = ExecutorRegistry.getInstance().getExecutorById(ToolWindowId.DEBUG);
        return !RunAnythingAction.SHIFT_IS_PRESSED.get() ? runExecutor : debugExecutor;
    }

    @Override
    public void installScrollingActions() {
        RunAnythingScrollingUtil.installActions((JList)this.myResultsList, this.getField(), () -> {
            this.myIsItemSelected = true;
            this.mySearchField.setText(this.myLastInputText);
            this.clearSelection();
        }, UISettings.getInstance().getCycleScrolling());
        super.installScrollingActions();
    }

    protected void resetFields() {
        this.myCurrentWorker.doWhenProcessed(() -> {
            CalcThread lock = this.myCalcThread;
            if (lock != null) {
                CalcThread calcThread = lock;
                synchronized (calcThread) {
                    this.myCurrentWorker = ActionCallback.DONE;
                    this.myCalcThread = null;
                    this.myEditor = null;
                    this.myVirtualFile = null;
                    this.myProject = null;
                    this.myModule = null;
                }
            }
        });
        this.mySkipFocusGain = false;
    }

    public RunAnythingPopupUI(@NotNull AnActionEvent actionEvent) {
        super(actionEvent.getProject());
        this.myActionEvent = actionEvent;
        this.myCurrentWorker = ActionCallback.DONE;
        this.myEditor = (Editor)actionEvent.getData(CommonDataKeys.EDITOR);
        this.myVirtualFile = (VirtualFile)actionEvent.getData(CommonDataKeys.VIRTUAL_FILE);
        this.myProject = (Project)ObjectUtils.notNull((Object)CommonDataKeys.PROJECT.getData(this.myActionEvent.getDataContext()));
        this.myDataContext = this.createDataContext(actionEvent);
        this.myModule = (Module)this.myActionEvent.getData(LangDataKeys.MODULE);
        this.init();
        this.initSearchActions();
        this.initResultsList();
        this.initSearchField();
        this.initMySearchField();
    }

    @Override
    @NotNull
    public JBList<Object> createList() {
        this.myListModel = new RunAnythingSearchListModel.RunAnythingMainListModel();
        this.addListDataListener(this.myListModel);
        return new JBList((ListModel)this.myListModel);
    }

    private void initSearchActions() {
        this.myResultsList.addMouseListener((MouseListener)new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                RunAnythingPopupUI.this.onMouseClicked(e);
            }
        });
        DumbAwareAction.create(e -> RunAnythingUtil.jumpNextGroup(true, this.myResultsList)).registerCustomShortcutSet((ShortcutSet)CustomShortcutSet.fromString((String[])new String[]{"TAB"}), (JComponent)this.mySearchField, (Disposable)this);
        DumbAwareAction.create(e -> RunAnythingUtil.jumpNextGroup(false, this.myResultsList)).registerCustomShortcutSet((ShortcutSet)CustomShortcutSet.fromString((String[])new String[]{"shift TAB"}), (JComponent)this.mySearchField, (Disposable)this);
        AnAction escape = ActionManager.getInstance().getAction("EditorEscape");
        DumbAwareAction.create(__ -> {
            this.triggerUsed();
            this.searchFinishedHandler.run();
        }).registerCustomShortcutSet(escape == null ? CommonShortcuts.ESCAPE : escape.getShortcutSet(), (JComponent)((Object)this));
        DumbAwareAction.create(e -> this.executeCommand()).registerCustomShortcutSet((ShortcutSet)CustomShortcutSet.fromString((String[])new String[]{"ENTER", "shift ENTER", "alt ENTER", "alt shift ENTER", "meta ENTER"}), (JComponent)this.mySearchField, (Disposable)this);
        DumbAwareAction.create(e -> {
            RunAnythingSearchListModel model = RunAnythingPopupUI.getSearchingModel(this.myResultsList);
            if (model == null) {
                return;
            }
            Object selectedValue = this.myResultsList.getSelectedValue();
            int index = this.myResultsList.getSelectedIndex();
            if (!(selectedValue instanceof RunAnythingItem) || this.isMoreItem(index)) {
                return;
            }
            RunAnythingCache.getInstance(this.getProject()).getState().getCommands().remove(((RunAnythingItem)selectedValue).getCommand());
            model.remove(index);
            model.shiftIndexes(index, -1);
            if (model.size() > 0) {
                ScrollingUtil.selectItem((JList)this.myResultsList, (int)(index < model.size() ? index : index - 1));
            }
            ApplicationManager.getApplication().invokeLater(() -> {
                if (this.myCalcThread != null) {
                    this.myCalcThread.updatePopup();
                }
            });
        }).registerCustomShortcutSet((ShortcutSet)CustomShortcutSet.fromString((String[])new String[]{"shift BACK_SPACE"}), (JComponent)this.mySearchField, (Disposable)this);
        this.myProject.getMessageBus().connect((Disposable)this).subscribe(DumbService.DUMB_MODE, (Object)new DumbService.DumbModeListener(){

            public void exitDumbMode() {
                ApplicationManager.getApplication().invokeLater(() -> RunAnythingPopupUI.this.rebuildList());
            }
        });
    }

    @Override
    @NotNull
    protected ListCellRenderer<Object> createCellRenderer() {
        return new MyListRenderer();
    }

    @Override
    @NotNull
    protected JPanel createSettingsPanel() {
        JPanel res2 = new JPanel();
        BoxLayout bl = new BoxLayout(res2, 0);
        res2.setLayout(bl);
        res2.setOpaque(false);
        DefaultActionGroup actionGroup = new DefaultActionGroup();
        actionGroup.addAction((AnAction)new RunAnythingShowFilterAction(this));
        ActionToolbar toolbar = ActionManager.getInstance().createActionToolbar("search.everywhere.toolbar", (ActionGroup)actionGroup, true);
        toolbar.setLayoutPolicy(0);
        toolbar.updateActionsImmediately();
        JComponent toolbarComponent = toolbar.getComponent();
        toolbarComponent.setOpaque(false);
        toolbarComponent.setBorder((Border)JBUI.Borders.empty((int)2, (int)18, (int)2, (int)9));
        res2.add(toolbarComponent);
        return res2;
    }

    @Override
    @NotNull
    protected String getInitialHint() {
        return IdeBundle.message((String)"run.anything.hint.initial.text", (Object[])new Object[]{KeymapUtil.getKeystrokeText((KeyStroke)UP_KEYSTROKE), KeymapUtil.getKeystrokeText((KeyStroke)DOWN_KEYSTROKE)});
    }

    @Override
    @NotNull
    protected ExtendableTextField createSearchField() {
        ExtendableTextField searchField = super.createSearchField();
        Consumer extensionConsumer = extension -> searchField.addExtension(extension);
        searchField.addPropertyChangeListener((PropertyChangeListener)new RunAnythingIconHandler((Consumer<? super ExtendableTextComponent.Extension>)extensionConsumer, (JTextComponent)searchField));
        return searchField;
    }

    public void dispose() {
        this.resetFields();
    }

    private class RunAnythingShowFilterAction
    extends ShowFilterAction {
        private RunAnythingShowFilterAction(Disposable parentDisposable) {
            super(parentDisposable, RunAnythingPopupUI.this.myProject);
        }

        @Override
        protected boolean isEnabled() {
            return true;
        }

        @Override
        protected boolean isActive() {
            return RunAnythingCompletionGroup.MAIN_GROUPS.size() != this.getVisibleGroups().size();
        }

        @Override
        protected ElementsChooser<?> createChooser() {
            ElementsChooser<RunAnythingGroup> res2 = new ElementsChooser<RunAnythingGroup>((List)ContainerUtil.newArrayList(RunAnythingCompletionGroup.MAIN_GROUPS), false){

                @Override
                protected String getItemText(@NotNull RunAnythingGroup value) {
                    return value.getTitle();
                }
            };
            res2.markElements(this.getVisibleGroups());
            ElementsChooser.ElementsMarkListener<RunAnythingGroup> listener2 = (element, isMarked) -> {
                RunAnythingCache.getInstance(RunAnythingPopupUI.this.myProject).saveGroupVisibilityKey(element.getTitle(), isMarked);
                RunAnythingPopupUI.this.rebuildList();
            };
            res2.addElementsMarkListener(listener2);
            return res2;
        }

        @NotNull
        private List<RunAnythingGroup> getVisibleGroups() {
            Collection<RunAnythingGroup> groups = RunAnythingCompletionGroup.MAIN_GROUPS;
            return ContainerUtil.filter(groups, group -> RunAnythingCache.getInstance(RunAnythingPopupUI.this.myProject).isGroupVisible(group.getTitle()));
        }
    }

    private class CalcThread
    implements Runnable {
        @NotNull
        private final Project myProject;
        @NotNull
        private final String myPattern;
        private final ProgressIndicator myProgressIndicator = new ProgressIndicatorBase();
        private final ActionCallback myDone = new ActionCallback();
        @NotNull
        private final RunAnythingSearchListModel myListModel;

        private CalcThread(@NotNull Project project, String pattern, boolean reuseModel) {
            this.myProject = project;
            this.myPattern = pattern;
            RunAnythingSearchListModel model = RunAnythingPopupUI.getSearchingModel(RunAnythingPopupUI.this.myResultsList);
            this.myListModel = reuseModel && model != null ? model : (RunAnythingPopupUI.isHelpMode(pattern) ? new RunAnythingSearchListModel.RunAnythingHelpListModel() : new RunAnythingSearchListModel.RunAnythingMainListModel());
        }

        @Override
        public void run() {
            try {
                this.check();
                ApplicationManager.getApplication().invokeLater(() -> {
                    RunAnythingPopupUI.this.myResultsList.getEmptyText().setText("Searching...");
                    if (RunAnythingPopupUI.getSearchingModel(RunAnythingPopupUI.this.myResultsList) != null) {
                        RunAnythingPopupUI.this.myAlarm.cancelAllRequests();
                        RunAnythingPopupUI.this.myAlarm.addRequest(() -> {
                            if (DumbService.getInstance((Project)this.myProject).isDumb()) {
                                RunAnythingPopupUI.this.myResultsList.setEmptyText(IdeBundle.message((String)"run.anything.indexing.mode.not.supported", (Object[])new Object[0]));
                                return;
                            }
                            if (!this.myDone.isRejected()) {
                                RunAnythingPopupUI.this.myResultsList.setModel((ListModel)this.myListModel);
                            }
                        }, 200);
                    } else {
                        RunAnythingPopupUI.this.myResultsList.setModel((ListModel)this.myListModel);
                    }
                });
                if (this.myPattern.trim().length() == 0) {
                    this.buildGroups(true);
                    return;
                }
                if (RunAnythingPopupUI.isHelpMode(RunAnythingPopupUI.this.mySearchField.getText())) {
                    this.buildHelpGroups(this.myListModel);
                    this.updatePopup();
                    return;
                }
                this.check();
                this.buildGroups(false);
            }
            catch (ProcessCanceledException ignore) {
                this.myDone.setRejected();
            }
            catch (Exception e) {
                LOG.error((Throwable)e);
                this.myDone.setRejected();
            }
            finally {
                if (!this.isCanceled()) {
                    ApplicationManager.getApplication().invokeLater(() -> RunAnythingPopupUI.this.myResultsList.getEmptyText().setText(IdeBundle.message((String)"run.anything.command.empty.list.title", (Object[])new Object[0])));
                }
                if (!this.myDone.isProcessed()) {
                    this.myDone.setDone();
                }
            }
        }

        private void buildGroups(boolean isRecent) {
            this.buildAllGroups(this.myPattern, () -> this.check(), isRecent);
            this.updatePopup();
        }

        private void buildHelpGroups(@NotNull RunAnythingSearchListModel listModel) {
            listModel.getGroups().forEach(group -> {
                group.collectItems(RunAnythingPopupUI.this.myDataContext, this.myListModel, this.trimHelpPattern(), () -> this.check());
                this.check();
            });
        }

        private void runReadAction(@NotNull Runnable action) {
            if (!DumbService.getInstance((Project)this.myProject).isDumb()) {
                ApplicationManager.getApplication().runReadAction(action);
            }
        }

        protected void check() {
            this.myProgressIndicator.checkCanceled();
            if (this.myDone.isRejected()) {
                throw new ProcessCanceledException();
            }
            assert (RunAnythingPopupUI.this.myCalcThread == this) : "There are two CalcThreads running before one of them was cancelled";
        }

        private void buildAllGroups(@NotNull String pattern, @NotNull Runnable checkCancellation, boolean isRecent) {
            if (isRecent) {
                RunAnythingRecentGroup.INSTANCE.collectItems(RunAnythingPopupUI.this.myDataContext, this.myListModel, pattern, checkCancellation);
            } else {
                this.buildCompletionGroups(pattern, checkCancellation);
            }
        }

        private void buildCompletionGroups(@NotNull String pattern, @NotNull Runnable checkCancellation) {
            LOG.assertTrue(this.myListModel instanceof RunAnythingSearchListModel.RunAnythingMainListModel);
            ((StreamEx)StreamEx.of((Object)RunAnythingRecentGroup.INSTANCE).select(RunAnythingGroup.class).append(this.myListModel.getGroups().stream().filter(group -> group instanceof RunAnythingCompletionGroup || group instanceof RunAnythingGeneralGroup).filter(group -> RunAnythingCache.getInstance(this.myProject).isGroupVisible(group.getTitle())))).forEach(group -> {
                this.runReadAction(() -> group.collectItems(RunAnythingPopupUI.this.myDataContext, this.myListModel, pattern, checkCancellation));
                checkCancellation.run();
            });
        }

        private boolean isCanceled() {
            return this.myProgressIndicator.isCanceled() || this.myDone.isRejected();
        }

        void updatePopup() {
            ApplicationManager.getApplication().invokeLater(() -> {
                this.myListModel.update();
                RunAnythingPopupUI.this.myResultsList.revalidate();
                RunAnythingPopupUI.this.myResultsList.repaint();
                RunAnythingPopupUI.this.installScrollingActions();
                RunAnythingPopupUI.this.updateViewType(this.myListModel.size() == 0 ? BigPopupUI.ViewType.SHORT : BigPopupUI.ViewType.FULL);
            });
        }

        public ActionCallback cancel() {
            this.myProgressIndicator.cancel();
            return this.myDone;
        }

        public ActionCallback insert(int index, @NotNull RunAnythingGroup group) {
            ApplicationManager.getApplication().executeOnPooledThread(() -> this.runReadAction(() -> {
                try {
                    RunAnythingGroup.SearchResult result2 = group.getItems(RunAnythingPopupUI.this.myDataContext, this.myListModel, this.trimHelpPattern(), true, this::check);
                    this.check();
                    ApplicationManager.getApplication().invokeLater(() -> {
                        try {
                            int shift = 0;
                            int i = index + 1;
                            for (Object o : result2) {
                                this.myListModel.insertElementAt(o, i);
                                ++shift;
                                ++i;
                            }
                            this.myListModel.shiftIndexes(index, shift);
                            if (!result2.isNeedMore()) {
                                group.resetMoreIndex();
                            }
                            RunAnythingPopupUI.this.clearSelection();
                            ScrollingUtil.selectItem((JList)RunAnythingPopupUI.this.myResultsList, (int)index);
                            this.myDone.setDone();
                        }
                        catch (Exception e) {
                            this.myDone.setRejected();
                        }
                    });
                }
                catch (Exception e) {
                    this.myDone.setRejected();
                }
            }));
            return this.myDone;
        }

        @NotNull
        public String trimHelpPattern() {
            return RunAnythingPopupUI.isHelpMode(this.myPattern) ? this.myPattern.substring(RunAnythingPopupUI.HELP_PLACEHOLDER.length()) : this.myPattern;
        }

        public ActionCallback start() {
            ApplicationManager.getApplication().executeOnPooledThread((Runnable)this);
            return this.myDone;
        }
    }

    private class MyListRenderer
    extends ColoredListCellRenderer<Object> {
        private final RunAnythingMyAccessibleComponent myMainPanel = new RunAnythingMyAccessibleComponent(new BorderLayout());
        private final JLabel myTitle = new JLabel();

        private MyListRenderer() {
        }

        public Component getListCellRendererComponent(JList list2, Object value, int index, boolean isSelected, boolean hasFocus) {
            String title;
            Color foreground;
            Color bg;
            Component cmp = null;
            if (RunAnythingPopupUI.this.isMoreItem(index)) {
                cmp = RunAnythingMore.get(isSelected);
            }
            if (cmp == null) {
                if (value instanceof RunAnythingItem) {
                    cmp = ((RunAnythingItem)value).createComponent(RunAnythingPopupUI.this.myLastInputText, isSelected, hasFocus);
                } else {
                    cmp = super.getListCellRendererComponent(list2, value, index, isSelected, isSelected);
                    JPanel p = new JPanel(new BorderLayout());
                    p.setBackground(UIUtil.getListBackground((boolean)isSelected, (boolean)true));
                    p.add(cmp, "Center");
                    cmp = p;
                }
            }
            if ((bg = cmp.getBackground()) == null) {
                cmp.setBackground(UIUtil.getListBackground((boolean)isSelected));
                bg = cmp.getBackground();
            }
            if ((foreground = cmp.getForeground()) == null) {
                cmp.setForeground(UIUtil.getListForeground((boolean)isSelected));
                foreground = cmp.getBackground();
            }
            this.myMainPanel.removeAll();
            RunAnythingSearchListModel model = RunAnythingPopupUI.getSearchingModel(RunAnythingPopupUI.this.myResultsList);
            if (model != null && (title = model.getTitle(index)) != null) {
                this.myTitle.setText(title);
                this.myMainPanel.add((Component)RunAnythingUtil.createTitle(" " + title), "North");
            }
            JPanel wrapped = new JPanel(new BorderLayout());
            wrapped.setBackground(bg);
            wrapped.setForeground(foreground);
            wrapped.setBorder(RENDERER_BORDER);
            wrapped.add(cmp, "Center");
            this.myMainPanel.add((Component)wrapped, "Center");
            if (cmp instanceof Accessible) {
                this.myMainPanel.setAccessible((Accessible)((Object)cmp));
            }
            return this.myMainPanel;
        }

        protected void customizeCellRenderer(@NotNull JList list2, Object value, int index, boolean selected, boolean hasFocus) {
        }
    }
}

