/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.actions.runAnything;

import com.intellij.ide.actions.runAnything.RunAnythingSearchListModel;
import com.intellij.ide.actions.runAnything.groups.RunAnythingGroup;
import com.intellij.internal.statistic.service.fus.collectors.FUCounterUsageLogger;
import com.intellij.internal.statistic.utils.PluginInfoDetectorKt;
import com.intellij.openapi.project.Project;
import java.util.Collection;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\u0018\u0000 \u00032\u00020\u0001:\u0001\u0003B\u0005\u00a2\u0006\u0002\u0010\u0002\u00a8\u0006\u0004"}, d2={"Lcom/intellij/ide/actions/runAnything/RunAnythingUsageCollector;", "", "()V", "Companion", "intellij.platform.lang.impl"})
public final class RunAnythingUsageCollector {
    private static final String[] allowedCompletionGroupTitles;
    private static final String[] allowedHelpGroupTitles;
    public static final Companion Companion;

    static {
        Companion = new Companion(null);
        allowedCompletionGroupTitles = new String[]{"Bundler", "rails generators", "Gradle tasks", "npm scripts", "Maven goals", "rvm use", "rake", "rbenv shell", "General", "Recent projects", "Run configurations"};
        allowedHelpGroupTitles = new String[]{"Gradle", "Maven", "npm", "Python", "Recent projects", "ruby", "General", "Recent"};
    }

    @Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0014\u0010\b\u001a\u00020\u00052\n\u0010\t\u001a\u0006\u0012\u0002\b\u00030\nH\u0002J\u0010\u0010\u000b\u001a\u00020\u00052\u0006\u0010\f\u001a\u00020\rH\u0002J\u0016\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0005J4\u0010\u0013\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\f\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\r0\u00152\u000e\u0010\t\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00160\n2\u0006\u0010\u0017\u001a\u00020\u0018J&\u0010\u0019\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\f\u001a\u00020\r2\u000e\u0010\t\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00160\nR\u0016\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u0006R\u0016\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u0006\u00a8\u0006\u001a"}, d2={"Lcom/intellij/ide/actions/runAnything/RunAnythingUsageCollector$Companion;", "", "()V", "allowedCompletionGroupTitles", "", "", "[Ljava/lang/String;", "allowedHelpGroupTitles", "getSafeToReportClazzName", "clazz", "Ljava/lang/Class;", "getSafeToReportTitle", "group", "Lcom/intellij/ide/actions/runAnything/groups/RunAnythingGroup;", "trigger", "", "project", "Lcom/intellij/openapi/project/Project;", "featureId", "triggerExecCategoryStatistics", "groups", "", "Lcom/intellij/ide/actions/runAnything/RunAnythingSearchListModel;", "index", "", "triggerMoreStatistics", "intellij.platform.lang.impl"})
    public static final class Companion {
        public final void trigger(@NotNull Project project, @NotNull String featureId) {
            FUCounterUsageLogger.getInstance().logEvent(project, "actions.runAnything", featureId);
        }

        /*
         * WARNING - void declaration
         */
        public final void triggerExecCategoryStatistics(@NotNull Project project, @NotNull Collection<? extends RunAnythingGroup> groups, @NotNull Class<? extends RunAnythingSearchListModel> clazz, int index) {
            int n = index;
            boolean bl = false;
            while (n >= 0) {
                void i;
                RunAnythingGroup group = RunAnythingGroup.findGroup(groups, (int)i);
                if (group != null) {
                    Companion.trigger(project, this.getSafeToReportClazzName(clazz) + ": " + "RunAnything" + " - execution - " + this.getSafeToReportTitle(group));
                    break;
                }
                --i;
            }
        }

        public final void triggerMoreStatistics(@NotNull Project project, @NotNull RunAnythingGroup group, @NotNull Class<? extends RunAnythingSearchListModel> clazz) {
            Companion.trigger(project, this.getSafeToReportClazzName(clazz) + ": " + "RunAnything" + " - more - " + this.getSafeToReportTitle(group));
        }

        private final String getSafeToReportClazzName(Class<?> clazz) {
            return PluginInfoDetectorKt.getPluginInfo(clazz).isSafeToReport() ? clazz.getSimpleName() : "third.party";
        }

        private final String getSafeToReportTitle(RunAnythingGroup group) {
            if (PluginInfoDetectorKt.getPluginInfo(group.getClass()).isSafeToReport()) {
                return ArraysKt.contains((Object[])allowedCompletionGroupTitles, (Object)group.getTitle()) || ArraysKt.contains((Object[])allowedHelpGroupTitles, (Object)group.getTitle()) ? group.getTitle() : "run.anything.group.unknown.title";
            }
            return "third.party";
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

