/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.actions.runAnything;

import com.intellij.execution.Executor;
import com.intellij.execution.ExecutorRegistry;
import com.intellij.icons.AllIcons;
import com.intellij.ide.IdeBundle;
import com.intellij.ide.actions.runAnything.RunAnythingAction;
import com.intellij.ide.actions.runAnything.RunAnythingCache;
import com.intellij.ide.actions.runAnything.RunAnythingSearchListModel;
import com.intellij.ide.actions.runAnything.RunAnythingUsageCollector;
import com.intellij.ide.actions.runAnything.activity.RunAnythingProvider;
import com.intellij.ide.ui.search.OptionDescription;
import com.intellij.ide.util.PropertiesComponent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.KeyboardShortcut;
import com.intellij.openapi.actionSystem.LangDataKeys;
import com.intellij.openapi.actionSystem.Shortcut;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.keymap.KeymapUtil;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.popup.JBPopup;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.wm.ToolWindowId;
import com.intellij.ui.Gray;
import com.intellij.ui.JBColor;
import com.intellij.ui.ScreenUtil;
import com.intellij.ui.ScrollingUtil;
import com.intellij.ui.SeparatorComponent;
import com.intellij.ui.components.JBList;
import com.intellij.ui.popup.PopupPositionManager;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.UIUtil;
import com.intellij.util.ui.components.BorderLayoutPanel;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Point;
import java.awt.Rectangle;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.ListModel;
import javax.swing.border.Border;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class RunAnythingUtil {
    public static final Logger LOG = Logger.getInstance(RunAnythingUtil.class);
    public static final Icon UNDEFINED_COMMAND_ICON = AllIcons.Actions.Run_anything;
    public static final String SHIFT_SHORTCUT_TEXT = KeymapUtil.getShortcutText((Shortcut)KeyboardShortcut.fromString((String)"SHIFT"));
    public static final String AD_DEBUG_TEXT = IdeBundle.message((String)"run.anything.ad.run.with.debug", (Object[])new Object[]{SHIFT_SHORTCUT_TEXT});
    public static final String AD_CONTEXT_TEXT = IdeBundle.message((String)"run.anything.ad.run.in.context", (Object[])new Object[]{KeymapUtil.getShortcutText((Shortcut)KeyboardShortcut.fromString((String)"pressed ALT"))});
    private static final Key<Collection<Pair<String, String>>> RUN_ANYTHING_WRAPPED_COMMANDS = Key.create((String)"RUN_ANYTHING_WRAPPED_COMMANDS");
    private static final Border RENDERER_TITLE_BORDER = JBUI.Borders.emptyTop((int)3);
    private static final String SHIFT_HOLD_USAGE = "RunAnything - SHIFT_HOLD";

    static Font getTitleFont() {
        return UIUtil.getLabelFont().deriveFont(UIUtil.getFontSize((UIUtil.FontSize)UIUtil.FontSize.SMALL));
    }

    static JComponent createTitle(String titleText) {
        JLabel titleLabel = new JLabel(titleText);
        titleLabel.setFont(RunAnythingUtil.getTitleFont());
        titleLabel.setForeground(UIUtil.getLabelDisabledForeground());
        SeparatorComponent separatorComponent = new SeparatorComponent(titleLabel.getPreferredSize().height / 2, (Color)new JBColor((Color)Gray._220, (Color)Gray._80), null);
        return ((BorderLayoutPanel)JBUI.Panels.simplePanel((int)5, (int)10).addToCenter((Component)separatorComponent).addToLeft((Component)titleLabel).withBorder(RENDERER_TITLE_BORDER)).withBackground(UIUtil.getListBackground());
    }

    static String getSettingText(OptionDescription value) {
        String hit = value.getHit();
        if (hit == null) {
            hit = value.getOption();
        }
        if ((hit = StringUtil.unescapeXmlEntities((String)hit)).length() > 60) {
            hit = hit.substring(0, 60) + "...";
        }
        hit = hit.replace("  ", " ");
        String text = hit.trim();
        text = StringUtil.trimEnd((String)text, (String)":");
        return text;
    }

    static int getPopupMaxWidth() {
        return PropertiesComponent.getInstance().getInt("run.anything.max.popup.width", JBUI.scale((int)600));
    }

    @Nullable
    static String getInitialTextForNavigation(@Nullable Editor editor) {
        String selectedText;
        if (editor != null && (selectedText = editor.getSelectionModel().getSelectedText()) != null && !selectedText.contains("\n")) {
            return selectedText;
        }
        return null;
    }

    static void adjustPopup(JBPopup balloon, JBPopup popup2) {
        Dimension d = PopupPositionManager.PositionAdjuster.getPopupSize(popup2);
        JComponent myRelativeTo = balloon.getContent();
        Point myRelativeOnScreen = myRelativeTo.getLocationOnScreen();
        Rectangle screen = ScreenUtil.getScreenRectangle((Point)myRelativeOnScreen);
        Rectangle popupRect = null;
        Rectangle r = new Rectangle(myRelativeOnScreen.x, myRelativeOnScreen.y + myRelativeTo.getHeight(), d.width, d.height);
        if (screen.contains(r)) {
            popupRect = r;
        }
        if (popupRect != null) {
            Point location = new Point(r.x, r.y);
            if (!location.equals(popup2.getLocationOnScreen())) {
                popup2.setLocation(location);
            }
        } else {
            if (r.y + d.height > screen.y + screen.height) {
                r.height = screen.y + screen.height - r.y - 2;
            }
            if (r.width > screen.width) {
                r.width = screen.width - 50;
            }
            if (r.x + r.width > screen.x + screen.width) {
                r.x = screen.x + screen.width - r.width - 2;
            }
            popup2.setSize(r.getSize());
            popup2.setLocation(r.getLocation());
        }
    }

    static void jumpNextGroup(boolean forward, JBList list2) {
        int index = list2.getSelectedIndex();
        RunAnythingSearchListModel model = RunAnythingUtil.getSearchingModel(list2);
        if (model != null && index >= 0) {
            int newIndex = forward ? model.next(index) : model.prev(index);
            list2.setSelectedIndex(newIndex);
            int more = model.next(newIndex) - 1;
            if (more < newIndex) {
                more = list2.getItemsCount() - 1;
            }
            ScrollingUtil.ensureIndexIsVisible((JList)list2, (int)more, (int)(forward ? 1 : -1));
            ScrollingUtil.ensureIndexIsVisible((JList)list2, (int)newIndex, (int)(forward ? 1 : -1));
        }
    }

    static void triggerShiftStatistics(@NotNull DataContext dataContext) {
        Project project = (Project)Objects.requireNonNull(CommonDataKeys.PROJECT.getData(dataContext));
        Executor executor = (Executor)Objects.requireNonNull(RunAnythingAction.EXECUTOR_KEY.getData(dataContext));
        if (ExecutorRegistry.getInstance().getExecutorById(ToolWindowId.DEBUG) == executor) {
            RunAnythingUsageCollector.Companion.trigger(project, SHIFT_HOLD_USAGE);
        }
    }

    @NotNull
    public static Collection<Pair<String, String>> getOrCreateWrappedCommands(@NotNull Project project) {
        Collection list2 = (Collection)project.getUserData(RUN_ANYTHING_WRAPPED_COMMANDS);
        if (list2 == null) {
            list2 = ContainerUtil.newArrayList();
            project.putUserData(RUN_ANYTHING_WRAPPED_COMMANDS, (Object)list2);
        }
        return list2;
    }

    @NotNull
    public static Project fetchProject(@NotNull DataContext dataContext) {
        return (Project)ObjectUtils.assertNotNull((Object)CommonDataKeys.PROJECT.getData(dataContext));
    }

    public static void executeMatched(@NotNull DataContext dataContext, @NotNull String pattern) {
        List<String> commands = RunAnythingCache.getInstance(RunAnythingUtil.fetchProject(dataContext)).getState().getCommands();
        Module module = (Module)LangDataKeys.MODULE.getData(dataContext);
        if (module == null) {
            LOG.info("RunAnything: module hasn't been found, command will be executed in context of 'null' module.");
        }
        for (RunAnythingProvider provider : (RunAnythingProvider[])RunAnythingProvider.EP_NAME.getExtensions()) {
            Object value = provider.findMatchingValue(dataContext, pattern);
            if (value == null) continue;
            provider.execute(dataContext, value);
            commands.remove(pattern);
            commands.add(pattern);
            break;
        }
    }

    @Nullable
    public static RunAnythingSearchListModel getSearchingModel(@NotNull JBList list2) {
        ListModel model = list2.getModel();
        return model instanceof RunAnythingSearchListModel ? (RunAnythingSearchListModel)model : null;
    }
}

