/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.actions.runAnything.activity;

import com.intellij.execution.ExecutionException;
import com.intellij.execution.Executor;
import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.execution.configurations.PtyCommandLine;
import com.intellij.execution.configurations.RunProfile;
import com.intellij.execution.runners.ExecutionEnvironmentBuilder;
import com.intellij.icons.AllIcons;
import com.intellij.ide.IdeBundle;
import com.intellij.ide.actions.runAnything.RunAnythingAction;
import com.intellij.ide.actions.runAnything.RunAnythingCache;
import com.intellij.ide.actions.runAnything.RunAnythingUtil;
import com.intellij.ide.actions.runAnything.activity.RunAnythingProviderBase;
import com.intellij.ide.actions.runAnything.commands.RunAnythingCommandCustomizer;
import com.intellij.ide.actions.runAnything.execution.RunAnythingRunProfile;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.KeyboardShortcut;
import com.intellij.openapi.actionSystem.Shortcut;
import com.intellij.openapi.keymap.KeymapUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.execution.ParametersListUtil;
import java.util.List;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class RunAnythingCommandProvider
extends RunAnythingProviderBase<String> {
    public final String AD_DELETE_COMMAND_TEXT = IdeBundle.message((String)"run.anything.ad.command.delete", (Object[])new Object[]{KeymapUtil.getShortcutText((Shortcut)KeyboardShortcut.fromString((String)"shift BACK_SPACE"))});

    @Override
    public void execute(@NotNull DataContext dataContext, @NotNull String value) {
        VirtualFile workDirectory = (VirtualFile)dataContext.getData(CommonDataKeys.VIRTUAL_FILE);
        Executor executor = (Executor)dataContext.getData(RunAnythingAction.EXECUTOR_KEY);
        RunAnythingUtil.LOG.assertTrue(workDirectory != null);
        RunAnythingUtil.LOG.assertTrue(executor != null);
        RunAnythingCommandProvider.runCommand(workDirectory, value, executor, dataContext);
    }

    public static void runCommand(@NotNull VirtualFile workDirectory, @NotNull String commandString, @NotNull Executor executor, @NotNull DataContext dataContext) {
        Project project = (Project)CommonDataKeys.PROJECT.getData(dataContext);
        RunAnythingUtil.LOG.assertTrue(project != null);
        List<String> commands = RunAnythingCache.getInstance(project).getState().getCommands();
        commands.remove(commandString);
        commands.add(commandString);
        dataContext = RunAnythingCommandCustomizer.customizeContext(dataContext);
        GeneralCommandLine initialCommandLine = new GeneralCommandLine(ParametersListUtil.parse((String)commandString, (boolean)false, (boolean)true)).withParentEnvironmentType(GeneralCommandLine.ParentEnvironmentType.CONSOLE).withWorkDirectory(workDirectory.getPath());
        GeneralCommandLine commandLine = RunAnythingCommandCustomizer.customizeCommandLine(dataContext, workDirectory, initialCommandLine);
        try {
            RunAnythingRunProfile runAnythingRunProfile = new RunAnythingRunProfile((GeneralCommandLine)(Registry.is((String)"run.anything.use.pty", (boolean)false) ? new PtyCommandLine(commandLine) : commandLine), commandString);
            ExecutionEnvironmentBuilder.create((Project)project, (Executor)executor, (RunProfile)runAnythingRunProfile).dataContext(dataContext).buildAndExecute();
        }
        catch (ExecutionException e) {
            RunAnythingUtil.LOG.warn((Throwable)e);
            Messages.showInfoMessage((Project)project, (String)e.getMessage(), (String)IdeBundle.message((String)"run.anything.console.error.title", (Object[])new Object[0]));
        }
    }

    @Override
    @Nullable
    public String getAdText() {
        return RunAnythingUtil.AD_CONTEXT_TEXT + ", " + RunAnythingUtil.AD_DEBUG_TEXT + ", " + this.AD_DELETE_COMMAND_TEXT;
    }

    @Override
    @NotNull
    public String getCommand(@NotNull String value) {
        return value;
    }

    @Override
    @Nullable
    public Icon getIcon(@NotNull String value) {
        return AllIcons.Actions.Run_anything;
    }
}

