/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.actions.runAnything.activity;

import com.intellij.icons.AllIcons;
import com.intellij.ide.IdeBundle;
import com.intellij.ide.actions.runAnything.RunAnythingUtil;
import com.intellij.ide.actions.runAnything.activity.RunAnythingProviderBase;
import com.intellij.notification.Notification;
import com.intellij.notification.NotificationType;
import com.intellij.notification.Notifications;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class RunAnythingNotifiableProvider<V>
extends RunAnythingProviderBase<V> {
    private static final String RUN_ANYTHING_GROUP_ID = IdeBundle.message((String)"run.anything.custom.activity.notification.group.id", (Object[])new Object[0]);

    protected abstract boolean run(@NotNull DataContext var1, @NotNull V var2);

    @Nullable
    protected abstract Runnable getRollbackAction(@NotNull DataContext var1);

    @NotNull
    protected abstract String getNotificationTitle(@NotNull DataContext var1, @NotNull V var2);

    @NotNull
    protected abstract String getNotificationContent(@NotNull DataContext var1, @NotNull V var2);

    @Override
    public void execute(@NotNull DataContext dataContext, @NotNull V value) {
        if (this.run(dataContext, value)) {
            this.getNotificationCallback(dataContext, value).run();
        } else {
            Messages.showWarningDialog((Project)RunAnythingUtil.fetchProject(dataContext), (String)IdeBundle.message((String)"run.anything.notification.warning.content", (Object[])new Object[]{this.getCommand(value)}), (String)IdeBundle.message((String)"run.anything.notification.warning.title", (Object[])new Object[0]));
        }
    }

    private Runnable getNotificationCallback(@NotNull DataContext dataContext, @NotNull V value) {
        return () -> {
            final Notification notification = new Notification(RUN_ANYTHING_GROUP_ID, AllIcons.Actions.Run_anything, this.getNotificationTitle(dataContext, value), null, this.getNotificationContent(dataContext, value), NotificationType.INFORMATION, null);
            final Runnable rollbackAction = this.getRollbackAction(dataContext);
            if (rollbackAction != null) {
                AnAction action = new AnAction(IdeBundle.message((String)"run.anything.custom.activity.rollback.action", (Object[])new Object[0])){

                    public void actionPerformed(@NotNull AnActionEvent e) {
                        rollbackAction.run();
                        notification.expire();
                    }
                };
                notification.addAction(action);
            }
            Notifications.Bus.notify((Notification)notification);
        };
    }
}

