/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.actions.runAnything.groups;

import com.intellij.ide.actions.runAnything.items.RunAnythingItem;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.psi.codeStyle.NameUtil;
import com.intellij.util.Function;
import gnu.trove.TIntArrayList;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Optional;
import javax.swing.DefaultListModel;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class RunAnythingGroup {
    public static final Function<String, NameUtil.MatcherBuilder> RUN_ANYTHING_MATCHER_BUILDER = pattern -> NameUtil.buildMatcher((String)("*" + pattern));
    volatile int myMoreIndex = -1;
    private volatile int myTitleIndex = -1;

    @NotNull
    public abstract String getTitle();

    protected int getMaxInitialItems() {
        return 5;
    }

    protected int getMaxItemsToInsert() {
        return 5;
    }

    public abstract SearchResult getItems(@NotNull DataContext var1, @NotNull DefaultListModel var2, @NotNull String var3, boolean var4, @NotNull Runnable var5);

    public void resetMoreIndex() {
        this.myMoreIndex = -1;
    }

    private static void shiftMoreIndex(Collection<? extends RunAnythingGroup> groups, int baseIndex, int shift) {
        groups.stream().filter(runAnythingGroup -> runAnythingGroup.myMoreIndex >= baseIndex).forEach(runAnythingGroup -> runAnythingGroup.myMoreIndex += shift);
    }

    @Nullable
    public static String getTitle(@NotNull Collection<RunAnythingGroup> groups, int titleIndex) {
        return Optional.ofNullable(RunAnythingGroup.findGroup(groups, titleIndex)).map(RunAnythingGroup::getTitle).orElse(null);
    }

    @Nullable
    public static RunAnythingGroup findGroup(@NotNull Collection<RunAnythingGroup> groups, int titleIndex) {
        return groups.stream().filter(runAnythingGroup -> titleIndex == runAnythingGroup.myTitleIndex).findFirst().orElse(null);
    }

    private static void shiftTitleIndex(@NotNull Collection<RunAnythingGroup> groups, int baseIndex, int shift) {
        groups.stream().filter(runAnythingGroup -> runAnythingGroup.myTitleIndex != -1 && runAnythingGroup.myTitleIndex > baseIndex).forEach(runAnythingGroup -> runAnythingGroup.myTitleIndex += shift);
    }

    public static void clearMoreIndex(@NotNull Collection<? extends RunAnythingGroup> groups) {
        groups.forEach(runAnythingGroup -> {
            runAnythingGroup.myMoreIndex = -1;
        });
    }

    private static void clearTitleIndex(@NotNull Collection<RunAnythingGroup> groups) {
        groups.forEach(runAnythingGroup -> {
            runAnythingGroup.myTitleIndex = -1;
        });
    }

    public static int[] getAllIndexes(@NotNull Collection<? extends RunAnythingGroup> groups) {
        TIntArrayList list2 = new TIntArrayList();
        for (RunAnythingGroup runAnythingGroup : groups) {
            list2.add(runAnythingGroup.myTitleIndex);
        }
        for (RunAnythingGroup runAnythingGroup : groups) {
            list2.add(runAnythingGroup.myMoreIndex);
        }
        return list2.toNativeArray();
    }

    @Nullable
    public static RunAnythingGroup findGroupByMoreIndex(@NotNull Collection<? extends RunAnythingGroup> groups, int moreIndex) {
        return groups.stream().filter(runAnythingGroup -> moreIndex == runAnythingGroup.myMoreIndex).findFirst().orElse(null);
    }

    public static boolean isMoreIndex(@NotNull Collection<? extends RunAnythingGroup> groups, int index) {
        return groups.stream().anyMatch(runAnythingGroup -> runAnythingGroup.myMoreIndex == index);
    }

    public static void shiftIndexes(@NotNull Collection<RunAnythingGroup> groups, int baseIndex, int shift) {
        RunAnythingGroup.shiftTitleIndex(groups, baseIndex, shift);
        RunAnythingGroup.shiftMoreIndex(groups, baseIndex, shift);
    }

    public static void clearIndexes(@NotNull Collection<RunAnythingGroup> groups) {
        RunAnythingGroup.clearTitleIndex(groups);
        RunAnythingGroup.clearMoreIndex(groups);
    }

    public final synchronized void collectItems(@NotNull DataContext dataContext, @NotNull DefaultListModel model, @NotNull String pattern, @NotNull Runnable cancellationChecker) {
        SearchResult result2 = this.getItems(dataContext, model, pattern, false, cancellationChecker);
        cancellationChecker.run();
        if (!result2.isEmpty()) {
            ApplicationManager.getApplication().invokeLater(() -> {
                cancellationChecker.run();
                this.myTitleIndex = model.size();
                result2.forEach(model::addElement);
                this.myMoreIndex = result2.myNeedMore ? model.getSize() - 1 : -1;
            });
        }
    }

    public static class SearchResult
    extends ArrayList<RunAnythingItem> {
        boolean myNeedMore;

        public boolean isNeedMore() {
            return this.myNeedMore;
        }

        public void setNeedMore(boolean needMore) {
            this.myNeedMore = needMore;
        }
    }
}

