/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.actions.runAnything.items;

import com.intellij.ide.actions.runAnything.items.RunAnythingItemBase;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.ui.SimpleColoredComponent;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.util.ui.UIUtil;
import java.awt.Component;
import javax.swing.Icon;
import javax.swing.JPanel;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class RunAnythingHelpItem
extends RunAnythingItemBase {
    @NotNull
    private final String myPlaceholder;
    @Nullable
    private final String myDescription;
    @Nullable
    private final Icon myIcon;

    public RunAnythingHelpItem(@NotNull String placeholder, @NotNull String command, @Nullable String description, @Nullable Icon icon) {
        super(command, icon);
        this.myPlaceholder = placeholder;
        this.myDescription = description;
        this.myIcon = icon;
    }

    @Override
    @NotNull
    public Component createComponent(@Nullable String pattern, boolean isSelected, boolean hasFocus) {
        JPanel component = (JPanel)super.createComponent(pattern, isSelected, hasFocus);
        SimpleColoredComponent simpleColoredComponent = new SimpleColoredComponent();
        RunAnythingHelpItem.parseAndApplyStyleToParameters(simpleColoredComponent, this.myPlaceholder);
        RunAnythingHelpItem.appendDescription(simpleColoredComponent, this.myDescription, UIUtil.getListForeground((boolean)isSelected, (boolean)true));
        this.setupIcon(simpleColoredComponent, this.myIcon);
        component.add((Component)simpleColoredComponent, "West");
        return component;
    }

    private static void parseAndApplyStyleToParameters(@NotNull SimpleColoredComponent component, @NotNull String placeholder) {
        int lt = StringUtil.indexOf((CharSequence)placeholder, (CharSequence)"<");
        if (lt == -1) {
            component.append(placeholder);
            return;
        }
        int gt = StringUtil.indexOf((CharSequence)placeholder, (CharSequence)">", (int)lt);
        component.append(gt > -1 ? placeholder.substring(0, lt) : placeholder);
        while (lt > -1 && gt > -1) {
            component.append(placeholder.substring(lt, gt + 1), SimpleTextAttributes.GRAY_ATTRIBUTES);
            lt = StringUtil.indexOf((CharSequence)placeholder, (CharSequence)"<", (int)gt);
            if (lt == -1) {
                component.append(placeholder.substring(gt + 1));
                break;
            }
            component.append(placeholder.substring(gt + 1, lt));
            gt = StringUtil.indexOf((CharSequence)placeholder, (CharSequence)">", (int)lt);
        }
    }
}

