/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.actions.runAnything.ui;

import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonShortcuts;
import com.intellij.ui.ScrollingUtil;
import com.intellij.util.ui.UIUtil;
import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import javax.swing.ActionMap;
import javax.swing.InputMap;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.ListSelectionModel;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public class RunAnythingScrollingUtil {
    @NonNls
    protected static final String SELECT_PREVIOUS_ROW_ACTION_ID = "selectPreviousRow";
    @NonNls
    protected static final String SELECT_NEXT_ROW_ACTION_ID = "selectNextRow";

    public static void installActions(@NotNull JList list2, @NotNull JTextField focusParent, @NotNull Runnable handleFocusParent, boolean isCycleScrolling) {
        ActionMap actionMap = list2.getActionMap();
        actionMap.put(SELECT_PREVIOUS_ROW_ACTION_ID, new MoveAction(SELECT_PREVIOUS_ROW_ACTION_ID, list2, handleFocusParent, isCycleScrolling));
        actionMap.put(SELECT_NEXT_ROW_ACTION_ID, new MoveAction(SELECT_NEXT_ROW_ACTION_ID, list2, handleFocusParent, isCycleScrolling));
        RunAnythingScrollingUtil.maybeInstallDefaultShortcuts(list2);
        RunAnythingScrollingUtil.installMoveUpAction(list2, focusParent, handleFocusParent, isCycleScrolling);
        RunAnythingScrollingUtil.installMoveDownAction(list2, focusParent, handleFocusParent, isCycleScrolling);
    }

    private static void maybeInstallDefaultShortcuts(@NotNull JComponent component) {
        InputMap map2 = component.getInputMap(0);
        UIUtil.maybeInstall((InputMap)map2, (String)SELECT_PREVIOUS_ROW_ACTION_ID, (KeyStroke)KeyStroke.getKeyStroke(38, 0));
        UIUtil.maybeInstall((InputMap)map2, (String)SELECT_NEXT_ROW_ACTION_ID, (KeyStroke)KeyStroke.getKeyStroke(40, 0));
    }

    private static void installMoveDownAction(final @NotNull JList list2, @NotNull JComponent focusParent, final @NotNull Runnable handleFocusParent, final boolean isCycleScrolling) {
        new ScrollingUtil.ListScrollAction(CommonShortcuts.getMoveDown(), focusParent){

            public void actionPerformed(@NotNull AnActionEvent e) {
                RunAnythingScrollingUtil.moveDown(list2, handleFocusParent, isCycleScrolling);
            }
        };
    }

    private static void installMoveUpAction(final @NotNull JList list2, @NotNull JComponent focusParent, final @NotNull Runnable handleFocusParent, final boolean isCycleScrolling) {
        new ScrollingUtil.ListScrollAction(CommonShortcuts.getMoveUp(), focusParent){

            public void actionPerformed(@NotNull AnActionEvent e) {
                RunAnythingScrollingUtil.moveUp(list2, handleFocusParent, isCycleScrolling);
            }
        };
    }

    private static void moveDown(@NotNull JList list2, @NotNull Runnable handleFocusParent, boolean isCycleScrolling) {
        RunAnythingScrollingUtil.move(list2, list2.getSelectionModel(), list2.getModel().getSize(), 1, handleFocusParent, isCycleScrolling);
    }

    private static void moveUp(@NotNull JList list2, @NotNull Runnable handleFocusParent, boolean isCycleScrolling) {
        RunAnythingScrollingUtil.move(list2, list2.getSelectionModel(), list2.getModel().getSize(), -1, handleFocusParent, isCycleScrolling);
    }

    private static void move(@NotNull JList c, @NotNull ListSelectionModel selectionModel, int size, int direction, @NotNull Runnable handleFocusParent, boolean isCycleScrolling) {
        if (size == 0) {
            return;
        }
        int index = selectionModel.getMaxSelectionIndex();
        int indexToSelect = index + direction;
        if (!(indexToSelect != -2 && indexToSelect < size || isCycleScrolling)) {
            return;
        }
        if (indexToSelect == -2) {
            indexToSelect = size - 1;
        } else if (indexToSelect == -1 || indexToSelect >= size) {
            handleFocusParent.run();
            return;
        }
        ScrollingUtil.ensureIndexIsVisible((JList)c, (int)indexToSelect, (int)-1);
        selectionModel.setSelectionInterval(indexToSelect, indexToSelect);
    }

    private static class MoveAction
    extends AbstractAction {
        @NotNull
        private final String myId;
        @NotNull
        private final JList myComponent;
        @NotNull
        private final Runnable myHandleFocusParent;
        private final boolean myIsCycleScrolling;

        MoveAction(@NotNull String id, @NotNull JList component, @NotNull Runnable handleFocusParent, boolean isCycleScrolling) {
            this.myId = id;
            this.myComponent = component;
            this.myHandleFocusParent = handleFocusParent;
            this.myIsCycleScrolling = isCycleScrolling;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (RunAnythingScrollingUtil.SELECT_PREVIOUS_ROW_ACTION_ID.equals(this.myId)) {
                RunAnythingScrollingUtil.moveUp(this.myComponent, this.myHandleFocusParent, this.myIsCycleScrolling);
            } else if (RunAnythingScrollingUtil.SELECT_NEXT_ROW_ACTION_ID.equals(this.myId)) {
                RunAnythingScrollingUtil.moveDown(this.myComponent, this.myHandleFocusParent, this.myIsCycleScrolling);
            }
        }
    }
}

