/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.actions.searcheverywhere;

import com.intellij.codeInsight.navigation.NavigationUtil;
import com.intellij.ide.actions.QualifiedNameProviderUtil;
import com.intellij.ide.actions.SearchEverywherePsiRenderer;
import com.intellij.ide.actions.searcheverywhere.SearchEverywhereContributor;
import com.intellij.ide.actions.searcheverywhere.SearchEverywhereContributorFilter;
import com.intellij.ide.actions.searcheverywhere.SearchEverywhereDataKeys;
import com.intellij.ide.util.EditSourceUtil;
import com.intellij.ide.util.gotoByName.ChooseByNameModel;
import com.intellij.ide.util.gotoByName.ChooseByNamePopup;
import com.intellij.ide.util.gotoByName.FilteringGotoByModel;
import com.intellij.navigation.NavigationItem;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataProvider;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileEditor.OpenFileDescriptor;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.util.ProgressIndicatorUtils;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.pom.Navigatable;
import com.intellij.psi.PsiElement;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.util.Processor;
import java.util.Optional;
import java.util.function.Function;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.JList;
import javax.swing.ListCellRenderer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class AbstractGotoSEContributor<F>
implements SearchEverywhereContributor<F> {
    protected static final Pattern patternToDetectLinesAndColumns = Pattern.compile("(.+?)(?::|@|,| |#|#L|\\?l=| on line | at line |:?\\(|:?\\[)(\\d+)?(?:\\W(\\d+)?)?[)\\]]?");
    protected static final Pattern patternToDetectAnonymousClasses = Pattern.compile("([\\.\\w]+)((\\$[\\d]+)*(\\$)?)");
    protected static final Pattern patternToDetectMembers = Pattern.compile("(.+)(#)(.*)");
    protected static final Pattern patternToDetectSignatures = Pattern.compile("(.+#.*)\\(.*\\)");
    private static final String fullMatchSearchSuffix = " ";
    @Nullable
    protected final Project myProject;
    @Nullable
    protected final PsiElement psiContext;
    private static final Logger LOG = Logger.getInstance(AbstractGotoSEContributor.class);

    protected AbstractGotoSEContributor(@Nullable Project project, @Nullable PsiElement context) {
        this.myProject = project;
        this.psiContext = context;
    }

    @NotNull
    public String getSearchProviderId() {
        return this.getClass().getSimpleName();
    }

    public boolean isShownInSeparateTab() {
        return true;
    }

    public void fetchElements(@NotNull String pattern, boolean everywhere, @Nullable SearchEverywhereContributorFilter<F> filter, @NotNull ProgressIndicator progressIndicator, @NotNull Function<Object, Boolean> consumer) {
        if (this.myProject == null) {
            return;
        }
        if (!this.isEmptyPatternSupported() && pattern.isEmpty()) {
            return;
        }
        if (!this.isDumbModeSupported() && DumbService.getInstance((Project)this.myProject).isDumb()) {
            return;
        }
        FilteringGotoByModel<F> model = this.createModel(this.myProject);
        if (filter != null) {
            model.setFilterItems(filter.getSelectedElements());
        }
        ProgressIndicatorUtils.yieldToPendingWriteActions();
        ProgressIndicatorUtils.runInReadActionWithWriteActionPriority(() -> {
            if (progressIndicator.isCanceled()) {
                return;
            }
            PsiElement context = this.psiContext != null && this.psiContext.isValid() ? this.psiContext : null;
            ChooseByNamePopup popup2 = ChooseByNamePopup.createPopup(this.myProject, (ChooseByNameModel)model, context);
            try {
                popup2.getProvider().filterElements(popup2, pattern, everywhere, progressIndicator, (Processor<Object>)((Processor)element -> {
                    if (progressIndicator.isCanceled()) {
                        return false;
                    }
                    if (element == null) {
                        LOG.error("Null returned from " + model + " in " + this);
                        return true;
                    }
                    return (Boolean)consumer.apply(element);
                }));
            }
            finally {
                Disposer.dispose((Disposable)popup2);
            }
        }, progressIndicator);
    }

    @NotNull
    protected abstract FilteringGotoByModel<F> createModel(@NotNull Project var1);

    @NotNull
    public String filterControlSymbols(@NotNull String pattern) {
        if (StringUtil.containsAnyChar((String)pattern, (String)":,;@[( #") || pattern.contains(" line ") || pattern.contains("?l=")) {
            return AbstractGotoSEContributor.applyPatternFilter(pattern, patternToDetectLinesAndColumns);
        }
        return pattern;
    }

    protected static String applyPatternFilter(String str, Pattern regex) {
        Matcher matcher = regex.matcher(str);
        if (matcher.matches()) {
            return matcher.group(1);
        }
        return str;
    }

    public boolean showInFindResults() {
        return true;
    }

    public boolean processSelectedItem(@NotNull Object selected, int modifiers, @NotNull String searchText) {
        if (selected instanceof PsiElement) {
            if (!((PsiElement)selected).isValid()) {
                LOG.warn("Cannot navigate to invalid PsiElement");
                return true;
            }
            PsiElement psiElement = this.preparePsi((PsiElement)selected, modifiers, searchText);
            Navigatable extNavigatable = this.createExtendedNavigatable(psiElement, searchText, modifiers);
            if (extNavigatable != null && extNavigatable.canNavigate()) {
                extNavigatable.navigate(true);
                return true;
            }
            NavigationUtil.activateFileWithPsiElement(psiElement, AbstractGotoSEContributor.openInCurrentWindow(modifiers));
        } else {
            EditSourceUtil.navigate((NavigationItem)((NavigationItem)selected), (boolean)true, (boolean)AbstractGotoSEContributor.openInCurrentWindow(modifiers));
        }
        return true;
    }

    public Object getDataForItem(@NotNull Object element, @NotNull String dataId) {
        if (CommonDataKeys.PSI_ELEMENT.is(dataId)) {
            if (element instanceof PsiElement) {
                return element;
            }
            if (element instanceof DataProvider) {
                return ((DataProvider)element).getData(dataId);
            }
        }
        if (SearchEverywhereDataKeys.ITEM_STRING_DESCRIPTION.is(dataId) && element instanceof PsiElement) {
            return QualifiedNameProviderUtil.getQualifiedName((PsiElement)element);
        }
        return null;
    }

    public boolean isMultiselectSupported() {
        return true;
    }

    @NotNull
    public ListCellRenderer getElementsRenderer(@NotNull JList<?> list2) {
        return new SERenderer(list2);
    }

    public int getElementPriority(@NotNull Object element, @NotNull String searchPattern) {
        return 50;
    }

    @Nullable
    protected Navigatable createExtendedNavigatable(PsiElement psi, String searchText, int modifiers) {
        boolean positionSpecified;
        VirtualFile file2 = PsiUtilCore.getVirtualFile((PsiElement)psi);
        Pair<Integer, Integer> position = AbstractGotoSEContributor.getLineAndColumn(searchText);
        boolean bl = positionSpecified = (Integer)position.first >= 0 || (Integer)position.second >= 0;
        if (file2 != null && positionSpecified) {
            OpenFileDescriptor descriptor = new OpenFileDescriptor(psi.getProject(), file2, ((Integer)position.first).intValue(), ((Integer)position.second).intValue());
            return descriptor.setUseCurrentWindow(AbstractGotoSEContributor.openInCurrentWindow(modifiers));
        }
        return null;
    }

    protected PsiElement preparePsi(PsiElement psiElement, int modifiers, String searchText) {
        return psiElement.getNavigationElement();
    }

    protected static Pair<Integer, Integer> getLineAndColumn(String text) {
        int line = AbstractGotoSEContributor.getLineAndColumnRegexpGroup(text, 2);
        int column = AbstractGotoSEContributor.getLineAndColumnRegexpGroup(text, 3);
        if (line == -1 && column != -1) {
            line = 0;
        }
        return new Pair((Object)line, (Object)column);
    }

    private static int getLineAndColumnRegexpGroup(String text, int groupNumber) {
        Matcher matcher = patternToDetectLinesAndColumns.matcher(text);
        if (matcher.matches()) {
            try {
                String group;
                if (groupNumber <= matcher.groupCount() && (group = matcher.group(groupNumber)) != null) {
                    return Integer.parseInt(group) - 1;
                }
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return -1;
    }

    protected static boolean openInCurrentWindow(int modifiers) {
        return (modifiers & 1) == 0;
    }

    protected static class SERenderer
    extends SearchEverywherePsiRenderer {
        public SERenderer(JList list2) {
            super(list2);
        }

        @Override
        public String getElementText(PsiElement element) {
            if (element instanceof NavigationItem) {
                return Optional.ofNullable(((NavigationItem)element).getPresentation()).map(presentation -> presentation.getPresentableText()).orElse(super.getElementText(element));
            }
            return super.getElementText(element);
        }
    }
}

