/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.actions.searcheverywhere;

import com.intellij.ide.IdeBundle;
import com.intellij.ide.actions.GotoActionAction;
import com.intellij.ide.actions.SetShortcutAction;
import com.intellij.ide.actions.searcheverywhere.SearchEverywhereContributor;
import com.intellij.ide.actions.searcheverywhere.SearchEverywhereContributorFactory;
import com.intellij.ide.actions.searcheverywhere.SearchEverywhereContributorFilter;
import com.intellij.ide.actions.searcheverywhere.SearchEverywhereDataKeys;
import com.intellij.ide.ui.search.BooleanOptionDescription;
import com.intellij.ide.ui.search.OptionDescription;
import com.intellij.ide.util.gotoByName.GotoActionItemProvider;
import com.intellij.ide.util.gotoByName.GotoActionModel;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.PlatformDataKeys;
import com.intellij.openapi.actionSystem.ShortcutSet;
import com.intellij.openapi.actionSystem.ToggleAction;
import com.intellij.openapi.actionSystem.ex.QuickList;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.keymap.Keymap;
import com.intellij.openapi.keymap.KeymapManager;
import com.intellij.openapi.keymap.KeymapUtil;
import com.intellij.openapi.keymap.impl.ActionShortcutRestrictions;
import com.intellij.openapi.keymap.impl.ui.KeymapPanel;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.wm.WindowManager;
import com.intellij.util.Processor;
import java.awt.Component;
import java.awt.KeyboardFocusManager;
import java.awt.Window;
import java.util.Optional;
import java.util.function.Function;
import javax.swing.JList;
import javax.swing.ListCellRenderer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ActionSearchEverywhereContributor
implements SearchEverywhereContributor<Void> {
    private static final Logger LOG = Logger.getInstance(ActionSearchEverywhereContributor.class);
    private final Project myProject;
    private final Component myContextComponent;
    private final GotoActionModel myModel;
    private final GotoActionItemProvider myProvider;

    public ActionSearchEverywhereContributor(Project project, Component contextComponent, Editor editor) {
        this.myProject = project;
        this.myContextComponent = contextComponent;
        this.myModel = new GotoActionModel(project, contextComponent, editor);
        this.myProvider = new GotoActionItemProvider(this.myModel);
    }

    @NotNull
    public String getGroupName() {
        return "Actions";
    }

    @NotNull
    public String getAdvertisement() {
        ShortcutSet altEnterShortcutSet = KeymapUtil.getActiveKeymapShortcuts((String)"ShowIntentionActions");
        String altEnter = KeymapUtil.getFirstKeyboardShortcutText((ShortcutSet)altEnterShortcutSet);
        return "Press " + altEnter + " to assign a shortcut";
    }

    public String includeNonProjectItemsText() {
        return IdeBundle.message((String)"checkbox.disabled.included", (Object[])new Object[0]);
    }

    public int getSortWeight() {
        return 400;
    }

    public boolean isShownInSeparateTab() {
        return true;
    }

    public void fetchElements(@NotNull String pattern, boolean everywhere, @Nullable SearchEverywhereContributorFilter<Void> filter, @NotNull ProgressIndicator progressIndicator, @NotNull Function<Object, Boolean> consumer) {
        if (StringUtil.isEmptyOrSpaces((String)pattern)) {
            return;
        }
        this.myProvider.filterElements(pattern, (Processor<GotoActionModel.MatchedValue>)((Processor)element -> {
            if (progressIndicator.isCanceled()) {
                return false;
            }
            if (!everywhere && element.value instanceof GotoActionModel.ActionWrapper && !((GotoActionModel.ActionWrapper)element.value).isAvailable()) {
                return true;
            }
            if (element == null) {
                LOG.error("Null action has been returned from model");
                return true;
            }
            return (Boolean)consumer.apply(element);
        }));
    }

    @NotNull
    public ListCellRenderer getElementsRenderer(@NotNull JList<?> list2) {
        return new GotoActionModel.GotoActionListCellRenderer((com.intellij.util.Function<? super OptionDescription, String>)((com.intellij.util.Function)this.myModel::getGroupName), true);
    }

    public boolean showInFindResults() {
        return false;
    }

    @NotNull
    public String getSearchProviderId() {
        return ActionSearchEverywhereContributor.class.getSimpleName();
    }

    public Object getDataForItem(@NotNull Object element, @NotNull String dataId) {
        AnAction action;
        if (SetShortcutAction.SELECTED_ACTION.is(dataId)) {
            return ActionSearchEverywhereContributor.getAction((GotoActionModel.MatchedValue)element);
        }
        if (SearchEverywhereDataKeys.ITEM_STRING_DESCRIPTION.is(dataId) && (action = ActionSearchEverywhereContributor.getAction((GotoActionModel.MatchedValue)element)) != null) {
            String description = action.getTemplatePresentation().getDescription();
            if (Registry.is((String)"show.configurables.ids.in.settings.always")) {
                String presentableId = StringUtil.notNullize((String)ActionManager.getInstance().getId(action), (String)("class: " + action.getClass().getName()));
                return String.format("[%s] %s", presentableId, StringUtil.notNullize((String)description));
            }
            return description;
        }
        return null;
    }

    public boolean processSelectedItem(@NotNull Object selected, int modifiers, @NotNull String text) {
        if (modifiers == 8) {
            this.showAssignShortcutDialog((GotoActionModel.MatchedValue)selected);
            return true;
        }
        selected = ((GotoActionModel.MatchedValue)selected).value;
        if (selected instanceof BooleanOptionDescription) {
            BooleanOptionDescription option2;
            option2.setOptionState(!(option2 = (BooleanOptionDescription)selected).isOptionEnabled());
            return false;
        }
        GotoActionAction.openOptionOrPerformAction(selected, text, this.myProject, this.myContextComponent);
        boolean inplaceChange = selected instanceof GotoActionModel.ActionWrapper && ((GotoActionModel.ActionWrapper)selected).getAction() instanceof ToggleAction;
        return !inplaceChange;
    }

    @Nullable
    private static AnAction getAction(@NotNull GotoActionModel.MatchedValue element) {
        Comparable value = element.value;
        if (value instanceof GotoActionModel.ActionWrapper) {
            value = ((GotoActionModel.ActionWrapper)value).getAction();
        }
        return value instanceof AnAction ? (AnAction)value : null;
    }

    private void showAssignShortcutDialog(@NotNull GotoActionModel.MatchedValue value) {
        AnAction action = ActionSearchEverywhereContributor.getAction(value);
        if (action == null) {
            return;
        }
        String id = ActionManager.getInstance().getId(action);
        Keymap activeKeymap = Optional.ofNullable(KeymapManager.getInstance()).map(KeymapManager::getActiveKeymap).orElse(null);
        if (activeKeymap == null) {
            return;
        }
        ApplicationManager.getApplication().invokeLater(() -> {
            Window window;
            Window window2 = window = this.myProject != null ? WindowManager.getInstance().suggestParentWindow(this.myProject) : KeyboardFocusManager.getCurrentKeyboardFocusManager().getFocusedWindow();
            if (window == null) {
                return;
            }
            KeymapPanel.addKeyboardShortcut(id, ActionShortcutRestrictions.getInstance().getForActionId(id), activeKeymap, window, new QuickList[0]);
        });
    }

    public static class Factory
    implements SearchEverywhereContributorFactory<Void> {
        @NotNull
        public SearchEverywhereContributor<Void> createContributor(AnActionEvent initEvent) {
            return new ActionSearchEverywhereContributor(initEvent.getProject(), (Component)initEvent.getData(PlatformDataKeys.CONTEXT_COMPONENT), (Editor)initEvent.getData(CommonDataKeys.EDITOR));
        }

        @Nullable
        public SearchEverywhereContributorFilter<Void> createFilter(AnActionEvent initEvent) {
            return null;
        }
    }
}

